/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.project13.jgit.DescribeCommand;
import pl.project13.jgit.DescribeResult;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.GitDirLocator;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.MavenLoggerBridge;

public class GitCommitIdMojo
extends AbstractMojo {
    public static final String BRANCH = "branch";
    public static final String COMMIT_ID = "commit.id";
    public static final String COMMIT_ID_ABBREV = "commit.id.abbrev";
    public static final String COMMIT_DESCRIBE = "commit.id.describe";
    public static final String BUILD_AUTHOR_NAME = "build.user.name";
    public static final String BUILD_AUTHOR_EMAIL = "build.user.email";
    public static final String BUILD_TIME = "build.time";
    public static final String COMMIT_AUTHOR_NAME = "commit.user.name";
    public static final String COMMIT_AUTHOR_EMAIL = "commit.user.email";
    public static final String COMMIT_MESSAGE_FULL = "commit.message.full";
    public static final String COMMIT_MESSAGE_SHORT = "commit.message.short";
    public static final String COMMIT_TIME = "commit.time";
    public static final String REMOTE_ORIGIN_URL = "remote.origin.url";
    MavenProject project;
    private List<MavenProject> reactorProjects;
    private boolean injectAllReactorProjects;
    private boolean verbose;
    private boolean skipPoms;
    private boolean generateGitPropertiesFile;
    private String generateGitPropertiesFilename;
    private File dotGitDirectory;
    private GitDescribeConfig gitDescribe;
    private int abbrevLength;
    private String format;
    private String prefix;
    private String prefixDot;
    private String dateFormat;
    private boolean failOnNoGitDirectory;
    private boolean failOnUnableToExtractRepoInfo;
    private boolean skip = false;
    private List<String> excludeProperties = Collections.emptyList();
    private Properties properties;
    boolean runningTests = false;
    @NotNull
    LoggerBridge loggerBridge = new MavenLoggerBridge(this.getLog(), true);
    static int counter;

    public void execute() throws MojoExecutionException {
        this.loggerBridge.setVerbose(this.verbose);
        if (this.skip) {
            this.log("skip is true, return");
            return;
        }
        if (this.isPomProject(this.project) && this.skipPoms) {
            this.log("isPomProject is true and skipPoms is true, return");
            return;
        }
        this.dotGitDirectory = this.lookupGitDirectory();
        this.throwWhenRequiredDirectoryNotFound(this.dotGitDirectory, this.failOnNoGitDirectory, ".git directory could not be found! Please specify a valid [dotGitDirectory] in your pom.xml");
        if (this.dotGitDirectory == null) {
            this.log("dotGitDirectory is null, aborting execution!");
            return;
        }
        this.log("dotGitDirectory", this.dotGitDirectory.getAbsolutePath());
        try {
            this.properties = this.initProperties();
            this.prefixDot = this.prefix + ".";
            this.loadGitData(this.properties);
            this.filterNot(this.properties, this.excludeProperties);
            this.loadBuildTimeData(this.properties);
            this.logProperties(this.properties);
            if (this.generateGitPropertiesFile) {
                this.generatePropertiesFile(this.properties, this.project.getBasedir(), this.generateGitPropertiesFilename);
            }
            if (this.injectAllReactorProjects) {
                this.appendPropertiesToReactorProjects(this.properties);
            }
        }
        catch (IOException e) {
            this.handlePluginFailure(e);
        }
    }

    private void filterNot(Properties properties, @Nullable List<String> exclusions) {
        if (exclusions == null) {
            return;
        }
        List excludePredicates = Lists.transform(exclusions, (Function)new Function<String, Predicate<CharSequence>>(){

            public Predicate<CharSequence> apply(String exclude) {
                return Predicates.containsPattern((String)exclude);
            }
        });
        Predicate shouldExclude = Predicates.alwaysFalse();
        for (Predicate predicate : excludePredicates) {
            shouldExclude = Predicates.or((Predicate)shouldExclude, (Predicate)predicate);
        }
        for (String key : properties.stringPropertyNames()) {
            if (!shouldExclude.apply((Object)key)) continue;
            System.out.println("shouldExclude.apply(" + key + ") = " + shouldExclude.apply((Object)key));
            properties.remove(key);
        }
    }

    private void handlePluginFailure(Exception e) throws MojoExecutionException {
        if (this.failOnUnableToExtractRepoInfo) {
            throw new MojoExecutionException("Could not complete Mojo execution...", e);
        }
        this.loggerBridge.error(e.getMessage());
    }

    private void appendPropertiesToReactorProjects(@NotNull Properties properties) {
        for (MavenProject mavenProject : this.reactorProjects) {
            Properties mavenProperties = mavenProject.getProperties();
            this.log(mavenProject.getName(), "] project", mavenProject.getName());
            for (Object key : properties.keySet()) {
                mavenProperties.put(key, properties.get(key));
            }
        }
    }

    private void throwWhenRequiredDirectoryNotFound(File dotGitDirectory, Boolean required, String message) throws MojoExecutionException {
        if (required.booleanValue() && this.directoryDoesNotExits(dotGitDirectory)) {
            throw new MojoExecutionException(message);
        }
    }

    private File lookupGitDirectory() throws MojoExecutionException {
        return new GitDirLocator(this.project, this.reactorProjects).lookupGitDirectory(this.dotGitDirectory);
    }

    private Properties initProperties() throws MojoExecutionException {
        if (this.generateGitPropertiesFile) {
            this.properties = new Properties();
            return this.properties;
        }
        if (!this.runningTests) {
            this.properties = this.project.getProperties();
            return this.properties;
        }
        this.properties = new Properties();
        return this.properties;
    }

    private void logProperties(@NotNull Properties properties) {
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            if (!this.isOurProperty(keyString)) continue;
            this.log("found property", keyString);
        }
    }

    private boolean isOurProperty(@NotNull String keyString) {
        return keyString.startsWith(this.prefixDot);
    }

    void loadBuildTimeData(@NotNull Properties properties) {
        Date commitDate = new Date();
        SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
        this.put(properties, BUILD_TIME, smf.format(commitDate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadGitData(@NotNull Properties properties) throws IOException, MojoExecutionException {
        Repository git = this.getGitRepository();
        ObjectReader objectReader = git.newObjectReader();
        String userName = git.getConfig().getString("user", null, "name");
        this.put(properties, BUILD_AUTHOR_NAME, userName);
        String userEmail = git.getConfig().getString("user", null, "email");
        this.put(properties, BUILD_AUTHOR_EMAIL, userEmail);
        Ref HEAD = git.getRef("HEAD");
        if (HEAD == null) {
            throw new MojoExecutionException("Could not get HEAD Ref, are you sure you've set the dotGitDirectory property of this plugin to a valid path?");
        }
        RevWalk revWalk = new RevWalk(git);
        RevCommit headCommit = revWalk.parseCommit((AnyObjectId)HEAD.getObjectId());
        revWalk.markStart(headCommit);
        try {
            String branch = this.determineBranchName(git, System.getenv());
            this.put(properties, BRANCH, branch);
            this.maybePutGitDescribe(properties, git);
            this.put(properties, COMMIT_ID, headCommit.getName());
            this.putAbbrevCommitId(objectReader, properties, headCommit, this.abbrevLength);
            String commitAuthor = headCommit.getAuthorIdent().getName();
            this.put(properties, COMMIT_AUTHOR_NAME, commitAuthor);
            String commitEmail = headCommit.getAuthorIdent().getEmailAddress();
            this.put(properties, COMMIT_AUTHOR_EMAIL, commitEmail);
            String fullMessage = headCommit.getFullMessage();
            this.put(properties, COMMIT_MESSAGE_FULL, fullMessage);
            String shortMessage = headCommit.getShortMessage();
            this.put(properties, COMMIT_MESSAGE_SHORT, shortMessage);
            long timeSinceEpoch = headCommit.getCommitTime();
            Date commitDate = new Date(timeSinceEpoch * 1000L);
            SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
            this.put(properties, COMMIT_TIME, smf.format(commitDate));
            String remoteOriginUrl = git.getConfig().getString("remote", "origin", "url");
            this.put(properties, REMOTE_ORIGIN_URL, remoteOriginUrl);
        }
        finally {
            revWalk.dispose();
        }
    }

    private void putAbbrevCommitId(ObjectReader objectReader, Properties properties, RevCommit headCommit, int abbrevLength) throws MojoExecutionException {
        if (abbrevLength < 2 || abbrevLength > 40) {
            throw new MojoExecutionException("Abbreviated commit id lenght must be between 2 and 40, inclusive! Was [%s]. ".codePointBefore(abbrevLength) + "Please fix your configuration (the <abbrevLength/> element).");
        }
        try {
            AbbreviatedObjectId abbreviatedObjectId = objectReader.abbreviate((AnyObjectId)headCommit, abbrevLength);
            this.put(properties, COMMIT_ID_ABBREV, abbreviatedObjectId.name());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to abbreviate commit id! You may want to investigate the <abbrevLength/> element in your configuration.", (Exception)e);
        }
    }

    void maybePutGitDescribe(@NotNull Properties properties, @NotNull Repository repository) throws MojoExecutionException {
        if (this.gitDescribe == null || !this.gitDescribe.isSkip()) {
            this.putGitDescribe(properties, repository);
        }
    }

    @VisibleForTesting
    void putGitDescribe(@NotNull Properties properties, @NotNull Repository repository) throws MojoExecutionException {
        try {
            DescribeResult describeResult = DescribeCommand.on(repository).withLoggerBridge(this.loggerBridge).setVerbose(this.verbose).apply(this.gitDescribe).call();
            this.put(properties, COMMIT_DESCRIBE, describeResult.toString());
        }
        catch (GitAPIException ex) {
            throw new MojoExecutionException("Unable to obtain git.commit.id.describe information", (Exception)((Object)ex));
        }
    }

    void generatePropertiesFile(@NotNull Properties properties, File base, String propertiesFilename) throws IOException {
        FileWriter fileWriter;
        block5: {
            fileWriter = null;
            File gitPropsFile = new File(base, propertiesFilename);
            try {
                Files.createParentDirs((File)gitPropsFile);
                fileWriter = new FileWriter(gitPropsFile);
                if ("json".equalsIgnoreCase(this.format)) {
                    this.log("Writing json file to [", gitPropsFile.getAbsolutePath(), "] (for module ", this.project.getName() + ++counter, ")...");
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.writeValue((Writer)fileWriter, (Object)properties);
                    break block5;
                }
                this.log("Writing properties file to [", gitPropsFile.getAbsolutePath(), "] (for module ", this.project.getName() + ++counter, ")...");
                properties.store(fileWriter, "Generated by Git-Commit-Id-Plugin");
            }
            catch (IOException ex) {
                try {
                    throw new RuntimeException("Cannot create custom git properties file: " + gitPropsFile, ex);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(fileWriter);
                    throw throwable;
                }
            }
        }
        Closeables.closeQuietly((Closeable)fileWriter);
    }

    boolean isPomProject(@NotNull MavenProject project) {
        return project.getPackaging().equalsIgnoreCase("pom");
    }

    @NotNull
    private Repository getGitRepository() throws MojoExecutionException {
        FileRepository repository;
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.setGitDir(this.dotGitDirectory)).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not initialize repository...", (Exception)e);
        }
        if (repository == null) {
            throw new MojoExecutionException("Could not create git repository. Are you sure '" + this.dotGitDirectory + "' is the valid Git root for your project?");
        }
        return repository;
    }

    private void put(@NotNull Properties properties, String key, String value) {
        this.putWithoutPrefix(properties, this.prefixDot + key, value);
    }

    private void putWithoutPrefix(@NotNull Properties properties, String key, String value) {
        if (!this.isNotEmpty(value)) {
            value = "Unknown";
        }
        this.log(key, value);
        properties.put(key, value);
    }

    private boolean isNotEmpty(@Nullable String value) {
        return null != value && !" ".equals(value.trim().replaceAll(" ", ""));
    }

    void log(String ... parts) {
        this.loggerBridge.log(parts);
    }

    private boolean directoryExists(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }

    private boolean directoryDoesNotExits(File fileLocation) {
        return !this.directoryExists(fileLocation);
    }

    protected String determineBranchName(Repository git, Map<String, String> env) throws IOException {
        if (this.runningOnBuildServer(env)) {
            return this.determineBranchNameOnBuildServer(git, env);
        }
        return git.getBranch();
    }

    protected String determineBranchNameOnBuildServer(Repository git, Map<String, String> env) throws IOException {
        String enviromentBasedBranch = env.get("GIT_BRANCH");
        if (Strings.isNullOrEmpty((String)enviromentBasedBranch)) {
            this.log("Detected that running on CI enviroment, but using repository branch, no GIT_BRANCH detected.");
            return git.getBranch();
        }
        this.log("Using environment variable based branch name.", "GIT_BRANCH =", enviromentBasedBranch);
        return enviromentBasedBranch;
    }

    private boolean runningOnBuildServer(Map<String, String> env) {
        return env.containsKey("HUDSON_URL") || env.containsKey("JENKINS_URL");
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDotGitDirectory(File dotGitDirectory) {
        this.dotGitDirectory = dotGitDirectory;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setGitDescribe(GitDescribeConfig gitDescribe) {
        this.gitDescribe = gitDescribe;
    }

    public void setAbbrevLength(int abbrevLength) {
        this.abbrevLength = abbrevLength;
    }

    public void setExcludeProperties(List<String> excludeProperties) {
        this.excludeProperties = excludeProperties;
    }
}

