/*
 * Decompiled with CFR 0.152.
 */
package com.chibde.visualizer;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.chibde.BaseVisualizer;

public class CircleVisualizer
extends BaseVisualizer {
    private float[] points;
    private float radiusMultiplier = 1.0f;
    private float strokeWidth = 0.005f;

    public CircleVisualizer(Context context) {
        super(context);
    }

    public CircleVisualizer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CircleVisualizer(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
    }

    public void setStrokeWidth(int strokeWidth) {
        if (strokeWidth > 10) {
            this.strokeWidth = 0.049999997f;
        } else if (strokeWidth < 1) {
            this.strokeWidth = 0.005f;
        }
        this.strokeWidth = (float)strokeWidth * 0.005f;
    }

    public void setRadiusMultiplier(float radiusMultiplier) {
        this.radiusMultiplier = radiusMultiplier;
    }

    protected void onDraw(Canvas canvas) {
        if (this.bytes != null) {
            this.paint.setStrokeWidth((float)this.getHeight() * this.strokeWidth);
            if (this.points == null || this.points.length < this.bytes.length * 4) {
                this.points = new float[this.bytes.length * 4];
            }
            double angle = 0.0;
            int i = 0;
            while (i < 360) {
                this.points[i * 4] = (float)((double)(this.getWidth() / 2) + (double)((float)Math.abs(this.bytes[i * 2]) * this.radiusMultiplier) * Math.cos(Math.toRadians(angle)));
                this.points[i * 4 + 1] = (float)((double)(this.getHeight() / 2) + (double)((float)Math.abs(this.bytes[i * 2]) * this.radiusMultiplier) * Math.sin(Math.toRadians(angle)));
                this.points[i * 4 + 2] = (float)((double)(this.getWidth() / 2) + (double)((float)Math.abs(this.bytes[i * 2 + 1]) * this.radiusMultiplier) * Math.cos(Math.toRadians(angle + 1.0)));
                this.points[i * 4 + 3] = (float)((double)(this.getHeight() / 2) + (double)((float)Math.abs(this.bytes[i * 2 + 1]) * this.radiusMultiplier) * Math.sin(Math.toRadians(angle + 1.0)));
                ++i;
                angle += 1.0;
            }
            canvas.drawLines(this.points, this.paint);
        }
        super.onDraw(canvas);
    }
}

