/*
 * Decompiled with CFR 0.152.
 */
package com.chibde;

import android.content.Context;
import android.graphics.Paint;
import android.media.MediaPlayer;
import android.media.audiofx.Visualizer;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;

public abstract class BaseVisualizer
extends View {
    protected byte[] bytes;
    protected Paint paint;
    protected Visualizer visualizer;
    protected int color = -16776961;

    public BaseVisualizer(Context context) {
        super(context);
        this.init(null);
        this.init();
    }

    public BaseVisualizer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
        this.init();
    }

    public BaseVisualizer(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
        this.init();
    }

    private void init(AttributeSet attributeSet) {
        this.paint = new Paint();
    }

    public void setColor(int color) {
        this.color = color;
        this.paint.setColor(this.color);
    }

    @Deprecated
    public void setPlayer(MediaPlayer mediaPlayer) {
        this.setPlayer(mediaPlayer.getAudioSessionId());
    }

    public void setPlayer(int audioSessionId) {
        this.visualizer = new Visualizer(audioSessionId);
        this.visualizer.setEnabled(false);
        this.visualizer.setCaptureSize(Visualizer.getCaptureSizeRange()[1]);
        this.visualizer.setDataCaptureListener(new Visualizer.OnDataCaptureListener(){

            public void onWaveFormDataCapture(Visualizer visualizer, byte[] bytes, int samplingRate) {
                BaseVisualizer.this.bytes = bytes;
                BaseVisualizer.this.invalidate();
            }

            public void onFftDataCapture(Visualizer visualizer, byte[] bytes, int samplingRate) {
            }
        }, Visualizer.getMaxCaptureRate() / 2, true, false);
        this.visualizer.setEnabled(true);
    }

    public void release() {
        if (this.visualizer == null) {
            return;
        }
        this.visualizer.release();
        this.bytes = null;
        this.invalidate();
    }

    public Visualizer getVisualizer() {
        return this.visualizer;
    }

    protected abstract void init();
}

