/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.vpc.v3.region;

import com.g42cloud.sdk.core.region.IRegionProvider;
import com.g42cloud.sdk.core.region.Region;
import com.g42cloud.sdk.core.region.RegionProviderChain;
import com.g42cloud.sdk.core.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class VpcRegion {
    public static final Region AE_AD_1 = new Region("ae-ad-1", new String[]{"https://vpc.ae-ad-1.g42cloud.com"});
    private static final IRegionProvider PROVIDER = RegionProviderChain.getDefaultRegionProviderChain((String)"VPC");
    private static final Map<String, Region> STATIC_FIELDS = VpcRegion.createStaticFields();

    private static Map<String, Region> createStaticFields() {
        HashMap<String, Region> map = new HashMap<String, Region>();
        map.put("ae-ad-1", AE_AD_1);
        return Collections.unmodifiableMap(map);
    }

    public static Region valueOf(String regionId) {
        if (StringUtils.isEmpty((CharSequence)regionId)) {
            throw new IllegalArgumentException("Unexpected empty parameter: regionId.");
        }
        Region result = PROVIDER.getRegion(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        result = STATIC_FIELDS.get(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        throw new IllegalArgumentException("Unexpected regionId: " + regionId);
    }
}

