/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.retry;

import com.g42cloud.sdk.core.exception.SdkException;

public final class RetryContext<T> {
    private final int retriesAttempted;
    private final int statusCode;
    private final T lastResponse;
    private final SdkException lastException;

    private RetryContext(int retriesAttempted, int statusCode, T lastResponse, SdkException lastException) {
        this.retriesAttempted = retriesAttempted;
        this.statusCode = statusCode;
        this.lastResponse = lastResponse;
        this.lastException = lastException;
    }

    public int getRetriesAttempted() {
        return this.retriesAttempted;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public T getLastResponse() {
        return this.lastResponse;
    }

    public SdkException getLastException() {
        return this.lastException;
    }

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    public static class Builder<S> {
        private int retriesAttempted;
        private int statusCode;
        private S lastResponse;
        private SdkException lastException;

        private Builder() {
        }

        public Builder<S> withRetriesAttempted(int retriesAttempted) {
            this.retriesAttempted = retriesAttempted;
            return this;
        }

        public Builder<S> withStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder<S> withLastResponse(S lastResponse) {
            this.lastResponse = lastResponse;
            return this;
        }

        public Builder<S> withLastException(SdkException lastException) {
            this.lastException = lastException;
            return this;
        }

        public RetryContext<S> build() {
            return new RetryContext(this.retriesAttempted, this.statusCode, this.lastResponse, this.lastException);
        }
    }
}

