/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.progress;

import com.g42cloud.sdk.core.exception.SdkException;
import com.g42cloud.sdk.core.progress.ProgressManager;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends FilterInputStream {
    private boolean readFlag;
    private final ProgressManager progressManager;
    private final boolean endFlag;

    public ProgressInputStream(InputStream in, ProgressManager progressManager) {
        this(in, progressManager, true);
    }

    public ProgressInputStream(InputStream in, ProgressManager progressManager, boolean endFlag) {
        super(in);
        this.progressManager = progressManager;
        this.endFlag = endFlag;
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    protected final void abortWhileThreadIsInterrupted() {
        if (Thread.interrupted()) {
            throw new SdkException("Abort io due to thread interrupted");
        }
    }

    @Override
    public synchronized void mark(int a) {
        this.abortWhileThreadIsInterrupted();
    }

    @Override
    public synchronized void reset() {
        throw new SdkException("UnRepeatable");
    }

    @Override
    public long skip(long n) throws IOException {
        this.abortWhileThreadIsInterrupted();
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.abortWhileThreadIsInterrupted();
        return super.available();
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
            this.abortWhileThreadIsInterrupted();
        }
        finally {
            if (this.endFlag) {
                this.progressManager.progressEnd();
            }
        }
    }

    @Override
    public int read() throws IOException {
        this.abortWhileThreadIsInterrupted();
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.abortWhileThreadIsInterrupted();
        if (!this.readFlag) {
            this.readFlag = true;
            this.progressManager.progressStart();
        }
        int bytes = super.read(b, off, len);
        this.progressManager.progressChanged(bytes);
        return bytes;
    }
}

