/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.invoker;

import com.g42cloud.sdk.core.HcClient;
import com.g42cloud.sdk.core.auth.ICredential;
import com.g42cloud.sdk.core.exception.ConnectionException;
import com.g42cloud.sdk.core.exception.SdkException;
import com.g42cloud.sdk.core.exchange.SdkExchange;
import com.g42cloud.sdk.core.http.HttpRequestDef;
import com.g42cloud.sdk.core.retry.RetryRecord;
import com.g42cloud.sdk.core.retry.backoff.BackoffStrategy;
import com.g42cloud.sdk.core.retry.backoff.SdkBackoffStrategy;
import com.g42cloud.sdk.core.utils.ValidationUtils;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class BaseInvoker<R, S, D extends BaseInvoker<R, S, D>> {
    SdkExchange exchange = new SdkExchange().withApiReference(apiReference -> apiReference.withName(meta.getName()).withMethod(meta.getMethod().toString()).withUri(meta.getUri()));
    HcClient hcClient;
    HttpRequestDef<R, S> meta;
    R req;
    Map<String, String> extraHeader;
    int retryTimes;
    BiFunction<S, SdkException, Boolean> func;
    BackoffStrategy backoffStrategy;
    public static final int MAX_RETRY_TIME = 30;

    public BaseInvoker(R req, HttpRequestDef<R, S> meta, HcClient hcClient) {
        this.hcClient = hcClient;
        this.meta = meta;
        this.req = req;
    }

    public <T extends ICredential> D replaceCredentialWhen(Class<T> clazz, Consumer<T> func) {
        ICredential credential = this.hcClient.getCredential().deepClone();
        if (clazz.isAssignableFrom(credential.getClass())) {
            func.accept(credential);
            this.hcClient = this.hcClient.overrideCredential(credential);
        }
        return (D)this;
    }

    public D addHeader(String headerKey, String headerValue) {
        if (Objects.isNull(this.extraHeader)) {
            this.extraHeader = new TreeMap<String, String>();
        }
        this.extraHeader.put(headerKey, headerValue);
        return this.toDerivedT();
    }

    public D withExchange(Consumer<SdkExchange> func) {
        if (Objects.nonNull(func)) {
            func.accept(this.exchange);
        }
        return this.toDerivedT();
    }

    public D withRetry(int retryTimes, BiFunction<S, SdkException, Boolean> func) {
        return this.withRetry(retryTimes, func, this.backoffStrategy);
    }

    public D withRetry(int retryTimes, BiFunction<S, SdkException, Boolean> func, BackoffStrategy backoffStrategy) {
        this.retryTimes = ValidationUtils.assertIntIsInRange(retryTimes, 0, 30, "retryTimes");
        this.func = func;
        this.initBackoffStrategy(backoffStrategy);
        return this.toDerivedT();
    }

    public D retryTimes(int retryTimes) {
        this.retryTimes = ValidationUtils.assertIntIsInRange(retryTimes, 0, 30, "retryTimes");
        return this.toDerivedT();
    }

    public D retryCondition(BiFunction<S, SdkException, Boolean> func) {
        this.func = func;
        return this.toDerivedT();
    }

    public D backoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
        return this.toDerivedT();
    }

    public static <S> BiFunction<S, SdkException, Boolean> defaultRetryCondition() {
        return (resp, exception) -> {
            if (Objects.nonNull(exception)) {
                return ConnectionException.class.isAssignableFrom(exception.getClass());
            }
            return false;
        };
    }

    public void initBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = Objects.isNull(backoffStrategy) ? (Objects.nonNull(this.func) ? SdkBackoffStrategy.getDefaultBackoffStrategy() : BackoffStrategy.NO_BACKOFF) : backoffStrategy;
    }

    CompletableFuture<S> retry(Supplier<CompletableFuture<S>> work) {
        CompletableFuture future = new CompletableFuture();
        this.initBackoffStrategy(this.backoffStrategy);
        RetryRecord<Object> record = new RetryRecord<Object>(this.retryTimes, this.func, this.backoffStrategy);
        record.setFuture(future);
        record.setWorkSupplier(work);
        record.schedule();
        return future;
    }

    private D toDerivedT() {
        return (D)this;
    }
}

