/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.auth;

import com.g42cloud.sdk.core.auth.ISigningKey;
import com.g42cloud.sdk.core.auth.P256SHA256Signer;
import com.g42cloud.sdk.core.auth.SM3Hasher;
import com.g42cloud.sdk.core.exception.SdkException;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM2SM3Signer
extends P256SHA256Signer {
    private static volatile SM2SM3Signer instance;

    protected SM2SM3Signer() {
        this.algorithm = "SDK-SM2-SM3";
        this.contentHeader = "X-Sdk-Content-Sm3";
        this.emptyHash = "1ab21d8355cfa17f8e61194831e81a8f22bec8c728fefb747ed035eb5082aa2b";
        this.hasher = new SM3Hasher();
        this.ecSpec = ECNamedCurveTable.getParameterSpec((String)"sm2p256v1");
        this.nMinusTwo = this.ecSpec.getN().subtract(BigInteger.valueOf(2L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SM2SM3Signer getInstance() {
        if (Objects.nonNull(instance)) {
            return instance;
        }
        Class<SM2SM3Signer> clazz = SM2SM3Signer.class;
        synchronized (SM2SM3Signer.class) {
            if (instance == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                instance = new SM2SM3Signer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected ISigningKey initSigningKey(ECPrivateKeyParameters privateKeyParameters, ECPublicKeyParameters publicKeyParameters) {
        return new SM2SigningKey(privateKeyParameters, publicKeyParameters);
    }

    class SM2SigningKey
    extends P256SHA256Signer.P256SigningKey {
        SM2SigningKey(ECPrivateKeyParameters privateKeyParameters, ECPublicKeyParameters publicKeyParameters) {
            super(privateKeyParameters, publicKeyParameters);
        }

        @Override
        public byte[] sign(byte[] data) {
            SM2Signer signer = new SM2Signer();
            signer.init(true, (CipherParameters)this.privateKeyParameters);
            signer.update(data, 0, data.length);
            try {
                return signer.generateSignature();
            }
            catch (CryptoException e) {
                throw new SdkException("failed to generate signature with SM2Signer", e);
            }
        }

        @Override
        public boolean verify(byte[] signature, byte[] data) {
            SM2Signer signer = new SM2Signer();
            signer.init(false, (CipherParameters)this.publicKeyParameters);
            signer.update(data, 0, data.length);
            return signer.verifySignature(signature);
        }
    }
}

