/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.auth;

import com.g42cloud.sdk.core.auth.BasicCredentials;
import com.g42cloud.sdk.core.auth.GlobalCredentials;
import com.g42cloud.sdk.core.auth.ICredential;
import com.g42cloud.sdk.core.auth.ICredentialProvider;
import com.g42cloud.sdk.core.exception.SdkException;
import com.g42cloud.sdk.core.utils.StringUtils;
import java.util.Locale;

public class MetadataCredentialProvider
implements ICredentialProvider {
    private final String credentialType;

    public MetadataCredentialProvider(String credentialType) {
        this.credentialType = credentialType.toLowerCase(Locale.ROOT);
    }

    public static MetadataCredentialProvider getBasicCredentialMetadataProvider() {
        return new MetadataCredentialProvider("basic");
    }

    public static MetadataCredentialProvider getGlobalCredentialMetadataProvider() {
        return new MetadataCredentialProvider("global");
    }

    @Override
    public ICredential getCredentials() {
        if (StringUtils.isEmpty(this.credentialType)) {
            throw new SdkException("credential type is empty");
        }
        if (this.credentialType.startsWith("basic")) {
            BasicCredentials credentials = new BasicCredentials();
            credentials.updateSecurityTokenFromMetadata();
            return credentials;
        }
        if (this.credentialType.startsWith("global")) {
            GlobalCredentials credentials = new GlobalCredentials();
            credentials.updateSecurityTokenFromMetadata();
            return credentials;
        }
        throw new SdkException("unsupported credential type: " + this.credentialType);
    }
}

