/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.auth;

import com.g42cloud.sdk.core.auth.AbstractCredentials;
import com.g42cloud.sdk.core.auth.BasicCredentials;
import com.g42cloud.sdk.core.auth.GlobalCredentials;
import com.g42cloud.sdk.core.auth.ICredential;
import com.g42cloud.sdk.core.auth.ICredentialProvider;
import com.g42cloud.sdk.core.exception.SdkException;
import com.g42cloud.sdk.core.utils.StringUtils;
import java.util.Locale;
import java.util.Objects;

public class EnvCredentialProvider
implements ICredentialProvider {
    private static final String AK_ENV_NAME = "G42CLOUD_SDK_AK";
    private static final String SK_ENV_NAME = "G42CLOUD_SDK_SK";
    private static final String PROJECT_ID_ENV_NAME = "G42CLOUD_SDK_PROJECT_ID";
    private static final String DOMAIN_ID_ENV_NAME = "G42CLOUD_SDK_DOMAIN_ID";
    private static final String SECURITY_TOKEN_ENV_NAME = "G42CLOUD_SDK_SECURITY_TOKEN";
    private static final String IDP_ID_ENV_NAME = "G42CLOUD_SDK_IDP_ID";
    private static final String ID_TOKEN_FILE_ENV_NAME = "G42CLOUD_SDK_ID_TOKEN_FILE";
    private final String credentialType;

    public EnvCredentialProvider(String credentialType) {
        this.credentialType = credentialType.toLowerCase(Locale.ROOT);
    }

    public static EnvCredentialProvider getBasicCredentialEnvProvider() {
        return new EnvCredentialProvider("basic");
    }

    public static EnvCredentialProvider getGlobalCredentialEnvProvider() {
        return new EnvCredentialProvider("global");
    }

    @Override
    public ICredential getCredentials() {
        if (StringUtils.isEmpty(this.credentialType)) {
            throw new SdkException("credential type is empty");
        }
        AbstractCredentials credentials = null;
        if (this.credentialType.startsWith("basic")) {
            credentials = new BasicCredentials().withProjectId(System.getenv(PROJECT_ID_ENV_NAME));
        } else if (this.credentialType.startsWith("global")) {
            credentials = new GlobalCredentials().withDomainId(System.getenv(DOMAIN_ID_ENV_NAME));
        }
        if (Objects.isNull(credentials)) {
            throw new SdkException("unsupported credential type: " + this.credentialType);
        }
        String ak = System.getenv(AK_ENV_NAME);
        String sk = System.getenv(SK_ENV_NAME);
        String securityToken = System.getenv(SECURITY_TOKEN_ENV_NAME);
        String idpId = System.getenv(IDP_ID_ENV_NAME);
        String idTokenFile = System.getenv(ID_TOKEN_FILE_ENV_NAME);
        if (!StringUtils.isEmpty(idpId) && !StringUtils.isEmpty(idTokenFile)) {
            ((AbstractCredentials)credentials.withIdpId(idpId)).withIdTokenFile(idTokenFile);
        } else if (!StringUtils.isEmpty(ak) && !StringUtils.isEmpty(sk)) {
            ((AbstractCredentials)((AbstractCredentials)credentials.withAk(ak)).withSk(sk)).withSecurityToken(securityToken);
        } else {
            throw new SdkException("ak&sk or idpId&idTokenFile does not exist in environmental variables");
        }
        return credentials;
    }
}

