/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.auth;

import com.g42cloud.sdk.core.auth.EnvCredentialProvider;
import com.g42cloud.sdk.core.auth.ICredential;
import com.g42cloud.sdk.core.auth.ICredentialProvider;
import com.g42cloud.sdk.core.auth.MetadataCredentialProvider;
import com.g42cloud.sdk.core.auth.ProfileCredentialProvider;
import com.g42cloud.sdk.core.exception.SdkException;
import java.util.ArrayList;
import java.util.Objects;

public class CredentialProviderChain
implements ICredentialProvider {
    private final ICredentialProvider[] providers;

    public CredentialProviderChain(ICredentialProvider[] providers) {
        this.providers = providers;
    }

    public static CredentialProviderChain getDefaultCredentialProviderChain(String credentialType) {
        ICredentialProvider[] credentialProviders = new ICredentialProvider[]{new EnvCredentialProvider(credentialType), new ProfileCredentialProvider(credentialType), new MetadataCredentialProvider(credentialType)};
        return new CredentialProviderChain(credentialProviders);
    }

    public static CredentialProviderChain getBasicCredentialProviderChain() {
        return CredentialProviderChain.getDefaultCredentialProviderChain("basic");
    }

    public static CredentialProviderChain getGlobalCredentialProviderChain() {
        return CredentialProviderChain.getDefaultCredentialProviderChain("global");
    }

    @Override
    public ICredential getCredentials() {
        ArrayList<String> exceptions = new ArrayList<String>();
        for (ICredentialProvider provider : this.providers) {
            try {
                ICredential credentials = provider.getCredentials();
                if (!Objects.nonNull(credentials)) continue;
                return credentials;
            }
            catch (SdkException e) {
                exceptions.add(e.getMessage());
            }
        }
        throw new SdkException("failed to get credentials in providers\n" + String.join((CharSequence)"\n", exceptions));
    }
}

