/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.auth;

import com.g42cloud.sdk.core.HcClient;
import com.g42cloud.sdk.core.auth.AKSKSignerFactory;
import com.g42cloud.sdk.core.auth.AbstractCredentials;
import com.g42cloud.sdk.core.auth.AuthCache;
import com.g42cloud.sdk.core.auth.DerivedAKSKSigner;
import com.g42cloud.sdk.core.auth.GlobalCredentials;
import com.g42cloud.sdk.core.auth.IAKSKSigner;
import com.g42cloud.sdk.core.auth.ICredential;
import com.g42cloud.sdk.core.exception.SdkException;
import com.g42cloud.sdk.core.http.HttpClient;
import com.g42cloud.sdk.core.http.HttpRequest;
import com.g42cloud.sdk.core.internal.Iam;
import com.g42cloud.sdk.core.internal.InnerIamMeta;
import com.g42cloud.sdk.core.internal.model.CreateTokenWithIdTokenResponse;
import com.g42cloud.sdk.core.internal.model.KeystoneCreateProjectRequest;
import com.g42cloud.sdk.core.internal.model.KeystoneCreateProjectResponse;
import com.g42cloud.sdk.core.internal.model.KeystoneListAuthDomainsRequest;
import com.g42cloud.sdk.core.internal.model.KeystoneListAuthDomainsResponse;
import com.g42cloud.sdk.core.internal.model.KeystoneListProjectsRequest;
import com.g42cloud.sdk.core.internal.model.KeystoneListProjectsResponse;
import com.g42cloud.sdk.core.internal.model.KeystoneListRegionsRequest;
import com.g42cloud.sdk.core.internal.model.KeystoneListRegionsResponse;
import com.g42cloud.sdk.core.internal.model.Project;
import com.g42cloud.sdk.core.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCredentials
extends AbstractCredentials<BasicCredentials> {
    private String projectId;

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public BasicCredentials withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    Map<String, Object> getPathParams() {
        LinkedHashMap<String, Object> pathParam = new LinkedHashMap<String, Object>();
        if (Objects.nonNull(this.projectId)) {
            pathParam.put("project_id", this.projectId);
        }
        return pathParam;
    }

    @Override
    public CompletableFuture<ICredential> processAuthParams(HcClient hcClient, String regionId) {
        return CompletableFuture.supplyAsync(() -> {
            if (!StringUtils.isEmpty(this.getIdpId()) || !StringUtils.isEmpty(this.getIdTokenFile())) {
                if (StringUtils.isEmpty(this.getIdpId())) {
                    throw new SdkException("idpId is required when using idpId&idTokenFile");
                }
                if (StringUtils.isEmpty(this.getIdTokenFile())) {
                    throw new SdkException("idTokenFile is required when using idpId&idTokenFile");
                }
                if (StringUtils.isEmpty(this.projectId)) {
                    throw new SdkException("projectId is required when using idpId&idTokenFile");
                }
            }
            if (!StringUtils.isEmpty(this.projectId)) {
                return this;
            }
            String akWithName = this.getAk() + regionId;
            if (Objects.nonNull(AuthCache.getAuth(akWithName)) && !StringUtils.isEmpty(AuthCache.getAuth(akWithName))) {
                this.projectId = AuthCache.getAuth(akWithName);
                return this;
            }
            String iamEndpoint = this.getUsedIamEndpoint();
            HcClient inner = hcClient.overrideEndpoints(Collections.singletonList(iamEndpoint));
            Function<HttpRequest, Boolean> derivedPredicate = this.getDerivedPredicate();
            this.setDerivedPredicate(null);
            Logger logger = LoggerFactory.getLogger(hcClient.getClass());
            logger.info("project id of region '{}' not found in BasicCredentials, trying to obtain project id from IAM service: {}", (Object)regionId, (Object)iamEndpoint);
            KeystoneListProjectsRequest request = new KeystoneListProjectsRequest().withName(regionId);
            KeystoneListProjectsResponse response = inner.syncInvokeHttp(request, InnerIamMeta.KEYSTONE_LIST_PROJECTS);
            if (Objects.isNull(response)) {
                throw new SdkException("no project id found, please select one of the following solutions:\n  1. Manually specify projectId when initializing the credentials, BasicCredentials cred = new BasicCredentials().withAk(ak).withSk(sk).withProjectId(projectId)\n  2. Use the domain account to grant IAM read permission to the current account\n  3. Replace the ak/sk of the IAM account with the ak/sk of the domain account");
            }
            List<Project> projects = response.getProjects();
            if (projects.size() == 1) {
                this.projectId = projects.get(0).getId();
            } else if (projects.size() < 1) {
                this.projectId = this.keystoneCreateProject(inner, regionId);
            } else {
                String projectIds = projects.stream().map(Project::getId).collect(Collectors.joining(","));
                throw new SdkException(String.format(Locale.ROOT, "multiple project ids found: [%s], please specify one when initializing the credentials, BasicCredentials cred = new BasicCredentials().withAk(ak).withSk(sk).withProjectId(projectId)", projectIds));
            }
            logger.info("success to obtain project id of region '{}': {}", (Object)regionId, (Object)this.projectId);
            AuthCache.putAuth(akWithName, this.projectId);
            this.setDerivedPredicate(derivedPredicate);
            return this;
        }, hcClient.getHttpConfig().getExecutorService());
    }

    private String keystoneCreateProject(HcClient client, String regionId) {
        List<String> supportedRegions = this.getSupportedRegions(client);
        if (Objects.isNull(supportedRegions) || supportedRegions.size() == 0) {
            throw new SdkException("failed to list regions");
        }
        if (!supportedRegions.contains(regionId)) {
            throw new SdkException("the region input is not supported to create project automatically");
        }
        String domainId = this.getDomainId(client);
        if (StringUtils.isEmpty(domainId)) {
            throw new SdkException("no domain id found, please select one of the following solutions:\n  1. Manually specify domainId when initializing the credentials, GlobalCredentials cred = new GlobalCredentials().withAk(ak).withSk(sk).withDomainId(domainId)\n  2. Use the domain account to grant IAM read permission to the current account\n  3. Replace the ak/sk of the IAM account with the ak/sk of the domain account");
        }
        return this.getCreateProjectId(client, regionId, domainId);
    }

    private List<String> getSupportedRegions(HcClient hcClient) {
        String publicRegionType = "public";
        KeystoneListRegionsRequest request = new KeystoneListRegionsRequest();
        KeystoneListRegionsResponse response = hcClient.syncInvokeHttp(request, InnerIamMeta.KEYSTONE_LIST_REGIONS);
        if (Objects.isNull(response)) {
            throw new SdkException("failed to list all regions");
        }
        return response.getRegions().stream().map(region -> {
            if ("public".equals(region.getType())) {
                return region.getId();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getDomainId(HcClient hcClient) {
        KeystoneListAuthDomainsRequest request = new KeystoneListAuthDomainsRequest();
        KeystoneListAuthDomainsResponse response = hcClient.syncInvokeHttp(request, InnerIamMeta.KEYSTONE_LIST_AUTH_DOMAINS);
        if (Objects.isNull(response)) {
            throw new SdkException("no domain id found, please select one of the following solutions:\n  1. Manually specify domainId when initializing the credentials, GlobalCredentials cred = new GlobalCredentials().withAk(ak).withSk(sk).withDomainId(domainId)\n  2. Use the domain account to grant IAM read permission to the current account\n  3. Replace the ak/sk of the IAM account with the ak/sk of the domain account");
        }
        return response.getDomains().get(0).getId();
    }

    private String getCreateProjectId(HcClient hcClient, String regionId, String domainId) {
        KeystoneCreateProjectRequest request;
        GlobalCredentials globalCredentials = ((GlobalCredentials)((GlobalCredentials)new GlobalCredentials().withAk(this.getAk())).withSk(this.getSk())).withDomainId(domainId);
        HcClient innerGlobal = hcClient.overrideCredential(globalCredentials);
        KeystoneCreateProjectResponse response = innerGlobal.syncInvokeHttp(request = new KeystoneCreateProjectRequest().withBody(body -> body.withProject(project -> {
            project.withName(regionId);
            project.withDomainId(domainId);
        })), InnerIamMeta.KEYSTONE_CREATE_PROJECT);
        if (Objects.isNull(response.getProject())) {
            throw new SdkException("failed to create project");
        }
        return response.getProject().getId();
    }

    @Override
    public CompletableFuture<HttpRequest> processAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        return CompletableFuture.completedFuture(this.syncProcessAuthRequest(httpRequest, httpClient));
    }

    @Override
    public HttpRequest syncProcessAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        Map<String, String> headers;
        HttpRequest.HttpRequestBuilder builder = httpRequest.builder().addAutoFilledPathParam(this.getPathParams());
        if (this.needUpdateAuthToken()) {
            this.updateAuthTokenByIdToken(httpClient);
        } else if (this.needUpdateSecurityToken()) {
            this.updateSecurityTokenFromMetadata();
        }
        if (Objects.nonNull(this.getProjectId())) {
            builder.addHeader("X-Project-Id", this.projectId);
        }
        if (Objects.nonNull(this.authToken)) {
            builder.addHeader("X-Auth-Token", this.authToken);
            return builder.build();
        }
        if (Objects.nonNull(this.getSecurityToken())) {
            builder.addHeader("X-Security-Token", this.getSecurityToken());
        }
        if (Objects.nonNull(httpRequest.getContentType()) && !httpRequest.getContentType().startsWith("application/json") && !httpRequest.getContentType().startsWith("application/bson")) {
            builder.addHeader("X-Sdk-Content-Sha256", "UNSIGNED-PAYLOAD");
        }
        if (this.isDerivedAuth(httpRequest)) {
            headers = DerivedAKSKSigner.getInstance().sign(builder.build(), this);
        } else {
            IAKSKSigner signer = AKSKSignerFactory.getSigner(httpRequest.getSigningAlgorithm());
            headers = signer.sign(builder.build(), this);
        }
        builder.addHeaders(headers);
        return builder.build();
    }

    @Override
    public void processDerivedAuthParams(String derivedAuthServiceName, String regionId) {
        if (this.derivedAuthServiceName == null) {
            this.derivedAuthServiceName = derivedAuthServiceName;
        }
        if (this.regionId == null) {
            this.regionId = regionId;
        }
    }

    @Override
    protected void updateAuthTokenByIdToken(HttpClient httpClient) {
        HttpRequest httpRequest = Iam.getProjectTokenWithIdTokenRequest(this.getUsedIamEndpoint(), this.getIdpId(), this.getIdToken(), this.projectId);
        CreateTokenWithIdTokenResponse response = Iam.createTokenWithIdToken(httpClient, httpRequest);
        this.authToken = response.getSubjectToken();
        try {
            String expiredTime = response.getToken().getExpiresAt().replace("000Z", "Z");
            this.expiredAt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(expiredTime).getTime();
        }
        catch (ParseException e) {
            throw new SdkException(e);
        }
    }

    @Override
    public BasicCredentials deepClone() {
        BasicCredentials credentials = (BasicCredentials)((BasicCredentials)((BasicCredentials)((BasicCredentials)((BasicCredentials)((BasicCredentials)((BasicCredentials)new BasicCredentials().withProjectId(this.projectId).withAk(this.getAk())).withSk(this.getSk())).withIdpId(this.getIdpId())).withIdTokenFile(this.getIdTokenFile())).withDerivedPredicate(this.getDerivedPredicate())).withIamEndpoint(this.getIamEndpoint())).withSecurityToken(this.getSecurityToken());
        credentials.processDerivedAuthParams(this.derivedAuthServiceName, this.regionId);
        return credentials;
    }
}

