/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.utils;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.util.StringBuilderWriter;

public class VelocityUtils {
    private static File assetsDir = new File("assets");
    private static VelocityEngine velocityEngine = null;

    private static VelocityEngine getVelocityEngine() {
        if (velocityEngine == null) {
            velocityEngine = new VelocityEngine();
            velocityEngine.setProperty("resource.loader", (Object)"file,class");
            velocityEngine.setProperty("file.resource.loader.class", (Object)FileResourceLoader.class.getName());
            velocityEngine.setProperty("file.resource.loader.path", (Object)assetsDir.getAbsolutePath());
            velocityEngine.setProperty("class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            velocityEngine.init();
        }
        return velocityEngine;
    }

    private static String render(String templatePath, Object info) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("features", new ArrayList());
        context.put("GUID", UUID.class);
        context.put("StringUtils", StringUtils.class);
        context.put("info", info);
        Template template = VelocityUtils.getVelocityEngine().getTemplate(templatePath, "UTF-8");
        StringBuilderWriter writer = new StringBuilderWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    public static void setAssetsDir(File assetsDir) {
        VelocityUtils.assetsDir = assetsDir;
    }

    public static void render(String templatePath, File output, Object info) throws Exception {
        try {
            String data = VelocityUtils.render(templatePath, info);
            data = data.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n");
            FileUtils.writeStringToFile((File)output, (String)data, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new Exception(e.getMessage(), e);
        }
    }
}

