/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.model.Registry;
import io.github.fvarrui.javapackager.packagers.WindowsArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class GenerateSetup
extends WindowsArtifactGenerator {
    public GenerateSetup() {
        super("Setup installer");
    }

    @Override
    public boolean skip(WindowsPackager packager) {
        if (!packager.getWinConfig().isGenerateSetup()) {
            return true;
        }
        if (!packager.getPlatform().isCurrentPlatform() && !packager.isForceInstaller()) {
            Logger.warn(this.getArtifactName() + " cannot be generated due to the target platform (" + (Object)((Object)packager.getPlatform()) + ") is different from the execution platform (" + (Object)((Object)Platform.getCurrentPlatform()) + ")!");
            return true;
        }
        return false;
    }

    @Override
    protected File doApply(WindowsPackager packager) throws Exception {
        File iconFile = packager.getIconFile();
        File assetsFolder = packager.getAssetsFolder();
        String name = packager.getName();
        File outputDirectory = packager.getOutputDirectory();
        String version = packager.getVersion();
        Registry registry = packager.getWinConfig().getRegistry();
        if (registry.getEntries().stream().anyMatch(e -> StringUtils.isBlank((CharSequence)e.getKey()) || StringUtils.isBlank((CharSequence)e.getValueName()))) {
            throw new Exception("One or more registry entries have no key and/or value name");
        }
        FileUtils.copyFileToFolder(iconFile, assetsFolder);
        File issFile = new File(assetsFolder, name + ".iss");
        VelocityUtils.render("windows/iss.vtl", issFile, packager);
        CommandUtils.execute("iscc", "/O" + outputDirectory.getAbsolutePath(), "/F" + name + "_" + version, issFile);
        File setupFile = new File(outputDirectory, name + "_" + version + ".exe");
        if (!setupFile.exists()) {
            throw new Exception("Windows setup file generation failed!");
        }
        this.sign(setupFile, packager);
        return setupFile;
    }
}

