/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.gradle.GradleContext;
import io.github.fvarrui.javapackager.maven.MavenContext;
import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.GenerateAppImage;
import io.github.fvarrui.javapackager.packagers.GenerateDeb;
import io.github.fvarrui.javapackager.packagers.GenerateDmg;
import io.github.fvarrui.javapackager.packagers.GenerateMsi;
import io.github.fvarrui.javapackager.packagers.GenerateMsm;
import io.github.fvarrui.javapackager.packagers.GeneratePkg;
import io.github.fvarrui.javapackager.packagers.GenerateRpm;
import io.github.fvarrui.javapackager.packagers.GenerateSetup;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;

public abstract class Context<T> {
    private Map<Platform, List<ArtifactGenerator<? extends Packager>>> installerGeneratorsMap = new HashedMap();
    private static Context<?> context;

    public Context() {
        this.getInstallerGenerators(Platform.linux).add(new GenerateDeb());
        this.getInstallerGenerators(Platform.linux).add(new GenerateRpm());
        this.getInstallerGenerators(Platform.linux).add(new GenerateAppImage());
        this.getInstallerGenerators(Platform.mac).add(new GenerateDmg());
        this.getInstallerGenerators(Platform.mac).add(new GeneratePkg());
        this.getInstallerGenerators(Platform.windows).add(new GenerateSetup());
        this.getInstallerGenerators(Platform.windows).add(new GenerateMsm());
        this.getInstallerGenerators(Platform.windows).add(new GenerateMsi());
    }

    public abstract File getRootDir();

    public abstract File getBuildDir();

    public abstract T getLogger();

    public abstract File createRunnableJar(Packager var1) throws Exception;

    public abstract File copyDependencies(Packager var1) throws Exception;

    public abstract File createTarball(Packager var1) throws Exception;

    public abstract File createZipball(Packager var1) throws Exception;

    public abstract File resolveLicense(Packager var1) throws Exception;

    public abstract File createWindowsExe(WindowsPackager var1) throws Exception;

    public List<ArtifactGenerator<? extends Packager>> getInstallerGenerators(Platform platform) {
        List<ArtifactGenerator<? extends Packager>> platformInstallers = this.installerGeneratorsMap.get((Object)platform);
        if (platformInstallers == null) {
            platformInstallers = new ArrayList<ArtifactGenerator<? extends Packager>>();
            this.installerGeneratorsMap.put(platform, platformInstallers);
        }
        return platformInstallers;
    }

    public static Context<?> getContext() {
        return context;
    }

    public static void setContext(Context<?> context) {
        Context.context = context;
    }

    public static boolean isMaven() {
        return context instanceof MavenContext;
    }

    public static boolean isGradle() {
        return context instanceof GradleContext;
    }

    public static MavenContext getMavenContext() {
        return (MavenContext)context;
    }

    public static GradleContext getGradleContext() {
        return (GradleContext)context;
    }

    public File getDefaultToolchain() {
        return new File(System.getProperty("java.home"));
    }
}

