/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.gradle;

import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.Packager;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.tasks.Copy;

public class CopyDependencies
extends ArtifactGenerator<Packager> {
    public Copy copyLibsTask;

    public CopyDependencies() {
        super("Libs folder");
    }

    @Override
    public boolean skip(Packager packager) {
        return packager.getCopyDependencies() == false;
    }

    @Override
    protected File doApply(Packager packager) {
        File libsFolder = new File(packager.getJarFileDestinationFolder(), "libs");
        Project project = Context.getGradleContext().getProject();
        this.copyLibsTask = (Copy)project.getTasks().findByName("copyLibs");
        if (this.copyLibsTask == null) {
            this.copyLibsTask = (Copy)project.getTasks().create("copyLibs", Copy.class);
        }
        this.copyLibsTask.from(new Object[]{project.getConfigurations().getByName("default")});
        this.copyLibsTask.into((Object)project.file((Object)libsFolder));
        this.copyLibsTask.getActions().forEach(action -> action.execute((Object)this.copyLibsTask));
        return libsFolder;
    }
}

