/*
 * Decompiled with CFR 0.152.
 */
package com.funkatronics.buffer;

import com.funkatronics.buffer.ByteOrder;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u000e\n\u0002\u0010\u0004\n\u0002\b\u0004\b`\u0018\u0000 *2\u00020\u0001:\u0001*J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH&J\u0010\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\rH&J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0015\u0010$\u001a\u00020\u0016*\u00020\u00162\u0006\u0010%\u001a\u00020\u0003H\u0082\u0004J\u0014\u0010&\u001a\u00020\u000b*\u00020'2\u0006\u0010(\u001a\u00020\u0003H\u0002J\u0014\u0010)\u001a\u00020\u0016*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006+"}, d2={"Lcom/funkatronics/buffer/ByteBuffer;", "", "capacity", "", "getCapacity", "()I", "order", "Lcom/funkatronics/buffer/ByteOrder;", "getOrder", "()Lcom/funkatronics/buffer/ByteOrder;", "array", "", "get", "", "", "dst", "getDouble", "", "getFloat", "", "getInt", "getLong", "", "getShort", "", "put", "byte", "bytes", "putDouble", "value", "putFloat", "putInt", "putLong", "putShort", "readIntoLong", "count", "sho", "bits", "toByteArray", "", "sizeBytes", "toLong", "Companion", "kborsh"})
public interface ByteBuffer {
    @NotNull
    public static final Companion Companion = com.funkatronics.buffer.ByteBuffer$Companion.$$INSTANCE;

    public int getCapacity();

    @NotNull
    public ByteOrder getOrder();

    @NotNull
    public ByteBuffer order(@NotNull ByteOrder var1);

    @NotNull
    public ByteBuffer put(byte var1);

    public byte get();

    @NotNull
    public ByteBuffer put(@NotNull byte[] var1);

    public void get(@NotNull byte[] var1);

    public short getShort();

    public int getInt();

    public long getLong();

    public float getFloat();

    public double getDouble();

    @NotNull
    public ByteBuffer putShort(short var1);

    @NotNull
    public ByteBuffer putInt(int var1);

    @NotNull
    public ByteBuffer putLong(long var1);

    @NotNull
    public ByteBuffer putFloat(float var1);

    @NotNull
    public ByteBuffer putDouble(double var1);

    @NotNull
    public byte[] array();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/funkatronics/buffer/ByteBuffer$Companion;", "", "()V", "kborsh"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nByteBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBuffer.kt\ncom/funkatronics/buffer/ByteBuffer$DefaultImpls\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n13316#2,2:67\n1855#3,2:69\n1855#3,2:72\n1855#3,2:74\n1#4:71\n*S KotlinDebug\n*F\n+ 1 ByteBuffer.kt\ncom/funkatronics/buffer/ByteBuffer$DefaultImpls\n*L\n19#1:67,2\n23#1:69,2\n51#1:72,2\n57#1:74,2\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static ByteBuffer put(@NotNull ByteBuffer $this, @NotNull byte[] bytes) {
            ByteBuffer byteBuffer;
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            ByteBuffer it = byteBuffer = $this;
            boolean bl = false;
            byte[] $this$forEach$iv = bytes;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                byte element$iv;
                byte by = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                $this.put(by);
            }
            return byteBuffer;
        }

        public static void get(@NotNull ByteBuffer $this, @NotNull byte[] dst) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((byte[])dst);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                dst[it] = $this.get();
            }
        }

        public static short getShort(@NotNull ByteBuffer $this) {
            return (short)DefaultImpls.readIntoLong($this, 2, $this.getOrder());
        }

        public static int getInt(@NotNull ByteBuffer $this) {
            return (int)DefaultImpls.readIntoLong($this, 4, $this.getOrder());
        }

        public static long getLong(@NotNull ByteBuffer $this) {
            return DefaultImpls.readIntoLong($this, 8, $this.getOrder());
        }

        public static float getFloat(@NotNull ByteBuffer $this) {
            return Float.intBitsToFloat((int)DefaultImpls.readIntoLong($this, 4, $this.getOrder()));
        }

        public static double getDouble(@NotNull ByteBuffer $this) {
            return Double.longBitsToDouble(DefaultImpls.readIntoLong($this, 8, $this.getOrder()));
        }

        @NotNull
        public static ByteBuffer putShort(@NotNull ByteBuffer $this, short value) {
            return $this.put(DefaultImpls.toByteArray($this, value, 2));
        }

        @NotNull
        public static ByteBuffer putInt(@NotNull ByteBuffer $this, int value) {
            return $this.put(DefaultImpls.toByteArray($this, value, 4));
        }

        @NotNull
        public static ByteBuffer putLong(@NotNull ByteBuffer $this, long value) {
            return $this.put(DefaultImpls.toByteArray($this, value, 8));
        }

        @NotNull
        public static ByteBuffer putFloat(@NotNull ByteBuffer $this, float value) {
            return $this.put(DefaultImpls.toByteArray($this, Float.valueOf(value), 4));
        }

        @NotNull
        public static ByteBuffer putDouble(@NotNull ByteBuffer $this, double value) {
            return $this.put(DefaultImpls.toByteArray($this, value, 8));
        }

        private static long readIntoLong(ByteBuffer $this, int count, ByteOrder order) {
            byte[] $this$readIntoLong_u24lambda_u243 = new byte[count];
            boolean bl = false;
            $this.get($this$readIntoLong_u24lambda_u243);
            return DefaultImpls.toLong($this, $this$readIntoLong_u24lambda_u243, order);
        }

        private static long sho(ByteBuffer $this, long $receiver, int bits) {
            return $this.getOrder() == ByteOrder.LITTLE_ENDIAN ? $receiver << bits : $receiver >> bits;
        }

        private static long toLong(ByteBuffer $this, byte[] $receiver, ByteOrder order) {
            if (order == ByteOrder.BIG_ENDIAN) {
                ArraysKt.reverse((byte[])$receiver);
            }
            long result = 0L;
            Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((byte[])$receiver);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int b = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                result |= (long)$receiver[b] << 8 * b;
            }
            return result;
        }

        private static byte[] toByteArray(ByteBuffer $this, Number $receiver, int sizeBytes) {
            byte[] byArray;
            byte[] $this$toByteArray_u24lambda_u246 = byArray = new byte[sizeBytes];
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((byte[])$this$toByteArray_u24lambda_u246);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int b = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl2 = false;
                $this$toByteArray_u24lambda_u246[b] = (byte)(DefaultImpls.sho($this, $receiver.longValue(), 8 * b) & 0xFFL);
            }
            return byArray;
        }
    }
}

