/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourlastor.construo.foojay;

import com.squareup.moshi.Moshi;
import io.github.fourlastor.construo.Target;
import io.github.fourlastor.construo.ToolchainOptions;
import io.github.fourlastor.construo.foojay.DistributionInfo;
import io.github.fourlastor.construo.foojay.DistributionResults;
import io.github.fourlastor.construo.foojay.Package;
import io.github.fourlastor.construo.foojay.PackageInfo;
import io.github.fourlastor.construo.foojay.PackageInfoResults;
import io.github.fourlastor.construo.foojay.PackagesResults;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0015H\u0002J\f\u0010\u0019\u001a\u00020\u0018*\u00020\rH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/github/fourlastor/construo/foojay/FooJayClient;", "", "()V", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "okHttpClient", "Lokhttp3/OkHttpClient;", "fetchJvmPackage", "Lio/github/fourlastor/construo/foojay/Package;", "toolchainOptions", "Lio/github/fourlastor/construo/ToolchainOptions;", "target", "Lio/github/fourlastor/construo/Target;", "distribution", "Lio/github/fourlastor/construo/foojay/DistributionInfo;", "fetchPackageDownloadInfo", "Lio/github/fourlastor/construo/foojay/PackageInfo;", "jvmPackage", "getDistribution", "vendor", "Lorg/gradle/jvm/toolchain/JvmVendorSpec;", "getPackageInfo", "fooJayAlias", "", "osName", "construo"})
@SourceDebugExtension(value={"SMAP\nFooJayClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FooJayClient.kt\nio/github/fourlastor/construo/foojay/FooJayClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1#2:139\n223#3,2:140\n*S KotlinDebug\n*F\n+ 1 FooJayClient.kt\nio/github/fourlastor/construo/foojay/FooJayClient\n*L\n96#1:140,2\n*E\n"})
public final class FooJayClient {
    @NotNull
    private final OkHttpClient okHttpClient = new OkHttpClient();
    private final Moshi moshi = new Moshi.Builder().build();

    @NotNull
    public final PackageInfo getPackageInfo(@NotNull ToolchainOptions toolchainOptions, @NotNull Target target) {
        Intrinsics.checkNotNullParameter((Object)toolchainOptions, (String)"toolchainOptions");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        DistributionInfo distribution = this.getDistribution(toolchainOptions.getVendor());
        Package jvmPackage = this.fetchJvmPackage(toolchainOptions, target, distribution);
        return this.fetchPackageDownloadInfo(jvmPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DistributionInfo getDistribution(JvmVendorSpec vendor) {
        Closeable closeable = (Closeable)this.okHttpClient.newCall(new Request.Builder().header("Accept", "application/json").url(new HttpUrl.Builder().scheme("https").host("api.foojay.io").encodedPath("/disco/v3.0/distributions").addQueryParameter("include_versions", "false").build()).build()).execute();
        Throwable throwable = null;
        try {
            Object response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Failed to get distributions");
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                boolean $i$a$-requireNotNull-FooJayClient$getDistribution$1$body$22 = false;
                String $i$a$-requireNotNull-FooJayClient$getDistribution$1$body$22 = "FooJay distributions response was null";
                throw new IllegalArgumentException($i$a$-requireNotNull-FooJayClient$getDistribution$1$body$22.toString());
            }
            ResponseBody body = responseBody;
            Object object = this.moshi.adapter(DistributionResults.class).fromJson(body.source());
            if (object == null) {
                boolean bl2 = false;
                String string = "Distribution deserialization returned null";
                throw new IllegalArgumentException(string.toString());
            }
            response = (DistributionResults)object;
        }
        catch (Throwable response) {
            throwable = response;
            throw response;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        DistributionInfo it = (DistributionInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((DistributionResults)response).getResult()), (Function1)((Function1)new Function1<DistributionInfo, Boolean>(this, vendor){
            final /* synthetic */ FooJayClient this$0;
            final /* synthetic */ JvmVendorSpec $vendor;
            {
                this.this$0 = $receiver;
                this.$vendor = $vendor;
                super(1);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull DistributionInfo it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!it.getBuildOfOpenjdk()) {
                    return false;
                }
                String alias = FooJayClient.access$fooJayAlias(this.this$0, this.$vendor);
                if (alias != null) {
                    return Intrinsics.areEqual((Object)it.getName(), (Object)alias);
                }
                if (!this.$vendor.matches(it.getName())) {
                    boolean bl2;
                    block7: {
                        void $this$any$iv;
                        Iterable iterable = it.getSynonyms();
                        JvmVendorSpec jvmVendorSpec = this.$vendor;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                String it2 = (String)element$iv;
                                boolean bl3 = false;
                                if (!jvmVendorSpec.matches(it2)) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        })));
        boolean bl = false;
        DistributionInfo distributionInfo = it;
        if (distributionInfo == null) {
            boolean bl3 = false;
            String string = "Cannot find distribution for " + vendor;
            throw new IllegalArgumentException(string.toString());
        }
        return distributionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Package fetchJvmPackage(ToolchainOptions toolchainOptions, Target target, DistributionInfo distribution) {
        Package package_;
        Closeable closeable = (Closeable)this.okHttpClient.newCall(new Request.Builder().header("Accept", "application/json").url(new HttpUrl.Builder().scheme("https").host("api.foojay.io").encodedPath("/disco/v3.0/packages").addQueryParameter(toolchainOptions.getVersion().getVersionParam(), toolchainOptions.getVersion().getVersionString()).addQueryParameter("architecture", ((Target.Architecture)((Object)target.getArchitecture().get())).getArch()).addQueryParameter("archive_type", "zip").addQueryParameter("archive_type", "tar.gz").addQueryParameter("archive_type", "tgz").addQueryParameter("distribution", distribution.getApiParameter()).addQueryParameter("operating_system", this.osName(target)).addQueryParameter("directly_downloadable", "true").build()).build()).execute();
        Throwable throwable = null;
        try {
            Object element$iv2;
            block9: {
                Response response = (Response)closeable;
                boolean bl = false;
                if (!response.isSuccessful()) {
                    throw new IOException("Failed to get packages");
                }
                ResponseBody responseBody = response.body();
                if (responseBody == null) {
                    boolean $i$a$-requireNotNull-FooJayClient$fetchJvmPackage$1$body$22 = false;
                    String $i$a$-requireNotNull-FooJayClient$fetchJvmPackage$1$body$22 = "FooJay packages response was null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-FooJayClient$fetchJvmPackage$1$body$22.toString());
                }
                ResponseBody body = responseBody;
                Object object = this.moshi.adapter(PackagesResults.class).fromJson(body.source());
                if (object == null) {
                    boolean $i$a$-requireNotNull-FooJayClient$fetchJvmPackage$1$22 = false;
                    String $i$a$-requireNotNull-FooJayClient$fetchJvmPackage$1$22 = "Packages deserialization returned null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-FooJayClient$fetchJvmPackage$1$22.toString());
                }
                List<Package> packages = ((PackagesResults)object).getResult();
                boolean bl2 = false;
                Iterable $this$first$iv = packages;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Package it = (Package)element$iv2;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getPackageType(), (Object)"jdk")) continue;
                    break block9;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            package_ = (Package)element$iv2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return package_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PackageInfo fetchPackageDownloadInfo(Package jvmPackage) {
        PackageInfo packageInfo;
        Closeable closeable = (Closeable)this.okHttpClient.newCall(new Request.Builder().url(jvmPackage.getLinks().getPackageInfoUri()).build()).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Failed to get package download");
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                boolean $i$a$-requireNotNull-FooJayClient$fetchPackageDownloadInfo$1$body$22 = false;
                String $i$a$-requireNotNull-FooJayClient$fetchPackageDownloadInfo$1$body$22 = "FooJay package download response was null";
                throw new IllegalArgumentException($i$a$-requireNotNull-FooJayClient$fetchPackageDownloadInfo$1$body$22.toString());
            }
            ResponseBody body = responseBody;
            Object object = this.moshi.adapter(PackageInfoResults.class).fromJson(body.source());
            if (object == null) {
                boolean bl2 = false;
                String string = "Package download deserialization returned null";
                throw new IllegalArgumentException(string.toString());
            }
            packageInfo = (PackageInfo)CollectionsKt.first(((PackageInfoResults)object).getResult());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return packageInfo;
    }

    private final String fooJayAlias(JvmVendorSpec $this$fooJayAlias) {
        JvmVendorSpec jvmVendorSpec = $this$fooJayAlias;
        return Intrinsics.areEqual((Object)jvmVendorSpec, (Object)JvmVendorSpec.ADOPTIUM) ? "Temurin" : (Intrinsics.areEqual((Object)jvmVendorSpec, (Object)JvmVendorSpec.ADOPTOPENJDK) ? "AOJ" : (Intrinsics.areEqual((Object)jvmVendorSpec, (Object)JvmVendorSpec.AMAZON) ? "Corretto" : (Intrinsics.areEqual((Object)jvmVendorSpec, (Object)JvmVendorSpec.AZUL) ? "Zulu" : (Intrinsics.areEqual((Object)jvmVendorSpec, (Object)JvmVendorSpec.BELLSOFT) ? "Liberica" : (Intrinsics.areEqual((Object)jvmVendorSpec, (Object)JvmVendorSpec.IBM) ? "Semeru" : (Intrinsics.areEqual((Object)jvmVendorSpec, (Object)JvmVendorSpec.IBM_SEMERU) ? "Semeru" : (Intrinsics.areEqual((Object)jvmVendorSpec, (Object)JvmVendorSpec.ORACLE) ? "Oracle OpenJDK" : (Intrinsics.areEqual((Object)jvmVendorSpec, (Object)JvmVendorSpec.SAP) ? "SAP Machine" : null))))))));
    }

    private final String osName(Target $this$osName) {
        String string;
        Target target = $this$osName;
        if (target instanceof Target.Linux) {
            string = "linux";
        } else if (target instanceof Target.Windows) {
            string = "windows";
        } else if (target instanceof Target.MacOs) {
            string = "macos";
        } else {
            throw new IllegalStateException("Invalid target".toString());
        }
        return string;
    }

    public static final /* synthetic */ String access$fooJayAlias(FooJayClient $this, JvmVendorSpec $receiver) {
        return $this.fooJayAlias($receiver);
    }
}

