/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import madkit.kernel.Madkit;

public class KernelAddress
implements Serializable {
    private static final long serialVersionUID = 3191926058535092533L;
    private static final transient long LOCAL_MAC;
    private final long networkID = LOCAL_MAC;
    private transient String name;
    private final short localID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KernelAddress() {
        short tmp = 0;
        String string = Madkit.VERSION;
        synchronized (string) {
            try (FileChannel channel = new RandomAccessFile(new File(System.getProperty("java.io.tmpdir"), "KA_MDK"), "rw").getChannel();
                 FileLock lock = channel.lock();){
                ByteBuffer b = ByteBuffer.allocate(2);
                channel.read(b, 0L);
                tmp = (short)(b.getShort(0) + 1);
                b.putShort(0, tmp).rewind();
                channel.write(b, 0L);
            }
            catch (IOException e) {
                e.printStackTrace();
                tmp = (short)System.nanoTime();
            }
        }
        this.localID = tmp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        KernelAddress other = (KernelAddress)obj;
        return other.localID == this.localID && this.networkID == other.networkID;
    }

    public int hashCode() {
        return this.localID;
    }

    public String getNetworkID() {
        return this.localID + "-" + this.networkID;
    }

    public String toString() {
        if (this.name == null) {
            this.name = "@MK-" + (this.localID < 0 ? this.localID + 65536 : this.localID);
        }
        return this.name;
    }

    static {
        long result;
        block5: {
            result = 0L;
            try {
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                if (e == null) break block5;
                while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    if (ni.isLoopback()) continue;
                    byte[] hardwareAddress = ni.getHardwareAddress();
                    if (hardwareAddress != null) {
                        for (byte value : hardwareAddress) {
                            result <<= 8;
                            result |= (long)(value & 0xFF);
                        }
                    }
                    break;
                }
            }
            catch (SocketException e1) {
                e1.printStackTrace();
            }
        }
        LOCAL_MAC = result;
    }
}

