/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.FlowLayout;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.action.KernelAction;
import madkit.kernel.AbstractAgent;

public class AgentStatusPanel
extends JPanel {
    private static final long serialVersionUID = -5745998699827681837L;
    private static final Map<AbstractAgent, AgentStatusPanel> agentsToPanels = new ConcurrentHashMap<AbstractAgent, AgentStatusPanel>();
    private static final ImageIcon image = new ImageIcon(KernelAction.LAUNCH_NETWORK.getActionInfo().getBigIcon().getImage().getScaledInstance(10, 10, 4));
    private final transient AbstractAgent myAgent;
    private final JLabel network;

    public AgentStatusPanel(AbstractAgent a) {
        super(new FlowLayout(2));
        this.myAgent = a;
        this.network = new JLabel();
        this.add(this.network);
        this.update();
        agentsToPanels.put(this.myAgent, this);
    }

    public static void updateAll() {
        for (AgentStatusPanel panel : agentsToPanels.values()) {
            panel.update();
        }
    }

    private void update() {
        if (this.myAgent.isAlive() && this.myAgent.isKernelOnline()) {
            this.network.setIcon(image);
            this.network.setText(this.myAgent.getKernelAddress().toString());
            this.network.setToolTipText(this.network.getText() + " online @ " + this.myAgent.getServerInfo());
        } else {
            this.network.setIcon(null);
            this.network.setText(null);
        }
    }

    public static void remove(AbstractAgent abstractAgent) {
        agentsToPanels.remove(abstractAgent);
    }
}

