/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import madkit.action.KernelAction;
import madkit.gui.AgentStatusPanel;
import madkit.gui.PrintableFrame;
import madkit.gui.SwingUtil;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.gui.menu.AgentMenu;
import madkit.gui.menu.DisplayMenu;
import madkit.gui.menu.HelpMenu;
import madkit.gui.menu.MadkitMenu;
import madkit.kernel.AbstractAgent;
import madkit.message.KernelMessage;

public class AgentFrame
extends JFrame
implements PrintableFrame {
    private static final long serialVersionUID = 8787803902533059051L;
    private static final Preferences AGENTS_UI_PREFERENCES = Preferences.userRoot().node(AgentFrame.class.getName());
    private final transient AbstractAgent agent;
    private final String agentUIPreferenceCodeBase;
    private JInternalFrame internalFrame;

    protected AgentFrame(final AbstractAgent agent) {
        super(agent.getName());
        this.agent = agent;
        this.agentUIPreferenceCodeBase = agent.getName();
        this.setIconImage(SwingUtil.MADKIT_LOGO.getImage());
        this.setJMenuBar(this.createMenuBar());
        JToolBar tb = this.createJToolBar();
        if (tb != null) {
            this.add((Component)tb, "First");
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                this.closeProcess();
            }

            private void closeProcess() {
                if (agent.isAlive()) {
                    AgentFrame.this.setTitle("Closing " + agent.getName());
                    AgentFrame.killAgent(agent, 4);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.closeProcess();
            }
        });
        this.setSize(400, 300);
        this.getContentPane().setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        this.setLocationRelativeTo(null);
        this.restoreUIPreferences();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Component component = e.getComponent();
                AGENTS_UI_PREFERENCES.putInt(AgentFrame.this.agentUIPreferenceCodeBase + "_X", component.getX());
                AGENTS_UI_PREFERENCES.putInt(AgentFrame.this.agentUIPreferenceCodeBase + "_Y", component.getY());
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Component component = e.getComponent();
                AGENTS_UI_PREFERENCES.putInt(AgentFrame.this.agentUIPreferenceCodeBase + "_W", component.getWidth());
                AGENTS_UI_PREFERENCES.putInt(AgentFrame.this.agentUIPreferenceCodeBase + "_H", component.getHeight());
            }
        });
        this.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("background")) {
                AGENTS_UI_PREFERENCES.putInt(this.agentUIPreferenceCodeBase + "_BGC", this.getBackground().getRGB());
            }
        });
    }

    @Override
    public void dispose() {
        if (this.internalFrame != null) {
            this.internalFrame.dispose();
        }
        super.dispose();
    }

    public Dimension getLastSavedDimensionPreference() {
        return new Dimension(AGENTS_UI_PREFERENCES.getInt(this.agentUIPreferenceCodeBase + "_W", 400), AGENTS_UI_PREFERENCES.getInt(this.agentUIPreferenceCodeBase + "_H", 300));
    }

    public Point getLastSavedLocationPreference() {
        return new Point(AGENTS_UI_PREFERENCES.getInt(this.agentUIPreferenceCodeBase + "_X", -1), AGENTS_UI_PREFERENCES.getInt(this.agentUIPreferenceCodeBase + "_Y", -1));
    }

    public Color getLastSavedBackgroundPreference() {
        return new Color(AGENTS_UI_PREFERENCES.getInt(this.agentUIPreferenceCodeBase + "_BGC", Color.WHITE.getRGB()));
    }

    public void restoreUIPreferences() {
        Color lastSavedBackgroundPreference = this.getLastSavedBackgroundPreference();
        this.setBackground(lastSavedBackgroundPreference);
        this.setSize(this.getLastSavedDimensionPreference());
        this.setLocation(this.getLastSavedLocationPreference());
        if (this.getLocation().equals(new Point(-1, -1))) {
            this.setLocationRelativeTo(null);
        }
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new MadkitMenu(this.agent));
        menuBar.add(new AgentMenu(this.agent));
        menuBar.add(new AgentLogLevelMenu(this.agent));
        menuBar.add(new DisplayMenu(this));
        menuBar.add(new HelpMenu());
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(new AgentStatusPanel(this.agent));
        return menuBar;
    }

    public JToolBar createJToolBar() {
        return null;
    }

    void setInternalFrame(JInternalFrame internalFrame) {
        this.internalFrame = internalFrame;
        for (ComponentListener l : this.getComponentListeners()) {
            this.internalFrame.addComponentListener(l);
        }
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        if (this.internalFrame != null) {
            this.internalFrame.setLocation(x, y);
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.internalFrame != null) {
            this.internalFrame.setSize(width, height);
        }
    }

    @Override
    public void pack() {
        super.pack();
        if (this.internalFrame != null) {
            this.internalFrame.pack();
        }
    }

    static void killAgent(AbstractAgent agent, int timeOutSeconds) {
        if (agent.isAlive()) {
            agent.sendMessage("local", "system", "manager", new KernelMessage(KernelAction.KILL_AGENT, agent, timeOutSeconds));
        }
    }

    public AbstractAgent getAgent() {
        return this.agent;
    }

    public static AgentFrame createAgentFrame(AbstractAgent agent) {
        return new AgentFrame(agent);
    }

    @Override
    public String toString() {
        return "AFrame for " + this.agent + " " + super.toString();
    }

    @Override
    public Container getPrintableContainer() {
        if (this.internalFrame != null) {
            return this.internalFrame.getDesktopPane().getTopLevelAncestor();
        }
        return this;
    }

    @Override
    public void setBackground(Color bgColor) {
        super.setBackground(bgColor);
        this.getContentPane().setBackground(bgColor);
    }
}

