/*
 * Decompiled with CFR 0.152.
 */
package com.flynnbuc.httpserverwrapper.main;

import com.flynnbuc.httpserverwrapper.interfaces.ContextManager;
import com.flynnbuc.httpserverwrapper.interfaces.NotificationListener;
import com.flynnbuc.httpserverwrapper.model.Context;
import com.flynnbuc.httpserverwrapper.model.NetworkRequest;
import com.flynnbuc.httpserverwrapper.model.Notification;
import com.flynnbuc.httpserverwrapper.services.ServerService;
import com.sun.net.httpserver.HttpExchange;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public abstract class ServerController<T>
implements PropertyChangeListener {
    public static String PROPERTY_CHANGE_STR = "Handler Added";
    protected final Map<Long, NetworkRequest<T>> requestQueue = new ConcurrentHashMap<Long, NetworkRequest<T>>();
    protected ServerService serverService;
    private RequestNumberGenerator requestNumberGenerator = new RequestNumberGenerator();
    private final List<NotificationListener> notificationListenerList;
    private final ContextManager manager;

    public <T> ServerController(ContextManager manager) {
        this.serverService = new ServerService();
        this.manager = manager;
        this.notificationListenerList = new ArrayList<NotificationListener>();
        this.notificationListenerList.add(manager);
    }

    public void addNotificationListener(NotificationListener notificationListener) {
        this.notificationListenerList.add(notificationListener);
    }

    public synchronized boolean startServerService(int portNum, Function<Boolean, Void> callback) {
        boolean created = this.serverService.startServer(portNum);
        callback.apply(created);
        this.manager.requestData();
        return created;
    }

    public synchronized void stopServerService(Function<Boolean, Void> callback) {
        this.serverService.exit();
        this.serverService = null;
        callback.apply(false);
    }

    public abstract void createContexts(Context ... var1);

    public void removeContext(String path) {
        this.serverService.removeContext(path);
    }

    protected abstract void respondToRequest(T var1, HttpExchange var2, int var3);

    public abstract void handleRequestResponse(long var1, T var3, int var4);

    protected void fireNotification(Notification notification, T data, long id) {
        for (NotificationListener notificationListener : this.notificationListenerList) {
            notificationListener.notificationReceived(notification, data, id);
        }
    }

    protected long generateRequestNum() {
        return this.requestNumberGenerator.incrementAndGet();
    }

    private static class RequestNumberGenerator {
        private long requestNum;

        private RequestNumberGenerator() {
        }

        public synchronized long incrementAndGet() {
            if (this.requestNum >= Long.MAX_VALUE) {
                this.requestNum = Long.MIN_VALUE;
            }
            return ++this.requestNum;
        }
    }
}

