/*
 * Decompiled with CFR 0.152.
 */
package io.github.flashvayne.chatgpt.service.impl;

import io.github.flashvayne.chatgpt.dto.ChatRequest;
import io.github.flashvayne.chatgpt.dto.ChatResponse;
import io.github.flashvayne.chatgpt.dto.chat.MultiChatMessage;
import io.github.flashvayne.chatgpt.dto.chat.MultiChatRequest;
import io.github.flashvayne.chatgpt.dto.chat.MultiChatResponse;
import io.github.flashvayne.chatgpt.dto.image.ImageFormat;
import io.github.flashvayne.chatgpt.dto.image.ImageRequest;
import io.github.flashvayne.chatgpt.dto.image.ImageResponse;
import io.github.flashvayne.chatgpt.dto.image.ImageSize;
import io.github.flashvayne.chatgpt.exception.ChatgptException;
import io.github.flashvayne.chatgpt.property.ChatgptProperties;
import io.github.flashvayne.chatgpt.service.ChatgptService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DefaultChatgptService
implements ChatgptService {
    private static final Logger log = LoggerFactory.getLogger(DefaultChatgptService.class);
    protected final ChatgptProperties chatgptProperties;
    private final String AUTHORIZATION;
    private final RestTemplate restTemplate = new RestTemplate();

    public DefaultChatgptService(ChatgptProperties chatgptProperties) {
        this.chatgptProperties = chatgptProperties;
        this.AUTHORIZATION = "Bearer " + chatgptProperties.getApiKey();
    }

    @Override
    public String sendMessage(String message) {
        ChatRequest chatRequest = new ChatRequest(this.chatgptProperties.getModel(), message, this.chatgptProperties.getMaxTokens(), this.chatgptProperties.getTemperature(), this.chatgptProperties.getTopP());
        ChatResponse chatResponse = this.getResponse(this.buildHttpEntity(chatRequest), ChatResponse.class, this.chatgptProperties.getUrl());
        try {
            return chatResponse.getChoices().get(0).getText();
        }
        catch (Exception e) {
            log.error("parse chatgpt message error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public ChatResponse sendChatRequest(ChatRequest chatRequest) {
        return this.getResponse(this.buildHttpEntity(chatRequest), ChatResponse.class, this.chatgptProperties.getUrl());
    }

    @Override
    public String multiChat(List<MultiChatMessage> messages) {
        MultiChatRequest multiChatRequest = new MultiChatRequest(this.chatgptProperties.getMulti().getModel(), messages, this.chatgptProperties.getMulti().getMaxTokens(), this.chatgptProperties.getMulti().getTemperature(), this.chatgptProperties.getMulti().getTopP());
        MultiChatResponse multiChatResponse = this.getResponse(this.buildHttpEntity(multiChatRequest), MultiChatResponse.class, this.chatgptProperties.getMulti().getUrl());
        try {
            return multiChatResponse.getChoices().get(0).getMessage().getContent();
        }
        catch (Exception e) {
            log.error("parse chatgpt message error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public MultiChatResponse multiChatRequest(MultiChatRequest multiChatRequest) {
        return this.getResponse(this.buildHttpEntity(multiChatRequest), MultiChatResponse.class, this.chatgptProperties.getMulti().getUrl());
    }

    @Override
    public String imageGenerate(String prompt) {
        ImageRequest imageRequest = new ImageRequest(prompt, null, null, null, null);
        ImageResponse imageResponse = this.getResponse(this.buildHttpEntity(imageRequest), ImageResponse.class, this.chatgptProperties.getImage().getUrl());
        try {
            return imageResponse.getData().get(0).getUrl();
        }
        catch (Exception e) {
            log.error("parse image url error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> imageGenerate(String prompt, Integer n, ImageSize size, ImageFormat format) {
        ImageRequest imageRequest = new ImageRequest(prompt, n, size.getSize(), format.getFormat(), null);
        ImageResponse imageResponse = this.getResponse(this.buildHttpEntity(imageRequest), ImageResponse.class, this.chatgptProperties.getImage().getUrl());
        try {
            ArrayList<String> list = new ArrayList<String>();
            imageResponse.getData().forEach(imageData -> {
                if (format.equals((Object)ImageFormat.URL)) {
                    list.add(imageData.getUrl());
                } else {
                    list.add(imageData.getB64Json());
                }
            });
            return list;
        }
        catch (Exception e) {
            log.error("parse image url error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public ImageResponse imageGenerateRequest(ImageRequest imageRequest) {
        return this.getResponse(this.buildHttpEntity(imageRequest), ImageResponse.class, this.chatgptProperties.getImage().getUrl());
    }

    protected <T> HttpEntity<?> buildHttpEntity(T request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/json; charset=UTF-8"));
        headers.add("Authorization", this.AUTHORIZATION);
        return new HttpEntity(request, (MultiValueMap)headers);
    }

    protected <T> T getResponse(HttpEntity<?> httpEntity, Class<T> responseType, String url) {
        log.info("request url: {}, httpEntity: {}", (Object)url, httpEntity);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, httpEntity, responseType, new Object[0]);
        if (responseEntity.getStatusCodeValue() != HttpStatus.OK.value()) {
            log.error("error response status: {}", (Object)responseEntity);
            throw new ChatgptException("error response status :" + responseEntity.getStatusCodeValue());
        }
        log.info("response: {}", (Object)responseEntity);
        return (T)responseEntity.getBody();
    }
}

