/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.entities.TargetInfo;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.transport.Callback;
import com.ruiyun.jvppeteer.transport.CallbackRegistry;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends EventEmitter<CDPSession.CDPSessionEvent>
implements Consumer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final String url;
    private final ConnectionTransport transport;
    private final int delay;
    private final int timeout;
    private final Map<String, CDPSession> sessions = new ConcurrentHashMap<String, CDPSession>();
    protected volatile boolean closed;
    final Set<String> manuallyAttached = new HashSet<String>();
    private final CallbackRegistry callbacks = new CallbackRegistry();
    private volatile boolean handleMessageThreadFinish = false;
    private final ConcurrentLinkedQueue<Runnable> eventQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<JsonNode> messagesQueue = new ConcurrentLinkedQueue();
    private List<String> events = null;
    final AtomicLong id = new AtomicLong(1L);
    private Thread handleMessageThread;
    private static final AtomicLong messageThreadId = new AtomicLong(1L);
    private static final AtomicLong eventThreadId = new AtomicLong(1L);

    public ConcurrentLinkedQueue<Runnable> getEventQueue() {
        return this.eventQueue;
    }

    public Connection(String url, ConnectionTransport transport, int delay, int timeout) {
        this.url = url;
        this.transport = transport;
        this.delay = delay;
        this.timeout = timeout;
        this.transport.setConnection(this);
        this.startThread();
    }

    public void startHandleMessageThread() {
        this.handleMessageThread = new Thread(() -> {
            do {
                Connection connection = this;
                synchronized (connection) {
                    try {
                        CDPSession cdpSession;
                        JsonNode paramsNode;
                        JsonNode response;
                        if (!this.eventQueue.isEmpty()) {
                            this.wait();
                        }
                        if ((response = this.messagesQueue.poll()) == null) {
                            continue;
                        }
                        String method = response.hasNonNull("method") ? response.get("method").asText() : null;
                        String sessionId = null;
                        if (response.hasNonNull("params")) {
                            paramsNode = response.get("params");
                            if (paramsNode.hasNonNull("sessionId")) {
                                sessionId = paramsNode.get("sessionId").asText();
                            }
                        } else {
                            paramsNode = null;
                        }
                        String parentSessionId = "";
                        if (response.hasNonNull("sessionId")) {
                            parentSessionId = response.get("sessionId").asText();
                        }
                        if ("Target.attachedToTarget".equals(method)) {
                            JsonNode typeNode = paramsNode.get("targetInfo").get("type");
                            CDPSession cdpSession2 = new CDPSession(this, typeNode.asText(), sessionId, parentSessionId);
                            this.sessions.put(sessionId, cdpSession2);
                            this.eventQueue.offer(() -> this.emit(CDPSession.CDPSessionEvent.sessionAttached, cdpSession2));
                            this.wait();
                            CDPSession parentSession = this.sessions.get(parentSessionId);
                            if (parentSession != null) {
                                this.eventQueue.offer(() -> parentSession.emit(CDPSession.CDPSessionEvent.sessionAttached, cdpSession2));
                                this.wait();
                            }
                        } else if ("Target.detachedFromTarget".equals(method) && (cdpSession = this.sessions.get(sessionId)) != null) {
                            cdpSession.onClosed();
                            this.sessions.remove(sessionId);
                            this.eventQueue.offer(() -> this.emit(CDPSession.CDPSessionEvent.sessionDetached, cdpSession));
                            this.wait();
                            CDPSession parentSession = this.sessions.get(parentSessionId);
                            if (parentSession != null) {
                                this.eventQueue.offer(() -> parentSession.emit(CDPSession.CDPSessionEvent.sessionDetached, cdpSession));
                                this.wait();
                            }
                        }
                        if (StringUtil.isNotEmpty(parentSessionId)) {
                            CDPSession parentSession = this.sessions.get(parentSessionId);
                            if (parentSession != null && parentSession.onMessage(response, this.callbacks)) {
                                this.wait();
                            }
                        } else if (response.hasNonNull("id")) {
                            long id = response.get("id").asLong();
                            Connection.resolveCallback(this.callbacks, response, id, false);
                        } else {
                            boolean match;
                            if (this.events == null) {
                                this.events = Arrays.stream(CDPSession.CDPSessionEvent.values()).map(CDPSession.CDPSessionEvent::getEventName).collect(Collectors.toList());
                            }
                            if (!(match = this.events.contains(method))) {
                                return;
                            }
                            this.eventQueue.offer(() -> {
                                try {
                                    this.emit(CDPSession.CDPSessionEvent.valueOf(method.replace(".", "_")), Constant.LISTENNER_CLASSES.get(method) == null ? Boolean.valueOf(true) : Constant.OBJECTMAPPER.treeToValue((TreeNode)paramsNode, Constant.LISTENNER_CLASSES.get(method)));
                                }
                                catch (JsonProcessingException e) {
                                    LOGGER.error("onMessage error:", (Throwable)e);
                                }
                            });
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Handle message error: ", (Throwable)e);
                    }
                }
            } while (!this.messagesQueue.isEmpty() || !this.closed);
            this.handleMessageThreadFinish = true;
        });
        this.handleMessageThread.setName("JvHandleMessageThread-" + eventThreadId.getAndIncrement());
        this.handleMessageThread.start();
    }

    protected static void resolveCallback(CallbackRegistry callbacks, JsonNode response, long id, boolean handleListenerThread) {
        if (response.hasNonNull("error")) {
            callbacks.reject(id, Helper.createProtocolErrorMessage(response), response.get("error").hasNonNull("code") ? response.get("error").get("code").asInt() : 0, handleListenerThread);
        } else {
            callbacks.resolve(id, response.get("result"), handleListenerThread);
        }
    }

    public void startEmitEventThread() {
        Thread emitEventThread = new Thread(() -> {
            do {
                Connection connection = this;
                synchronized (connection) {
                    try {
                        Runnable runnable = this.eventQueue.poll();
                        if (runnable == null) {
                            this.notifyAll();
                        } else {
                            runnable.run();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Emit event error: ", (Throwable)e);
                    }
                }
            } while (!this.handleMessageThreadFinish || !this.eventQueue.isEmpty() || !this.closed);
        });
        emitEventThread.setName("JvEmitEventThread-" + messageThreadId.getAndIncrement());
        emitEventThread.start();
    }

    public boolean isAutoAttached(String targetId) {
        return !this.manuallyAttached.remove(targetId);
    }

    public JsonNode send(String method) {
        return this.rawSend(method, null, null, this.timeout, true);
    }

    public JsonNode send(String method, Map<String, Object> params) {
        return this.rawSend(method, params, null, this.timeout, true);
    }

    public JsonNode send(String method, Map<String, Object> params, Integer timeout, boolean isBlocking) {
        return this.rawSend(method, params, null, timeout, isBlocking);
    }

    public JsonNode rawSend(String method, Map<String, Object> params, String sessionId, Integer timeout, boolean isBlocking) {
        ValidateUtil.assertArg(!this.closed, "Protocol error: Connection closed.");
        if (timeout == null) {
            timeout = this.timeout;
        }
        Callback callback = new Callback(this.id.incrementAndGet(), method, timeout);
        return this.callbacks.create(callback, id -> {
            ObjectNode objectNode = Constant.OBJECTMAPPER.createObjectNode();
            objectNode.put("method", method);
            if (params != null) {
                objectNode.set("params", Constant.OBJECTMAPPER.valueToTree((Object)params));
            }
            objectNode.put("id", id);
            if (StringUtil.isNotEmpty(sessionId)) {
                objectNode.put("sessionId", sessionId);
            }
            String stringifiedMessage = objectNode.toString();
            LOGGER.trace("jvppeteer:protocol:SEND \u25ba {}", (Object)stringifiedMessage);
            this.transport.send(stringifiedMessage);
        }, isBlocking);
    }

    public void onMessage(String message) {
        try {
            if (StringUtil.isEmpty(message)) {
                return;
            }
            if (this.delay > 0) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.error("slowMo browser Fail:", (Throwable)e);
                }
            }
            LOGGER.trace("jvppeteer:protocol:RECV \u25c0 {}", (Object)message);
            JsonNode readTree = Constant.OBJECTMAPPER.readTree(message);
            if (readTree.hasNonNull("id")) {
                long id = readTree.get("id").asLong();
                Connection.resolveCallback(this.callbacks, readTree, id, true);
            }
            this.messagesQueue.offer(readTree);
        }
        catch (Exception e) {
            LOGGER.error("onMessage error:", (Throwable)e);
        }
    }

    public static Connection fromSession(CDPSession client) {
        return client.getConnection();
    }

    public CDPSession createSession(TargetInfo targetInfo) {
        return this._createSession(targetInfo, false);
    }

    public CDPSession _createSession(TargetInfo targetInfo, boolean isAutoAttachEmulated) {
        if (!isAutoAttachEmulated) {
            this.manuallyAttached.add(targetInfo.getTargetId());
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("targetId", targetInfo.getTargetId());
        params.put("flatten", true);
        JsonNode response = this.send("Target.attachToTarget", params, null, true);
        if (response.hasNonNull("sessionId")) {
            String sessionId = response.get("sessionId").asText();
            CDPSession cdpSession = this.sessions.get(sessionId);
            if (cdpSession == null) {
                throw new JvppeteerException("CDPSession creation failed.");
            }
            return cdpSession;
        }
        throw new JvppeteerException("CDPSession creation failed.");
    }

    public String url() {
        return this.url;
    }

    public CDPSession session(String sessionId) {
        return this.sessions.get(sessionId);
    }

    @Override
    public void accept(String t) {
        this.onMessage(t);
    }

    @Override
    public void dispose() {
        this.onClose();
        this.transport.close();
    }

    private void onClose() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.transport.setConnection(null);
        this.waitForHandleMessageThreadFinish();
        this.callbacks.clear();
        for (CDPSession session : this.sessions.values()) {
            session.onClosed();
        }
        this.sessions.clear();
        this.emit(CDPSession.CDPSessionEvent.CDPSession_Disconnected, true);
    }

    private void waitForHandleMessageThreadFinish() {
        while (!this.handleMessageThreadFinish) {
        }
    }

    public List<ProtocolException> getPendingProtocolErrors() {
        return new ArrayList<ProtocolException>(this.callbacks.getPendingProtocolErrors());
    }

    private void startThread() {
        this.startEmitEventThread();
        this.startHandleMessageThread();
    }

    public boolean closed() {
        return this.closed;
    }
}

