/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.launch;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.Product;
import com.ruiyun.jvppeteer.core.Browser;
import com.ruiyun.jvppeteer.core.BrowserFetcher;
import com.ruiyun.jvppeteer.core.BrowserRunner;
import com.ruiyun.jvppeteer.entities.BrowserLaunchArgumentOptions;
import com.ruiyun.jvppeteer.entities.ConnectOptions;
import com.ruiyun.jvppeteer.entities.FetcherOptions;
import com.ruiyun.jvppeteer.entities.LaunchOptions;
import com.ruiyun.jvppeteer.entities.RevisionInfo;
import com.ruiyun.jvppeteer.entities.TargetType;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.LaunchException;
import com.ruiyun.jvppeteer.launch.Launcher;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.transport.WebSocketTransport;
import com.ruiyun.jvppeteer.util.FileUtil;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StreamUtil;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeLauncher
implements Launcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromeLauncher.class);
    private Product product;
    private String cacheDir;
    private String chromeExecutable;

    public ChromeLauncher(String cacheDir, Product product) {
        this.cacheDir = cacheDir;
        this.product = product;
    }

    public ChromeLauncher() {
    }

    @Override
    public Browser launch(LaunchOptions options) throws IOException {
        if (options.getArgs() == null) {
            options.setArgs(new ArrayList<String>());
        }
        this.chromeExecutable = this.lookForExecutablePath(options.getExecutablePath(), options.getPreferredRevision());
        String temporaryUserDataDir = options.getUserDataDir();
        List<String> defaultArgs = this.defaultArgs(options);
        ArrayList<String> chromeArguments = new ArrayList<String>(defaultArgs);
        boolean isCustomUserDir = false;
        boolean isCustomRemoteDebugger = false;
        for (String arg : chromeArguments) {
            if (arg.startsWith("--remote-debugging-")) {
                isCustomRemoteDebugger = true;
                continue;
            }
            if (!arg.startsWith("--user-data-dir")) continue;
            isCustomUserDir = true;
        }
        if (!isCustomUserDir) {
            temporaryUserDataDir = FileUtil.createProfileDir("jvppeteer_dev_chrome_profile-");
            chromeArguments.add("--user-data-dir=" + temporaryUserDataDir);
        }
        if (!isCustomRemoteDebugger) {
            if (options.getPipe()) {
                ValidateUtil.assertArg(options.getDebuggingPort() == 0, "Browser should be launched with either pipe or debugging port - not both.");
                chromeArguments.add("--remote-debugging-pipe");
            } else {
                chromeArguments.add("--remote-debugging-port=" + options.getDebuggingPort());
            }
        }
        boolean usePipe = chromeArguments.contains("--remote-debugging-pipe");
        LOGGER.info("Calling {} {}", (Object)this.chromeExecutable, (Object)String.join((CharSequence)" ", chromeArguments));
        LOGGER.trace("Calling {} {}", (Object)this.chromeExecutable, (Object)String.join((CharSequence)" ", chromeArguments));
        BrowserRunner runner = new BrowserRunner(this.chromeExecutable, chromeArguments, temporaryUserDataDir);
        try {
            runner.start();
            Connection connection = runner.setUpConnection(usePipe, options.getProtocolTimeout(), options.getSlowMo(), options.getDumpio());
            Runnable closeCallback = runner::closeBrowser;
            Browser browser = Browser.create(options.getProduct(), connection, new ArrayList<String>(), options.getAcceptInsecureCerts(), options.getDefaultViewport(), runner.getProcess(), closeCallback, options.getTargetFilter(), null, true);
            browser.setExecutablePath(this.chromeExecutable);
            browser.setDefaultArgs(defaultArgs);
            if (options.getWaitForInitialPage()) {
                browser.waitForTarget(t -> TargetType.PAGE.equals((Object)t.type()), options.getTimeout());
            }
            runner.setPid(this.getBrowserPid(connection, runner.getProcess()));
            return browser;
        }
        catch (IOException | InterruptedException e) {
            runner.closeBrowser();
            LOGGER.error("Failed to launch the browser process:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private String getBrowserPid(Connection connection, Process process) {
        long pid = -1L;
        try {
            JsonNode result = connection.send("SystemInfo.getProcessInfo");
            Iterator processInfos = result.get("processInfo").elements();
            while (processInfos.hasNext()) {
                JsonNode processInfo = (JsonNode)processInfos.next();
                if (!processInfo.get("type").asText().equals("browser")) continue;
                pid = processInfo.get("id").asLong();
                break;
            }
            if (pid == -1L) {
                pid = Helper.getPidForLinuxOrMac(process);
            }
        }
        catch (Exception e) {
            LOGGER.error("get browser pid error: ", (Throwable)e);
        }
        return String.valueOf(pid);
    }

    @Override
    public List<String> defaultArgs(LaunchOptions options) {
        List<String> args;
        ArrayList<String> chromeArguments;
        List<String> userDisabledFeatures = this.getFeatures("--disable-features", options.getArgs());
        if (ValidateUtil.isNotEmpty(options.getArgs()) && !userDisabledFeatures.isEmpty()) {
            this.removeMatchingFlags(options, "--disable-features");
        }
        boolean turnOnExperimentalFeaturesForTesting = "true".equals(env.getEnv("PUPPETEER_TEST_EXPERIMENTAL_CHROME_FEATURES"));
        List<String> disabledFeatures = new ArrayList<String>();
        disabledFeatures.add("Translate");
        disabledFeatures.add("AcceptCHFrame");
        disabledFeatures.add("MediaRouter");
        disabledFeatures.add("OptimizationHints");
        if (!turnOnExperimentalFeaturesForTesting) {
            disabledFeatures.add("ProcessPerSiteUpToMainFrameThreshold");
            disabledFeatures.add("IsolateSandboxedIframes");
        }
        disabledFeatures.addAll(userDisabledFeatures);
        disabledFeatures = disabledFeatures.stream().filter(feature -> !"".equals(feature)).collect(Collectors.toList());
        List<String> userEnabledFeatures = this.getFeatures("--enable-features", options.getArgs());
        if (ValidateUtil.isNotEmpty(options.getArgs()) && !userEnabledFeatures.isEmpty()) {
            this.removeMatchingFlags(options, "--enable-features");
        }
        List<String> enabledFeatures = new ArrayList<String>();
        enabledFeatures.add("PdfOopif");
        enabledFeatures.addAll(userEnabledFeatures);
        enabledFeatures = enabledFeatures.stream().filter(feature -> !"".equals(feature)).collect(Collectors.toList());
        if (!options.getIgnoreAllDefaultArgs()) {
            chromeArguments = new ArrayList<String>(Constant.DEFAULT_ARGS);
            chromeArguments.add("--disable-features=" + String.join((CharSequence)",", disabledFeatures));
            chromeArguments.add("--enable-features=" + String.join((CharSequence)",", enabledFeatures));
        } else {
            List<String> ignoreDefaultArgs = options.getIgnoreDefaultArgs();
            if (ValidateUtil.isNotEmpty(ignoreDefaultArgs)) {
                chromeArguments = new ArrayList<String>(Constant.DEFAULT_ARGS);
                chromeArguments.add("--disable-features=" + String.join((CharSequence)",", disabledFeatures));
                chromeArguments.add("--enable-features=" + String.join((CharSequence)",", enabledFeatures));
                chromeArguments.removeAll(ignoreDefaultArgs);
            } else {
                chromeArguments = new ArrayList();
            }
        }
        if (StringUtil.isNotEmpty(options.getUserDataDir())) {
            chromeArguments.add("--user-data-dir=" + options.getUserDataDir());
        }
        boolean devtools = options.getDevtools();
        boolean headless = options.getHeadless();
        if (devtools) {
            chromeArguments.add("--auto-open-devtools-for-tabs");
            headless = false;
        }
        if (headless) {
            if (Product.CHROMEHEADLESSSHELL.equals((Object)options.getProduct()) || this.chromeExecutable.contains(Product.CHROMEHEADLESSSHELL.getProduct())) {
                chromeArguments.add("--headless");
            } else {
                chromeArguments.add("--headless=new");
                chromeArguments.add("--hide-scrollbars");
                chromeArguments.add("--mute-audio");
            }
        }
        if (ValidateUtil.isNotEmpty(args = options.getArgs())) {
            for (String arg : args) {
                if (!arg.startsWith("--")) continue;
                chromeArguments.add("about:blank");
                break;
            }
            chromeArguments.addAll(args);
        } else {
            chromeArguments.add("about:blank");
        }
        return chromeArguments;
    }

    private void removeMatchingFlags(BrowserLaunchArgumentOptions options, String flag) {
        Pattern regex = Pattern.compile("^" + flag + "=.*");
        options.setArgs(options.getArgs().stream().filter(s -> !regex.matcher((CharSequence)s).find()).collect(Collectors.toList()));
    }

    private List<String> getFeatures(String flag, List<String> options) {
        String prefix = flag.endsWith("=") ? flag : flag + "=";
        return options.stream().filter(s -> s.startsWith(prefix)).map(s -> {
            String[] splitArray = s.split(flag + "\\s*");
            if (splitArray.length > 1) {
                if (StringUtil.isNotEmpty(splitArray[1])) {
                    return splitArray[1].trim();
                }
                return null;
            }
            return null;
        }).filter(Objects::nonNull).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    @Override
    public String lookForExecutablePath(String chromeExecutable, String preferredRevision) throws IOException {
        FetcherOptions fetcherOptions = new FetcherOptions();
        fetcherOptions.setProduct(this.product);
        fetcherOptions.setCacheDir(this.cacheDir);
        BrowserFetcher browserFetcher = new BrowserFetcher(fetcherOptions);
        if (StringUtil.isNotEmpty(chromeExecutable)) {
            boolean assertDir = FileUtil.assertExecutable(Paths.get(chromeExecutable, new String[0]).normalize().toAbsolutePath().toString());
            if (!assertDir) {
                throw new IllegalArgumentException("given chromeExecutable \"" + chromeExecutable + "\" is not executable");
            }
            return chromeExecutable;
        }
        for (int i = 0; i < Constant.EXECUTABLE_ENV.length; ++i) {
            chromeExecutable = env.getEnv(Constant.EXECUTABLE_ENV[i]);
            if (!StringUtil.isNotEmpty(chromeExecutable)) continue;
            boolean assertDir = FileUtil.assertExecutable(chromeExecutable);
            if (!assertDir) {
                throw new IllegalArgumentException("given chromeExecutable is not is not executable");
            }
            return chromeExecutable;
        }
        if (StringUtil.isNotEmpty(preferredRevision)) {
            RevisionInfo revisionInfo = browserFetcher.revisionInfo(preferredRevision);
            if (!revisionInfo.getLocal()) {
                throw new LaunchException(MessageFormat.format("Could not find browser preferredRevision {0}. Please download a browser binary.", preferredRevision));
            }
            return revisionInfo.getExecutablePath();
        }
        String revision = env.getEnv("JVPPETEER_CHROMIUM_REVISION");
        if (StringUtil.isNotEmpty(revision)) {
            RevisionInfo revisionInfo = browserFetcher.revisionInfo(revision);
            if (!revisionInfo.getLocal()) {
                throw new LaunchException("Tried to use PUPPETEER_CHROMIUM_REVISION env variable to launch browser but did not find executable at: " + revisionInfo.getExecutablePath());
            }
            return revisionInfo.getExecutablePath();
        }
        List<String> localRevisions = browserFetcher.localRevisions();
        if (ValidateUtil.isNotEmpty(localRevisions)) {
            localRevisions.sort(Comparator.reverseOrder());
            RevisionInfo revisionInfo = browserFetcher.revisionInfo(localRevisions.get(0));
            if (!revisionInfo.getLocal()) {
                throw new LaunchException("Tried to use PUPPETEER_CHROMIUM_REVISION env variable to launch browser but did not find executable at: " + revisionInfo.getExecutablePath());
            }
            return revisionInfo.getExecutablePath();
        }
        for (int i = 0; i < Constant.PROBABLE_CHROME_EXECUTABLE_PATH.length; ++i) {
            boolean assertDir;
            chromeExecutable = Constant.PROBABLE_CHROME_EXECUTABLE_PATH[i];
            if (!StringUtil.isNotEmpty(chromeExecutable) || !(assertDir = FileUtil.assertExecutable(chromeExecutable))) continue;
            return chromeExecutable;
        }
        throw new LaunchException("Could not find anyone browser executablePath");
    }

    @Override
    public Browser connect(ConnectOptions options) throws IOException, InterruptedException {
        Connection connection;
        if (options.getTransport() != null) {
            connection = new Connection("", options.getTransport(), options.getSlowMo(), options.getProtocolTimeout());
        } else if (StringUtil.isNotEmpty(options.getBrowserWSEndpoint())) {
            WebSocketTransport connectionTransport = WebSocketTransport.create(options.getBrowserWSEndpoint());
            connection = new Connection(options.getBrowserWSEndpoint(), connectionTransport, options.getSlowMo(), options.getTimeout());
        } else if (StringUtil.isNotEmpty(options.getBrowserURL())) {
            String connectionURL = this.getWSEndpoint(options.getBrowserURL());
            WebSocketTransport connectionTransport = WebSocketTransport.create(connectionURL);
            connection = new Connection(connectionURL, connectionTransport, options.getSlowMo(), options.getTimeout());
        } else {
            throw new IllegalArgumentException("Exactly one of browserWSEndpoint, browserURL or transport must be passed to puppeteer.connect");
        }
        JsonNode result = connection.send("Target.getBrowserContexts");
        JavaType javaType = Constant.OBJECTMAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{String.class});
        Runnable closeFunction = () -> connection.send("Browser.close");
        List browserContextIds = (List)Constant.OBJECTMAPPER.readerFor(javaType).readValue(result.get("browserContextIds"));
        return Browser.create(Product.CHROME, connection, browserContextIds, options.getAcceptInsecureCerts(), options.getDefaultViewport(), null, closeFunction, options.getTargetFilter(), options.getIsPageTarget(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWSEndpoint(String browserURL) throws IOException {
        JsonNode jsonNode;
        URI uri = URI.create(browserURL).resolve("/json/version");
        URL url = uri.toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setRequestMethod("GET");
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new JvppeteerException("browserURL: " + browserURL + ",HTTP " + responseCode);
            }
            String result = StreamUtil.toString(conn.getInputStream());
            jsonNode = Constant.OBJECTMAPPER.readTree(result);
        }
        finally {
            conn.disconnect();
        }
        return jsonNode.get("webSocketDebuggerUrl").asText();
    }

    @Override
    public String executablePath() {
        return this.chromeExecutable;
    }
}

