/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.entities;

import com.ruiyun.jvppeteer.common.Environment;
import com.ruiyun.jvppeteer.common.Product;
import com.ruiyun.jvppeteer.core.Target;
import com.ruiyun.jvppeteer.entities.BrowserConnectOptions;
import com.ruiyun.jvppeteer.entities.Viewport;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class LaunchOptions
extends BrowserConnectOptions {
    private String executablePath;
    private boolean ignoreAllDefaultArgs;
    private List<String> ignoreDefaultArgs;
    private boolean dumpio;
    private Environment env;
    private boolean pipe;
    private Product product;
    private boolean waitForInitialPage;
    private String preferredRevision;
    private String cacheDir;

    private LaunchOptions(Builder builder) {
        this.executablePath = builder.executablePath;
        this.ignoreAllDefaultArgs = builder.ignoreAllDefaultArgs;
        this.ignoreDefaultArgs = builder.ignoreDefaultArgs;
        this.dumpio = builder.dumpio;
        this.env = builder.env;
        this.pipe = builder.pipe;
        this.product = builder.product;
        this.waitForInitialPage = builder.waitForInitialPage;
        this.preferredRevision = builder.preferredRevision;
        this.cacheDir = builder.cacheDir;
        this.setAcceptInsecureCerts(builder.acceptInsecureCerts);
        this.setDefaultViewport(builder.defaultViewport);
        this.setSlowMo(builder.slowMo);
        this.setTargetFilter(builder.targetFilter);
        this.setIsPageTarget(builder.isPageTarget);
        this.setProtocolTimeout(builder.protocolTimeout);
        this.setHeadless(builder.headless);
        this.setArgs(builder.args);
        this.setUserDataDir(builder.userDataDir);
        this.setDevtools(builder.devtools);
        this.setDebuggingPort(builder.debuggingPort);
        this.setTimeout(builder.timeout);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getExecutablePath() {
        return this.executablePath;
    }

    public boolean getIgnoreAllDefaultArgs() {
        return this.ignoreAllDefaultArgs;
    }

    public List<String> getIgnoreDefaultArgs() {
        return this.ignoreDefaultArgs;
    }

    public boolean getDumpio() {
        return this.dumpio;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean getPipe() {
        return this.pipe;
    }

    public Product getProduct() {
        return this.product;
    }

    public boolean getWaitForInitialPage() {
        return this.waitForInitialPage;
    }

    public String getPreferredRevision() {
        return this.preferredRevision;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public void setExecutablePath(String executablePath) {
        this.executablePath = executablePath;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public void setPreferredRevision(String preferredRevision) {
        this.preferredRevision = preferredRevision;
    }

    public void setWaitForInitialPage(boolean waitForInitialPage) {
        this.waitForInitialPage = waitForInitialPage;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public void setPipe(boolean pipe) {
        this.pipe = pipe;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public void setDumpio(boolean dumpio) {
        this.dumpio = dumpio;
    }

    public void setIgnoreDefaultArgs(List<String> ignoreDefaultArgs) {
        this.ignoreDefaultArgs = ignoreDefaultArgs;
    }

    public void setIgnoreAllDefaultArgs(boolean ignoreAllDefaultArgs) {
        this.ignoreAllDefaultArgs = ignoreAllDefaultArgs;
    }

    public static class Builder {
        private boolean acceptInsecureCerts;
        private Viewport defaultViewport = new Viewport();
        private int slowMo;
        private Function<Target, Boolean> targetFilter;
        private Function<Target, Boolean> isPageTarget;
        private int protocolTimeout = 180000;
        private boolean headless = true;
        private List<String> args = new ArrayList<String>();
        private String userDataDir;
        private boolean devtools;
        private int debuggingPort;
        private int timeout = 30000;
        private String executablePath;
        private boolean ignoreAllDefaultArgs;
        private List<String> ignoreDefaultArgs;
        private boolean dumpio = false;
        private Environment env;
        private boolean pipe;
        private Product product;
        private boolean waitForInitialPage = true;
        private String preferredRevision;
        private String cacheDir;

        private Builder() {
        }

        public Builder executablePath(String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public Builder ignoreAllDefaultArgs(boolean ignoreAllDefaultArgs) {
            this.ignoreAllDefaultArgs = ignoreAllDefaultArgs;
            return this;
        }

        public Builder ignoreDefaultArgs(List<String> ignoreDefaultArgs) {
            this.ignoreDefaultArgs = ignoreDefaultArgs;
            return this;
        }

        public Builder dumpio(boolean dumpio) {
            this.dumpio = dumpio;
            return this;
        }

        public Builder env(Environment env) {
            this.env = env;
            return this;
        }

        public Builder pipe(boolean pipe) {
            this.pipe = pipe;
            return this;
        }

        public Builder product(Product product) {
            this.product = product;
            return this;
        }

        public Builder waitForInitialPage(boolean waitForInitialPage) {
            this.waitForInitialPage = waitForInitialPage;
            return this;
        }

        public Builder preferredRevision(String preferredRevision) {
            this.preferredRevision = preferredRevision;
            return this;
        }

        public Builder cacheDir(String cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        public Builder acceptInsecureCerts(boolean acceptInsecureCerts) {
            this.acceptInsecureCerts = acceptInsecureCerts;
            return this;
        }

        public Builder args(List<String> args) {
            this.args = args;
            return this;
        }

        public Builder defaultViewport(Viewport defaultViewport) {
            this.defaultViewport = defaultViewport;
            return this;
        }

        public Builder debuggingPort(int debuggingPort) {
            this.debuggingPort = debuggingPort;
            return this;
        }

        public Builder devtools(boolean devtools) {
            this.devtools = devtools;
            return this;
        }

        public Builder headless(boolean headless) {
            this.headless = headless;
            return this;
        }

        public Builder isPageTarget(Function<Target, Boolean> isPageTarget) {
            this.isPageTarget = isPageTarget;
            return this;
        }

        public Builder protocolTimeout(int protocolTimeout) {
            this.protocolTimeout = protocolTimeout;
            return this;
        }

        public Builder slowMo(int slowMo) {
            this.slowMo = slowMo;
            return this;
        }

        public Builder targetFilter(Function<Target, Boolean> targetFilter) {
            this.targetFilter = targetFilter;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder userDataDir(String userDataDir) {
            this.userDataDir = userDataDir;
            return this;
        }

        public LaunchOptions build() {
            return new LaunchOptions(this);
        }
    }
}

