/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.core.Browser;
import com.ruiyun.jvppeteer.core.BrowserContext;
import com.ruiyun.jvppeteer.core.Page;
import com.ruiyun.jvppeteer.core.TargetManager;
import com.ruiyun.jvppeteer.core.WebWorker;
import com.ruiyun.jvppeteer.entities.TargetInfo;
import com.ruiyun.jvppeteer.entities.TargetType;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.transport.SessionFactory;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Target {
    private BrowserContext browserContext;
    private CDPSession session;
    protected TargetInfo targetInfo;
    private TargetManager targetManager;
    protected SessionFactory sessionFactory;
    private final List<Target> childTargets = new ArrayList<Target>();
    public final AwaitableResult<Boolean> isClosedResult = AwaitableResult.create();
    final AwaitableResult<InitializationStatus> initializedResult = AwaitableResult.create();
    private String targetId;
    protected WebWorker webWorker;
    private Runnable onCloseRunner;

    public Target() {
        this.onCloseRunner = () -> {};
    }

    public Target(TargetInfo targetInfo, CDPSession session, BrowserContext browserContext, TargetManager targetManager, SessionFactory sessionFactory) {
        this.onCloseRunner = () -> {};
        this.session = session;
        this.targetManager = targetManager;
        this.targetInfo = targetInfo;
        this.browserContext = browserContext;
        this.targetId = targetInfo.getTargetId();
        this.sessionFactory = sessionFactory;
        if (this.session != null) {
            this.session.setTarget(this);
        }
    }

    public void setInitializedResult(InitializationStatus status) {
        this.initializedResult.onSuccess(status);
    }

    public Page asPage() {
        CDPSession session = this.session();
        if (session == null) {
            session = this.createCDPSession();
            return Page.create(session, this, null);
        }
        return Page.create(session, this, null);
    }

    public String subtype() {
        return this.targetInfo.getSubtype();
    }

    public CDPSession session() {
        return this.session;
    }

    public void addChildTarget(Target target) {
        this.childTargets.add(target);
    }

    public void removeChildTarget(Target target) {
        this.childTargets.remove(target);
    }

    public List<Target> childTargets() {
        return this.childTargets;
    }

    public SessionFactory sessionFactory() {
        if (this.sessionFactory == null) {
            throw new JvppeteerException("sessionFactory is not initialized");
        }
        return this.sessionFactory;
    }

    public CDPSession createCDPSession() {
        if (this.sessionFactory == null) {
            throw new JvppeteerException("sessionFactory is not initialized");
        }
        CDPSession cdpSession = this.sessionFactory.create(false);
        cdpSession.setTarget(this);
        return cdpSession;
    }

    public String url() {
        return this.targetInfo.getUrl();
    }

    public TargetType type() {
        String type;
        switch (type = this.targetInfo.getType()) {
            case "page": {
                return TargetType.PAGE;
            }
            case "background_page": {
                return TargetType.BACKGROUND_PAGE;
            }
            case "service_worker": {
                return TargetType.SERVICE_WORKER;
            }
            case "shared_worker": {
                return TargetType.SHARED_WORKER;
            }
            case "browser": {
                return TargetType.BROWSER;
            }
            case "webview": {
                return TargetType.WEBVIEW;
            }
            case "tab": {
                return TargetType.TAB;
            }
        }
        return TargetType.OTHER;
    }

    public TargetManager targetManager() {
        if (this.targetManager == null) {
            throw new JvppeteerException("targetManager is not initialized");
        }
        return this.targetManager;
    }

    public TargetInfo getTargetInfo() {
        return this.targetInfo;
    }

    public Browser browser() {
        if (this.browserContext == null) {
            throw new JvppeteerException("browserContext is not initialized");
        }
        return this.browserContext.browser();
    }

    public BrowserContext browserContext() {
        if (this.browserContext == null) {
            throw new JvppeteerException("browserContext is not initialized");
        }
        return this.browserContext;
    }

    public Target opener() {
        String openerId = this.targetInfo.getOpenerId();
        if (StringUtil.isEmpty(openerId)) {
            return null;
        }
        for (Target target : this.browser().targets()) {
            if (!target.getTargetId().equals(openerId)) continue;
            return target;
        }
        return null;
    }

    public void targetInfoChanged(TargetInfo targetInfo) {
        this.targetInfo = targetInfo;
        this.checkIfInitialized();
    }

    public void initialize() {
        this.setInitializedResult(InitializationStatus.SUCCESS);
    }

    public boolean isTargetExposed() {
        return this.type() != TargetType.TAB && this.subtype() == null;
    }

    private void checkIfInitialized() {
        if (!this.initializedResult.isDone()) {
            this.setInitializedResult(InitializationStatus.SUCCESS);
        }
    }

    public Page page() {
        return null;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void waitForTargetClose() {
        this.isClosedResult.waiting(30000, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.isClosedResult.onSuccess(true);
        if (this.onCloseRunner != null) {
            this.onCloseRunner.run();
        }
    }

    public void setOnCloseRunner(Runnable onCloseRunner) {
        this.onCloseRunner = onCloseRunner;
    }

    public static enum InitializationStatus {
        SUCCESS("success"),
        ABORTED("aborted");

        private final String status;

        private InitializationStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

