/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.common.BindingFunction;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.DeviceRequestPrompt;
import com.ruiyun.jvppeteer.common.MediaType;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.common.ScreenRecorder;
import com.ruiyun.jvppeteer.common.TimeoutSettings;
import com.ruiyun.jvppeteer.core.Accessibility;
import com.ruiyun.jvppeteer.core.Browser;
import com.ruiyun.jvppeteer.core.BrowserContext;
import com.ruiyun.jvppeteer.core.Coverage;
import com.ruiyun.jvppeteer.core.Dialog;
import com.ruiyun.jvppeteer.core.ElementHandle;
import com.ruiyun.jvppeteer.core.EmulationManager;
import com.ruiyun.jvppeteer.core.FileChooser;
import com.ruiyun.jvppeteer.core.Frame;
import com.ruiyun.jvppeteer.core.FrameManager;
import com.ruiyun.jvppeteer.core.IsolatedWorld;
import com.ruiyun.jvppeteer.core.JSHandle;
import com.ruiyun.jvppeteer.core.Keyboard;
import com.ruiyun.jvppeteer.core.Mouse;
import com.ruiyun.jvppeteer.core.NetworkManager;
import com.ruiyun.jvppeteer.core.Request;
import com.ruiyun.jvppeteer.core.Response;
import com.ruiyun.jvppeteer.core.Target;
import com.ruiyun.jvppeteer.core.TargetManager;
import com.ruiyun.jvppeteer.core.Touchscreen;
import com.ruiyun.jvppeteer.core.Tracing;
import com.ruiyun.jvppeteer.core.WebWorker;
import com.ruiyun.jvppeteer.entities.Binding;
import com.ruiyun.jvppeteer.entities.BindingPayload;
import com.ruiyun.jvppeteer.entities.BoundingBox;
import com.ruiyun.jvppeteer.entities.CallFrame;
import com.ruiyun.jvppeteer.entities.ClickOptions;
import com.ruiyun.jvppeteer.entities.ConsoleMessage;
import com.ruiyun.jvppeteer.entities.ConsoleMessageLocation;
import com.ruiyun.jvppeteer.entities.ConsoleMessageType;
import com.ruiyun.jvppeteer.entities.Cookie;
import com.ruiyun.jvppeteer.entities.CookieParam;
import com.ruiyun.jvppeteer.entities.Credentials;
import com.ruiyun.jvppeteer.entities.DeleteCookiesRequest;
import com.ruiyun.jvppeteer.entities.Device;
import com.ruiyun.jvppeteer.entities.EvaluateType;
import com.ruiyun.jvppeteer.entities.FrameAddScriptTagOptions;
import com.ruiyun.jvppeteer.entities.FrameAddStyleTagOptions;
import com.ruiyun.jvppeteer.entities.GeolocationOptions;
import com.ruiyun.jvppeteer.entities.GetMetricsResponse;
import com.ruiyun.jvppeteer.entities.GetNavigationHistoryResponse;
import com.ruiyun.jvppeteer.entities.GoToOptions;
import com.ruiyun.jvppeteer.entities.IdleOverridesState;
import com.ruiyun.jvppeteer.entities.ImageType;
import com.ruiyun.jvppeteer.entities.LengthUnit;
import com.ruiyun.jvppeteer.entities.MediaFeature;
import com.ruiyun.jvppeteer.entities.Metric;
import com.ruiyun.jvppeteer.entities.Metrics;
import com.ruiyun.jvppeteer.entities.NavigationEntry;
import com.ruiyun.jvppeteer.entities.NetworkConditions;
import com.ruiyun.jvppeteer.entities.NewDocumentScriptEvaluation;
import com.ruiyun.jvppeteer.entities.PDFMargin;
import com.ruiyun.jvppeteer.entities.PDFOptions;
import com.ruiyun.jvppeteer.entities.PageMetrics;
import com.ruiyun.jvppeteer.entities.PaperFormats;
import com.ruiyun.jvppeteer.entities.RemoteObject;
import com.ruiyun.jvppeteer.entities.ScreenRecorderOptions;
import com.ruiyun.jvppeteer.entities.ScreencastOptions;
import com.ruiyun.jvppeteer.entities.ScreenshotClip;
import com.ruiyun.jvppeteer.entities.ScreenshotOptions;
import com.ruiyun.jvppeteer.entities.StackTrace;
import com.ruiyun.jvppeteer.entities.UserAgentMetadata;
import com.ruiyun.jvppeteer.entities.Viewport;
import com.ruiyun.jvppeteer.entities.VisionDeficiency;
import com.ruiyun.jvppeteer.entities.WaitForOptions;
import com.ruiyun.jvppeteer.entities.WaitForSelectorOptions;
import com.ruiyun.jvppeteer.events.BindingCalledEvent;
import com.ruiyun.jvppeteer.events.ConsoleAPICalledEvent;
import com.ruiyun.jvppeteer.events.EntryAddedEvent;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.events.ExceptionThrownEvent;
import com.ruiyun.jvppeteer.events.FileChooserOpenedEvent;
import com.ruiyun.jvppeteer.events.JavascriptDialogOpeningEvent;
import com.ruiyun.jvppeteer.events.MetricsEvent;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.exception.TargetCloseException;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Page
extends EventEmitter<PageEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Page.class);
    private volatile boolean closed = false;
    private final TargetManager targetManager;
    private CDPSession primaryTargetClient;
    private Target primaryTarget;
    private final CDPSession tabTargetClient;
    private final Target tabTarget;
    private final Keyboard keyboard;
    private final Mouse mouse;
    private final Touchscreen touchscreen;
    private FrameManager frameManager;
    private final EmulationManager emulationManager;
    private final Tracing tracing;
    private final Map<String, Binding> bindings = new HashMap<String, Binding>();
    private final Map<String, String> exposedFunctions = new HashMap<String, String>();
    private final Coverage coverage;
    private Viewport viewport;
    private final Map<String, WebWorker> workers = new HashMap<String, WebWorker>();
    private final Set<AwaitableResult<FileChooser>> fileChooserResults = new HashSet<AwaitableResult<FileChooser>>();
    private final AwaitableResult<TargetCloseException> sessionCloseResult = AwaitableResult.create();
    private boolean serviceWorkerBypassed = false;
    private boolean userDragInterceptionEnabled = false;
    protected final TimeoutSettings _timeoutSettings = new TimeoutSettings();
    final Map<Consumer<Request>, Consumer<Request>> requestHandlers = new WeakHashMap<Consumer<Request>, Consumer<Request>>();
    private boolean isDragging;
    private final Consumer<CDPSession> onAttachedToTarget = session -> {
        this.frameManager.onAttachedToTarget(session.getTarget());
        if ("worker".equals(session.getTarget().getTargetInfo().getType())) {
            WebWorker webWorker = new WebWorker((CDPSession)session, session.getTarget().url(), session.getTarget().getTargetId(), session.getTarget().type(), this::addConsoleMessage, this::handleException);
            this.workers.put(session.id(), webWorker);
            this.emit(PageEvent.WorkerCreated, webWorker);
        }
        session.on(CDPSession.CDPSessionEvent.CDPSession_Ready, this.onAttachedToTarget);
    };
    private static final Map<String, Double> unitToPixels = new HashMap<String, Double>(){
        private static final long serialVersionUID = -4861220887908575532L;
        {
            this.put("px", 1.0);
            this.put("in", 96.0);
            this.put("cm", 37.8);
            this.put("mm", 3.78);
        }
    };
    AtomicLong screencastSessionCount = new AtomicLong(0L);
    private volatile boolean startScreencasted = false;

    public Page(CDPSession client, Target target) {
        this.primaryTargetClient = client;
        this.tabTargetClient = client.parentSession();
        Objects.requireNonNull(this.tabTargetClient, "Tab target session is not defined.");
        this.tabTarget = this.tabTargetClient.getTarget();
        Objects.requireNonNull(this.tabTarget, "Tab target is not defined.");
        this.primaryTarget = target;
        this.targetManager = target.targetManager();
        this.keyboard = new Keyboard(client);
        this.mouse = new Mouse(client, this.keyboard);
        this.touchscreen = new Touchscreen(client, this.keyboard);
        this.frameManager = new FrameManager(client, this, this._timeoutSettings);
        this.emulationManager = new EmulationManager(client);
        this.tracing = new Tracing(client);
        this.coverage = new Coverage(client);
        this.viewport = null;
        Map<FrameManager.FrameManagerEvent, Consumer> frameManagerHandlers = Collections.unmodifiableMap(new HashMap<FrameManager.FrameManagerEvent, Consumer<?>>(){
            {
                this.put(FrameManager.FrameManagerEvent.FrameAttached, frame -> Page.this.emit(PageEvent.FrameAttached, frame));
                this.put(FrameManager.FrameManagerEvent.FrameDetached, frame -> Page.this.emit(PageEvent.FrameDetached, frame));
                this.put(FrameManager.FrameManagerEvent.FrameNavigated, frame -> Page.this.emit(PageEvent.FrameNavigated, frame));
                this.put(FrameManager.FrameManagerEvent.ConsoleApiCalled, arg -> Page.this.onConsoleAPI((IsolatedWorld)arg[0], (ConsoleAPICalledEvent)arg[1]));
                this.put(FrameManager.FrameManagerEvent.BindingCalled, arg -> Page.this.onBindingCalled((IsolatedWorld)arg.get(0), (BindingCalledEvent)arg.get(1)));
            }
        });
        frameManagerHandlers.forEach(this.frameManager::on);
        Map<NetworkManager.NetworkManagerEvent, Consumer> networkManagerHandlers = Collections.unmodifiableMap(new HashMap<NetworkManager.NetworkManagerEvent, Consumer<?>>(){
            {
                this.put(NetworkManager.NetworkManagerEvent.Request, request -> Page.this.emit(PageEvent.Request, request));
                this.put(NetworkManager.NetworkManagerEvent.RequestServedFromCache, request -> Page.this.emit(PageEvent.RequestServedFromCache, request));
                this.put(NetworkManager.NetworkManagerEvent.Response, response -> Page.this.emit(PageEvent.Response, response));
                this.put(NetworkManager.NetworkManagerEvent.RequestFailed, request -> Page.this.emit(PageEvent.RequestFailed, request));
                this.put(NetworkManager.NetworkManagerEvent.RequestFinished, request -> Page.this.emit(PageEvent.RequestFinished, request));
            }
        });
        networkManagerHandlers.forEach((key, value) -> this.frameManager.networkManager().on(key, (Consumer<?>)value));
        this.tabTargetClient.on(CDPSession.CDPSessionEvent.CDPSession_Swapped, this::onActivation);
        this.tabTargetClient.on(CDPSession.CDPSessionEvent.CDPSession_Ready, this::onSecondaryTarget);
        Consumer<Target> onDetachedFromTarget = cdpTarget -> {
            if (cdpTarget.session() == null) {
                return;
            }
            String sessionId = cdpTarget.session().id();
            WebWorker webWorker = this.workers.get(sessionId);
            if (webWorker == null) {
                return;
            }
            this.workers.remove(sessionId);
            this.emit(PageEvent.WorkerDestroyed, webWorker);
        };
        this.targetManager.on(TargetManager.TargetManagerEvent.TargetGone, onDetachedFromTarget);
        this.tabTarget.setOnCloseRunner(() -> {
            this.targetManager.off(TargetManager.TargetManagerEvent.TargetGone, onDetachedFromTarget);
            this.emit(PageEvent.Close, true);
            this.closed = true;
        });
        this.setupPrimaryTargetListeners();
        this.attachExistingTargets();
    }

    @Override
    public EventEmitter<PageEvent> on(PageEvent type, Consumer<?> handler) {
        if (type != PageEvent.Request) {
            return super.on(type, handler);
        }
        Consumer<Request> wrapper = this.requestHandlers.get(handler);
        Consumer<?> handlerWrapper = handler;
        if (wrapper == null) {
            wrapper = event -> event.enqueueInterceptAction(() -> handlerWrapper.accept(event));
        }
        this.requestHandlers.put(handlerWrapper, wrapper);
        return super.on(type, wrapper);
    }

    @Override
    public void off(PageEvent type, Consumer<?> handler) {
        if (type == PageEvent.Request) {
            handler = this.requestHandlers.get(handler);
        }
        super.off(type, handler);
    }

    private void attachExistingTargets() {
        List<Target> childTargets = this.targetManager.getChildTargets(this.primaryTarget);
        ArrayList<Target> queue = new ArrayList<Target>(childTargets);
        int idx = 0;
        while (idx < queue.size()) {
            Target next = (Target)queue.get(idx);
            ++idx;
            CDPSession session = next.session();
            if (session != null) {
                this.onAttachedToTarget.accept(session);
            }
            queue.addAll(this.targetManager.getChildTargets(next));
        }
    }

    private void onActivation(CDPSession newSession) {
        this.primaryTargetClient = newSession;
        this.primaryTarget = this.primaryTargetClient.getTarget();
        Objects.requireNonNull(this.primaryTarget, "Missing target on swap");
        this.keyboard.updateClient(newSession);
        this.mouse.updateClient(newSession);
        this.touchscreen.updateClient(newSession);
        this.emulationManager.updateClient(newSession);
        this.tracing.updateClient(newSession);
        this.coverage.updateClient(newSession);
        this.frameManager.swapFrameTree(newSession);
        this.setupPrimaryTargetListeners();
    }

    private void setupPrimaryTargetListeners() {
        Map<CDPSession.CDPSessionEvent, Consumer> sessionHandlers = Collections.unmodifiableMap(new HashMap<CDPSession.CDPSessionEvent, Consumer<?>>(){
            {
                this.put(CDPSession.CDPSessionEvent.CDPSession_Ready, session -> Page.this.onAttachedToTarget.accept((CDPSession)session));
                this.put(CDPSession.CDPSessionEvent.CDPSession_Disconnected, ignore -> Page.this.sessionCloseResult.onSuccess(new TargetCloseException("Target closed")));
                this.put(CDPSession.CDPSessionEvent.Page_domContentEventFired, ignore -> Page.this.emit(PageEvent.Domcontentloaded, true));
                this.put(CDPSession.CDPSessionEvent.Page_loadEventFired, ignore -> Page.this.emit(PageEvent.Load, true));
                this.put(CDPSession.CDPSessionEvent.Page_javascriptDialogOpening, x$0 -> Page.this.onDialog(x$0));
                this.put(CDPSession.CDPSessionEvent.Runtime_exceptionThrown, x$0 -> Page.this.handleException(x$0));
                this.put(CDPSession.CDPSessionEvent.Inspector_targetCrashed, ignore -> Page.this.onTargetCrashed());
                this.put(CDPSession.CDPSessionEvent.Performance_metrics, x$0 -> Page.this.emitMetrics(x$0));
                this.put(CDPSession.CDPSessionEvent.Log_entryAdded, x$0 -> Page.this.onLogEntryAdded(x$0));
                this.put(CDPSession.CDPSessionEvent.Page_fileChooserOpened, x$0 -> Page.this.onFileChooser(x$0));
            }
        });
        sessionHandlers.forEach((eventName, handler) -> this.primaryTargetClient.on(eventName, (Consumer<?>)handler));
    }

    private void onSecondaryTarget(CDPSession session) {
        if (!"prerender".equals(session.getTarget().subtype())) {
            return;
        }
        try {
            this.frameManager.registerSpeculativeSession(session);
        }
        catch (Exception e) {
            LOGGER.error("frameManager registerSpeculativeSession error: ", (Throwable)e);
        }
        try {
            this.emulationManager.registerSpeculativeSession(session);
        }
        catch (Exception e) {
            LOGGER.error("emulationManager registerSpeculativeSession error: ", (Throwable)e);
        }
    }

    private void initialize() {
        try {
            this.frameManager.initialize(this.primaryTargetClient, null);
            HashMap<String, Object> params = new HashMap<String, Object>();
            this.primaryTargetClient.send("Performance.enable", params);
            this.primaryTargetClient.send("Log.enable", params);
        }
        catch (Exception e) {
            if (e instanceof ProtocolException) {
                LOGGER.error("initialize error: ", (Throwable)e);
            }
            throw e;
        }
    }

    private void onFileChooser(FileChooserOpenedEvent event) {
        if (this.fileChooserResults.isEmpty()) {
            return;
        }
        Frame frame = this.frameManager.frame(event.getFrameId());
        Objects.requireNonNull(frame, "This should never happen.");
        IsolatedWorld mainWorld = frame.worlds().get("mainWorld");
        ElementHandle handle = null;
        try {
            handle = mainWorld.adoptBackendNode(event.getBackendNodeId()).asElement();
        }
        catch (JsonProcessingException e) {
            Helper.throwError((Exception)((Object)e));
        }
        FileChooser fileChooser = new FileChooser(handle, event);
        for (AwaitableResult<FileChooser> subject : this.fileChooserResults) {
            subject.onSuccess(fileChooser);
        }
        this.fileChooserResults.clear();
    }

    public CDPSession client() {
        return this.primaryTargetClient;
    }

    public boolean isServiceWorkerBypassed() {
        return this.serviceWorkerBypassed;
    }

    @Deprecated
    public boolean isDragInterceptionEnabled() {
        return this.userDragInterceptionEnabled;
    }

    public boolean isJavaScriptEnabled() {
        return this.emulationManager.getJavascriptEnabled();
    }

    public AwaitableResult<FileChooser> fileChooserWaitFor() {
        AwaitableResult<FileChooser> result = AwaitableResult.create();
        boolean needsEnable = this.fileChooserResults.isEmpty();
        this.fileChooserResults.add(result);
        if (needsEnable) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("enabled", true);
            this.primaryTargetClient.send("Page.setInterceptFileChooserDialog", params);
        }
        return result;
    }

    public void setGeolocation(GeolocationOptions options) {
        this.emulationManager.setGeolocation(options);
    }

    public Target target() {
        return this.primaryTarget;
    }

    public Browser browser() {
        return this.primaryTarget.browser();
    }

    public BrowserContext browserContext() {
        return this.primaryTarget.browserContext();
    }

    private void onTargetCrashed() {
        this.emit(PageEvent.Error, new JvppeteerException("Page crashed!"));
    }

    private void onLogEntryAdded(EntryAddedEvent event) {
        if (ValidateUtil.isNotEmpty(event.getEntry().getArgs())) {
            event.getEntry().getArgs().forEach(arg -> Helper.releaseObject(this.primaryTargetClient, arg));
        }
        if (!"worker".equals(event.getEntry().getSource())) {
            ArrayList<ConsoleMessageLocation> locations = new ArrayList<ConsoleMessageLocation>();
            locations.add(new ConsoleMessageLocation(event.getEntry().getUrl(), event.getEntry().getLineNumber()));
            this.emit(PageEvent.Console, new ConsoleMessage(this.convertConsoleMessageLevel(event.getEntry().getLevel()), event.getEntry().getText(), Collections.emptyList(), locations));
        }
    }

    public Frame mainFrame() {
        return this.frameManager.mainFrame();
    }

    public Keyboard keyboard() {
        return this.keyboard;
    }

    public Touchscreen touchscreen() {
        return this.touchscreen;
    }

    public Coverage coverage() {
        return this.coverage;
    }

    public Tracing tracing() {
        return this.tracing;
    }

    public List<Frame> frames() {
        return this.frameManager.frames();
    }

    public List<WebWorker> workers() {
        return new ArrayList<WebWorker>(this.workers.values());
    }

    public void setRequestInterception(boolean value) {
        this.frameManager.networkManager().setRequestInterception(value);
    }

    public void setBypassServiceWorker(boolean bypass) {
        this.serviceWorkerBypassed = bypass;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bypass", bypass);
        this.primaryTargetClient.send("Network.setBypassServiceWorker", params);
    }

    @Deprecated
    public void setDragInterception(boolean enabled) {
        this.userDragInterceptionEnabled = enabled;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enabled", enabled);
        this.primaryTargetClient.send("Input.setInterceptDrags", params);
    }

    public void setOfflineMode(boolean enabled) {
        this.frameManager.networkManager().setOfflineMode(enabled);
    }

    public void emulateNetworkConditions(NetworkConditions networkConditions) {
        this.frameManager.networkManager().emulateNetworkConditions(networkConditions);
    }

    public void setDefaultNavigationTimeout(int timeout) {
        this._timeoutSettings.setDefaultNavigationTimeout(timeout);
    }

    public int getDefaultTimeout() {
        return this._timeoutSettings.timeout();
    }

    public void setDefaultTimeout(int timeout) {
        this._timeoutSettings.setDefaultTimeout(timeout);
    }

    public JSHandle queryObjects(JSHandle prototypeHandle) throws JsonProcessingException {
        ValidateUtil.assertArg(!prototypeHandle.disposed(), "Prototype JSHandle is disposed!");
        ValidateUtil.assertArg(StringUtil.isNotEmpty(prototypeHandle.getRemoteObject().getObjectId()), "Prototype JSHandle must not be referencing primitive value");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("prototypeObjectId", prototypeHandle.getRemoteObject().getObjectId());
        JsonNode response = this.mainFrame().client().send("Runtime.queryObjects", params);
        return this.mainFrame().mainRealm().createJSHandle((RemoteObject)Constant.OBJECTMAPPER.treeToValue((TreeNode)response.get("objects"), RemoteObject.class));
    }

    public List<Cookie> cookies() throws JsonProcessingException {
        return this.cookies(this.url());
    }

    public List<Cookie> cookies(String ... urls) throws JsonProcessingException {
        if (urls == null || urls.length == 0) {
            return new ArrayList<Cookie>();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("urls", urls);
        JsonNode result = this.primaryTargetClient.send("Network.getCookies", params);
        JsonNode cookiesNode = result.get("cookies");
        Iterator elements = cookiesNode.elements();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        while (elements.hasNext()) {
            JsonNode cookieNode = (JsonNode)elements.next();
            Cookie cookie = (Cookie)Constant.OBJECTMAPPER.treeToValue((TreeNode)cookieNode, Cookie.class);
            cookies.add(cookie);
        }
        return cookies;
    }

    public void deleteCookie(String ... names) {
        ArrayList<DeleteCookiesRequest> cookies = new ArrayList<DeleteCookiesRequest>();
        for (String name : names) {
            cookies.add(new DeleteCookiesRequest(name));
        }
        this.deleteCookie(cookies);
    }

    public void deleteCookie(List<DeleteCookiesRequest> cookies) {
        String pageURL = this.url();
        for (DeleteCookiesRequest cookie : cookies) {
            if (StringUtil.isEmpty(cookie.getUrl()) && pageURL.startsWith("http")) {
                cookie.setUrl(pageURL);
            }
            Map<String, Object> params = ParamsFactory.create();
            params.put("name", cookie.getName());
            params.put("url", cookie.getUrl());
            params.put("domain", cookie.getDomain());
            params.put("path", cookie.getPath());
            this.primaryTargetClient.send("Network.deleteCookies", params);
        }
    }

    public void setCookie(List<CookieParam> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            return;
        }
        String pageURL = this.url();
        boolean startsWithHTTP = pageURL.startsWith("http");
        cookies.replaceAll(cookie -> {
            if (StringUtil.isEmpty(cookie.getUrl()) && startsWithHTTP) {
                cookie.setUrl(pageURL);
            }
            ValidateUtil.assertArg(!"about:blank".equals(cookie.getUrl()), "Blank page can not have cookie " + cookie.getName());
            if (StringUtil.isNotEmpty(cookie.getUrl())) {
                ValidateUtil.assertArg(!cookie.getUrl().startsWith("data:"), "Data URL page can not have cookie " + cookie.getName());
            }
            return cookie;
        });
        ArrayList<DeleteCookiesRequest> deleteCookiesParameters = new ArrayList<DeleteCookiesRequest>();
        for (CookieParam cookie2 : cookies) {
            deleteCookiesParameters.add(new DeleteCookiesRequest(cookie2.getName(), cookie2.getUrl(), cookie2.getDomain(), cookie2.getPath()));
        }
        this.deleteCookie(deleteCookiesParameters);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cookies", cookies);
        this.primaryTargetClient.send("Network.setCookies", params);
    }

    public void exposeFunction(String name, BindingFunction pptrFunction) throws EvaluateException, JsonProcessingException {
        ValidateUtil.assertArg(!this.bindings.containsKey(name), MessageFormat.format("Failed to add page binding with name {0}: window[{1}] already exists!", name, name));
        String source = Helper.evaluationString(this.addPageBinding(), "exposedFun", name, "puppeteer_");
        Binding binding = new Binding(name, pptrFunction, source);
        this.bindings.put(name, binding);
        NewDocumentScriptEvaluation response = this.frameManager.evaluateOnNewDocument(source);
        this.frameManager.addExposedFunctionBinding(binding);
        this.exposedFunctions.put(name, response.getIdentifier());
    }

    public void removeExposedFunction(String name) throws JsonProcessingException, EvaluateException {
        String exposedFunctionId = this.exposedFunctions.get(name);
        if (exposedFunctionId == null) {
            throw new JvppeteerException("Failed to remove page binding with name '" + name + "' window['" + name + "'] does not exists!");
        }
        this.exposedFunctions.remove(name);
        Binding binging = this.bindings.remove(name);
        this.frameManager.removeScriptToEvaluateOnNewDocument(exposedFunctionId);
        this.frameManager.removeExposedFunctionBinding(binging);
    }

    public void authenticate(Credentials credentials) {
        this.frameManager.networkManager().authenticate(credentials);
    }

    public void setExtraHTTPHeaders(Map<String, String> headers) {
        this.frameManager.networkManager().setExtraHTTPHeaders(headers);
    }

    public void setUserAgent(String userAgent) {
        this.frameManager.networkManager().setUserAgent(userAgent, null);
    }

    public void setUserAgent(String userAgent, UserAgentMetadata userAgentMetadata) {
        this.frameManager.networkManager().setUserAgent(userAgent, userAgentMetadata);
    }

    public Metrics metrics() throws IllegalAccessException, IntrospectionException, InvocationTargetException, JsonProcessingException {
        GetMetricsResponse response = (GetMetricsResponse)Constant.OBJECTMAPPER.treeToValue((TreeNode)this.primaryTargetClient.send("Performance.getMetrics"), GetMetricsResponse.class);
        return this.buildMetricsObject(response.getMetrics());
    }

    private void emitMetrics(MetricsEvent event) {
        PageMetrics pageMetrics = new PageMetrics();
        Metrics metrics = this.buildMetricsObject(event.getMetrics());
        pageMetrics.setMetrics(metrics);
        pageMetrics.setTitle(event.getTitle());
        this.emit(PageEvent.Metrics, pageMetrics);
    }

    private Metrics buildMetricsObject(List<Metric> metrics) {
        Metrics result = new Metrics();
        if (ValidateUtil.isNotEmpty(metrics)) {
            for (Metric metric : metrics) {
                if (!Constant.supportedMetrics.contains(metric.getName())) continue;
                switch (metric.getName()) {
                    case "Timestamp": {
                        result.setTimestamp(metric.getValue());
                        break;
                    }
                    case "Documents": {
                        result.setDocuments(metric.getValue());
                        break;
                    }
                    case "Frames": {
                        result.setFrames(metric.getValue());
                        break;
                    }
                    case "JSEventListeners": {
                        result.setJSEventListeners(metric.getValue());
                        break;
                    }
                    case "Nodes": {
                        result.setNodes(metric.getValue());
                        break;
                    }
                    case "LayoutCount": {
                        result.setLayoutCount(metric.getValue());
                        break;
                    }
                    case "RecalcStyleCount": {
                        result.setRecalcStyleCount(metric.getValue());
                        break;
                    }
                    case "LayoutDuration": {
                        result.setLayoutDuration(metric.getValue());
                        break;
                    }
                    case "RecalcStyleDuration": {
                        result.setRecalcStyleDuration(metric.getValue());
                        break;
                    }
                    case "ScriptDuration": {
                        result.setScriptDuration(metric.getValue());
                        break;
                    }
                    case "TaskDuration": {
                        result.setTaskDuration(metric.getValue());
                        break;
                    }
                    case "JSHeapUsedSize": {
                        result.setJSHeapUsedSize(metric.getValue());
                        break;
                    }
                    case "JSHeapTotalSize": {
                        result.setJSHeapTotalSize(metric.getValue());
                    }
                }
            }
        }
        return result;
    }

    private void handleException(ExceptionThrownEvent event) {
        this.emit(PageEvent.PageError, Helper.createClientError(event.getExceptionDetails()));
    }

    private void onConsoleAPI(IsolatedWorld world, ConsoleAPICalledEvent event) {
        ArrayList<JSHandle> values = new ArrayList<JSHandle>();
        if (ValidateUtil.isNotEmpty(event.getArgs())) {
            for (int i = 0; i < event.getArgs().size(); ++i) {
                RemoteObject arg = event.getArgs().get(i);
                values.add(world.createJSHandle(arg));
            }
        }
        this.addConsoleMessage(this.convertConsoleMessageLevel(event.getType()), values, event.getStackTrace());
    }

    private void addConsoleMessage(ConsoleMessageType type, List<JSHandle> args, StackTrace stackTrace) {
        if (this.listenerCount(PageEvent.Console) == 0) {
            args.forEach(JSHandle::dispose);
            return;
        }
        ArrayList<String> textTokens = new ArrayList<String>();
        for (JSHandle jSHandle : args) {
            RemoteObject remoteObject = jSHandle.getRemoteObject();
            if (StringUtil.isNotEmpty(remoteObject.getObjectId())) {
                textTokens.add(jSHandle.toString());
                continue;
            }
            textTokens.add(Helper.valueFromRemoteObject(remoteObject) + "");
        }
        ArrayList<ConsoleMessageLocation> stackTraceLocations = new ArrayList<ConsoleMessageLocation>();
        if (stackTrace != null && ValidateUtil.isNotEmpty(stackTrace.getCallFrames())) {
            for (CallFrame callFrame : stackTrace.getCallFrames()) {
                stackTraceLocations.add(new ConsoleMessageLocation(callFrame.getUrl(), callFrame.getLineNumber(), callFrame.getColumnNumber()));
            }
        }
        ConsoleMessage consoleMessage = new ConsoleMessage(type, String.join((CharSequence)" ", textTokens), args, stackTraceLocations);
        this.emit(PageEvent.Console, consoleMessage);
    }

    public Response reload() {
        WaitForOptions options = new WaitForOptions();
        options.setIgnoreSameDocumentNavigation(true);
        return this.waitForNavigation(options, true);
    }

    public Response reload(WaitForOptions options) {
        options.setIgnoreSameDocumentNavigation(true);
        return this.waitForNavigation(options, true);
    }

    public CDPSession createCDPSession() {
        return this.target().createCDPSession();
    }

    public Response goBack() throws JsonProcessingException {
        return this.go(-1, new WaitForOptions());
    }

    public Response goBack(WaitForOptions options) throws JsonProcessingException {
        return this.go(-1, options);
    }

    public Response goForward() throws JsonProcessingException {
        return this.go(1, new WaitForOptions());
    }

    public Response goForward(WaitForOptions options) throws JsonProcessingException {
        return this.go(1, options);
    }

    private Response go(int delta, WaitForOptions options) throws JsonProcessingException {
        JsonNode historyNode = this.primaryTargetClient.send("Page.getNavigationHistory");
        GetNavigationHistoryResponse history = (GetNavigationHistoryResponse)Constant.OBJECTMAPPER.treeToValue((TreeNode)historyNode, GetNavigationHistoryResponse.class);
        NavigationEntry entry = history.getEntries().get(history.getCurrentIndex() + delta);
        if (entry == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entryId", entry.getId());
        this.primaryTargetClient.send("Page.navigateToHistoryEntry", params, null, false);
        return this.waitForNavigation(options);
    }

    public void bringToFront() {
        this.primaryTargetClient.send("Page.bringToFront");
    }

    public void setJavaScriptEnabled(boolean enabled) {
        this.emulationManager.setJavaScriptEnabled(enabled);
    }

    public void setBypassCSP(boolean enabled) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enabled", enabled);
        this.primaryTargetClient.send("Page.setBypassCSP", params);
    }

    public void emulateMediaType(MediaType type) {
        this.emulationManager.emulateMediaType(type);
    }

    public void emulateCPUThrottling(double factor) {
        this.emulationManager.emulateCPUThrottling(factor);
    }

    public void emulateMediaFeatures(List<MediaFeature> features) {
        this.emulationManager.emulateMediaFeatures(features);
    }

    public void emulateTimezone(String timezoneId) {
        this.emulationManager.emulateTimezone(timezoneId);
    }

    public void emulateIdleState(IdleOverridesState.Overrides overrides) {
        this.emulationManager.emulateIdleState(overrides);
    }

    public void emulateVisionDeficiency(VisionDeficiency type) {
        this.emulationManager.emulateVisionDeficiency(type);
    }

    public void setViewport(Viewport viewport) {
        boolean needsReload = this.emulationManager.emulateViewport(viewport);
        this.viewport = viewport;
        if (needsReload) {
            this.reload(new WaitForOptions());
        }
    }

    public Viewport viewport() {
        return this.viewport;
    }

    public NewDocumentScriptEvaluation evaluateOnNewDocument(String pageFunction, Object ... args) throws JsonProcessingException {
        String source = Helper.evaluationString(pageFunction, args);
        return this.frameManager.evaluateOnNewDocument(source);
    }

    public NewDocumentScriptEvaluation evaluateOnNewDocument(String pageFunction, EvaluateType type, Object ... args) throws JsonProcessingException {
        String source;
        if (Objects.equals((Object)EvaluateType.STRING, (Object)type)) {
            ValidateUtil.assertArg(args.length == 0, "Cannot evaluate a string with arguments");
            source = pageFunction;
        } else {
            source = Helper.evaluationString(pageFunction, args);
        }
        return this.frameManager.evaluateOnNewDocument(source);
    }

    public void removeScriptToEvaluateOnNewDocument(String identifier) {
        HashMap<String, Object> identifierKeys = new HashMap<String, Object>();
        identifierKeys.put("identifier", identifier);
        this.primaryTargetClient.send("Page.removeScriptToEvaluateOnNewDocument", identifierKeys);
    }

    public void setCacheEnabled(boolean enabled) {
        this.frameManager.networkManager().setCacheEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String screenshot(ScreenshotOptions options) {
        BrowserContext browserContext = this.browserContext();
        synchronized (browserContext) {
            this.bringToFront();
            if (StringUtil.isNotEmpty(options.getPath())) {
                String filePath = options.getPath();
                String path = filePath.substring(0, filePath.lastIndexOf(46) + 1).toLowerCase();
                options.setPath(path + options.getType().toString());
            }
            if (options.getType().equals((Object)ImageType.JPG)) {
                options.setType(ImageType.JPEG);
            }
            if (options.getQuality() != null) {
                ValidateUtil.assertArg(options.getQuality() > 0.0 && options.getQuality() <= 100.0, "Expected quality (" + options.getQuality() + ") to be between 0 and 100 ,inclusive).");
                ValidateUtil.assertArg(Arrays.asList("jpeg", "webp").contains(options.getType().name().toLowerCase()), options.getType().toString() + "screenshots do not support quality.");
            }
            if (options.getClip() != null) {
                ValidateUtil.assertArg(options.getClip().getWidth() > 0.0, "'width' in 'clip' must be positive.");
                ValidateUtil.assertArg(options.getClip().getHeight() > 0.0, "'height' in 'clip' must be positive.");
            }
            Viewport fullViewport = null;
            try {
                Object scrollDimensions;
                if (options.getClip() != null) {
                    ValidateUtil.assertArg(!options.getFullPage(), "'clip' and 'fullPage' are mutually exclusive");
                    options.setClip(this.roundRectangle(this.normalizeRectangle(options.getClip())));
                } else if (options.getFullPage()) {
                    if (!options.getCaptureBeyondViewport()) {
                        scrollDimensions = (LinkedHashMap)this.mainFrame().isolatedRealm().evaluate("() => {\n              const element = document.documentElement;\n              return {\n                width: element.scrollWidth,\n                height: element.scrollHeight,\n              };\n            }", null);
                        fullViewport = new Viewport((Integer)((LinkedHashMap)scrollDimensions).get("width"), (Integer)((LinkedHashMap)scrollDimensions).get("height"), this.viewport.getDeviceScaleFactor(), this.viewport.getIsMobile(), this.viewport.getHasTouch(), this.viewport.getIsLandscape());
                        this.setViewport(fullViewport);
                    }
                } else {
                    options.setCaptureBeyondViewport(false);
                }
                scrollDimensions = this._screenshot(options);
                return scrollDimensions;
            }
            catch (Exception e) {
                LOGGER.error("_screenshot error: ", (Throwable)e);
            }
            finally {
                if (fullViewport != null) {
                    this.setViewport(this.viewport);
                }
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _screenshot(ScreenshotOptions options) {
        Map<String, Object> params = ParamsFactory.create();
        try {
            ScreenshotClip clip;
            if (options.getOmitBackground() && (ImageType.PNG.equals((Object)options.getType()) || ImageType.WEBP.equals((Object)options.getType()))) {
                this.emulationManager.setTransparentBackgroundColor();
            }
            if ((clip = options.getClip()) != null && !options.getCaptureBeyondViewport()) {
                Object response = this.mainFrame().isolatedRealm().evaluate("() => {\n          const {\n            height,\n            pageLeft: x,\n            pageTop: y,\n            width,\n          } = window.visualViewport;\n          return {x, y, height, width};\n        }", null);
                JsonNode responseNode = Constant.OBJECTMAPPER.readTree(Constant.OBJECTMAPPER.writeValueAsString(response));
                clip = this.getIntersectionRect(clip, responseNode);
            }
            params.put("format", options.getType().toString());
            if (options.getOptimizeForSpeed()) {
                params.put("optimizeForSpeed", options.getOptimizeForSpeed());
            }
            if (options.getQuality() != null) {
                params.put("quality", Math.round(options.getQuality()));
            }
            if (clip != null) {
                params.put("clip", clip);
            }
            if (!options.getFromSurface()) {
                params.put("fromSurface", options.getFromSurface());
            }
            params.put("captureBeyondViewport", options.getCaptureBeyondViewport());
            JsonNode result = this.primaryTargetClient.send("Page.captureScreenshot", params);
            String data = result.get("data").asText();
            byte[] buffer = Base64.getDecoder().decode(data);
            if (StringUtil.isNotEmpty(options.getPath())) {
                Files.write(Paths.get(options.getPath(), new String[0]), buffer, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
            String string = data;
            return string;
        }
        catch (Exception var) {
            LOGGER.error("_screenshot error: ", (Throwable)var);
        }
        finally {
            if (options.getOmitBackground() && (ImageType.PNG.equals((Object)options.getType()) || ImageType.WEBP.equals((Object)options.getType()))) {
                this.emulationManager.resetDefaultBackgroundColor();
            }
        }
        return null;
    }

    private ScreenshotClip getIntersectionRect(ScreenshotClip clip, JsonNode viewport) {
        double x = Math.max(clip.getX(), viewport.get("x").asDouble());
        double y = Math.max(clip.getY(), viewport.get("y").asDouble());
        return new ScreenshotClip(x, y, Math.max(Math.min(clip.getX() + clip.getWidth(), viewport.get("x").asDouble() + viewport.get("width").asDouble()) - x, 0.0), Math.max(Math.min(clip.getY() + clip.getHeight(), viewport.get("y").asDouble() + viewport.get("height").asDouble()) - y, 0.0), 1.0);
    }

    private ScreenshotClip roundRectangle(ScreenshotClip clip) {
        double x = Math.round(clip.getX());
        double y = Math.round(clip.getY());
        double width = Math.round(clip.getWidth() + clip.getX() - x);
        double height = Math.round(clip.getHeight() + clip.getY() - y);
        ScreenshotClip screenshotClip = new ScreenshotClip(x, y, width, height);
        screenshotClip.setScale(clip.getScale());
        return screenshotClip;
    }

    private ScreenshotClip normalizeRectangle(ScreenshotClip clip) {
        double height;
        double y;
        double width;
        double x;
        if (clip.getWidth() < 0.0) {
            x = clip.getX() + clip.getWidth();
            width = -clip.getWidth();
        } else {
            x = clip.getX();
            width = clip.getWidth();
        }
        if (clip.getHeight() < 0.0) {
            y = clip.getY() + clip.getHeight();
            height = -clip.getHeight();
        } else {
            y = clip.getY();
            height = clip.getHeight();
        }
        ScreenshotClip copy = clip.copy(x, y, width, height);
        copy.setScale(clip.getScale());
        return copy;
    }

    public String screenshot(String path) {
        return this.screenshot(new ScreenshotOptions(path));
    }

    public byte[] pdf(PDFOptions options) throws IOException {
        return this.pdf(options, LengthUnit.IN);
    }

    public void pdf(String path) throws IOException {
        this.pdf(new PDFOptions(path), LengthUnit.IN);
    }

    public byte[] pdf(PDFOptions options, LengthUnit lengthUnit) throws IOException {
        JsonNode handle;
        Number marginRight;
        Number marginBottom;
        Number marginLeft;
        double paperWidth = 8.5;
        double paperHeight = 11.0;
        if (options.getFormat() != null) {
            PaperFormats format = options.getFormat();
            paperWidth = format.getWidth();
            paperHeight = format.getHeight();
        } else {
            Double height;
            Double width = this.convertPrintParameterToInches(options.getWidth(), lengthUnit);
            if (width != null) {
                paperWidth = width;
            }
            if ((height = this.convertPrintParameterToInches(options.getHeight(), lengthUnit)) != null) {
                paperHeight = height;
            }
        }
        PDFMargin margin = options.getMargin();
        Number marginTop = this.convertPrintParameterToInches(margin.getTop(), lengthUnit);
        if (marginTop == null) {
            marginTop = 0;
        }
        if ((marginLeft = this.convertPrintParameterToInches(margin.getLeft(), lengthUnit)) == null) {
            marginLeft = 0;
        }
        if ((marginBottom = this.convertPrintParameterToInches(margin.getBottom(), lengthUnit)) == null) {
            marginBottom = 0;
        }
        if ((marginRight = this.convertPrintParameterToInches(margin.getRight(), lengthUnit)) == null) {
            marginRight = 0;
        }
        if (options.getOutline()) {
            options.setTagged(true);
        }
        if (options.getOmitBackground()) {
            this.emulationManager.setTransparentBackgroundColor();
        }
        if (options.getWaitForFonts()) {
            this.mainFrame().evaluate("() => { return document.fonts.ready;}");
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("transferMode", "ReturnAsStream");
        params.put("landscape", options.getLandscape());
        params.put("displayHeaderFooter", options.getDisplayHeaderFooter());
        params.put("headerTemplate", options.getHeaderTemplate());
        params.put("footerTemplate", options.getFooterTemplate());
        params.put("printBackground", options.getPrintBackground());
        params.put("scale", options.getScale());
        params.put("paperWidth", paperWidth);
        params.put("paperHeight", paperHeight);
        params.put("marginTop", marginTop);
        params.put("marginBottom", marginBottom);
        params.put("marginLeft", marginLeft);
        params.put("marginRight", marginRight);
        params.put("pageRanges", options.getPageRanges());
        params.put("preferCSSPageSize", options.getPreferCSSPageSize());
        params.put("generateTaggedPDF", options.getTagged());
        params.put("generateDocumentOutline", options.getOutline());
        JsonNode result = this.primaryTargetClient.send("Page.printToPDF", params);
        if (options.getOmitBackground()) {
            this.emulationManager.resetDefaultBackgroundColor();
        }
        ValidateUtil.assertArg((handle = result.get("stream")) != null, "Page.printToPDF result has no stream handle. Please check your chrome version. result=" + result);
        return Helper.readProtocolStream(this.primaryTargetClient, handle.asText(), options.getPath());
    }

    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean runBeforeUnload) {
        BrowserContext browserContext = this.browserContext();
        synchronized (browserContext) {
            ValidateUtil.assertArg(this.primaryTargetClient.getConnection() != null, "Protocol error: Connection closed. Most likely the page has been closed.");
            if (runBeforeUnload) {
                this.primaryTargetClient.send("Page.close");
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("targetId", this.primaryTarget.getTargetId());
                this.primaryTargetClient.getConnection().send("Target.closeTarget", params);
                this.tabTarget.waitForTargetClose();
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Mouse mouse() {
        return this.mouse;
    }

    public DeviceRequestPrompt waitForDevicePrompt() {
        return this.waitForDevicePrompt(this._timeoutSettings.timeout());
    }

    public DeviceRequestPrompt waitForDevicePrompt(int timeout) {
        return this.mainFrame().waitForDevicePrompt(timeout);
    }

    public void click(String selector) throws JsonProcessingException, EvaluateException {
        this.click(selector, new ClickOptions());
    }

    public void click(String selector, ClickOptions options) throws JsonProcessingException, EvaluateException {
        this.mainFrame().click(selector, options);
    }

    public void focus(String selector) throws JsonProcessingException, EvaluateException {
        this.mainFrame().focus(selector);
    }

    public void hover(String selector) throws JsonProcessingException, EvaluateException {
        this.mainFrame().hover(selector);
    }

    public List<String> select(String selector, List<String> values) throws JsonProcessingException, EvaluateException {
        return this.mainFrame().select(selector, values);
    }

    public void tap(String selector) throws JsonProcessingException, EvaluateException {
        this.mainFrame().tap(selector);
    }

    public void type(String selector, String text) throws JsonProcessingException, EvaluateException {
        this.mainFrame().type(selector, text, 0L);
    }

    public void type(String selector, String text, long delay) throws JsonProcessingException, EvaluateException {
        this.mainFrame().type(selector, text, delay);
    }

    public ElementHandle $(String selector) throws JsonProcessingException, EvaluateException {
        return this.mainFrame().$(selector);
    }

    public List<ElementHandle> $$(String selector) throws JsonProcessingException, EvaluateException {
        return this.mainFrame().$$(selector);
    }

    public JSHandle evaluateHandle(String pageFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pageFunction = Helper.withSourcePuppeteerURLIfNone("evaluateHandle", pageFunction);
        return this.mainFrame().evaluateHandle(pageFunction, args);
    }

    public JSHandle evaluateHandle(String pageFunction) throws JsonProcessingException, EvaluateException {
        return this.evaluateHandle(pageFunction, null);
    }

    public Object $eval(String selector, String pageFunction) throws JsonProcessingException, EvaluateException {
        return this.$eval(selector, pageFunction, null);
    }

    public Object $eval(String selector, String pageFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pageFunction = Helper.withSourcePuppeteerURLIfNone("$eval", pageFunction);
        return this.mainFrame().$eval(selector, pageFunction, args);
    }

    public Object $$eval(String selector, String pageFunction) throws JsonProcessingException, EvaluateException {
        return this.$$eval(selector, pageFunction, new ArrayList<Object>());
    }

    public Object $$eval(String selector, String pageFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pageFunction = Helper.withSourcePuppeteerURLIfNone("$$eval", pageFunction);
        return this.mainFrame().$$eval(selector, pageFunction, args);
    }

    public ElementHandle addScriptTag(FrameAddScriptTagOptions options) throws IOException, EvaluateException {
        return this.mainFrame().addScriptTag(options);
    }

    public ElementHandle addStyleTag(FrameAddStyleTagOptions options) throws IOException, EvaluateException {
        return this.mainFrame().addStyleTag(options);
    }

    public String url() {
        return this.mainFrame().url();
    }

    public String content() throws JsonProcessingException, EvaluateException {
        return this.mainFrame().content();
    }

    public void setContent(String html) throws JsonProcessingException, EvaluateException {
        this.setContent(html, new WaitForOptions());
    }

    public void setContent(String html, WaitForOptions options) throws JsonProcessingException, EvaluateException {
        this.mainFrame().setContent(html, options);
    }

    public Response goTo(String url, boolean isBlock) {
        return this.goTo(url, new GoToOptions(), isBlock);
    }

    public Response goTo(String url, GoToOptions options) {
        return this.goTo(url, options, true);
    }

    public Response goTo(String url, GoToOptions options, boolean isBlock) {
        return this.mainFrame().goTo(url, options, isBlock);
    }

    public static Page create(CDPSession client, Target target, Viewport viewport) {
        Page page = new Page(client, target);
        page.initialize();
        if (viewport != null) {
            page.setViewport(viewport);
        }
        return page;
    }

    public Response goTo(String url) {
        return this.goTo(url, true);
    }

    public Response waitForNavigation() {
        return this.mainFrame().waitForNavigation(new WaitForOptions(), false);
    }

    public Response waitForNavigation(WaitForOptions options, boolean reload) {
        return this.mainFrame().waitForNavigation(options, reload);
    }

    public Response waitForNavigation(WaitForOptions options) {
        return this.mainFrame().waitForNavigation(options, false);
    }

    public Request waitForRequest(String url) {
        ValidateUtil.assertArg(StringUtil.isNotEmpty(url), "waitForRequest url must not be empty");
        return this.waitForRequest(url, null, this._timeoutSettings.timeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request waitForRequest(String url, Predicate<Request> predicate, int timeout) {
        if (timeout < 0) {
            timeout = this._timeoutSettings.timeout();
        }
        AtomicReference result = new AtomicReference();
        Predicate<Request> requestPredicate = request -> {
            if (StringUtil.isNotEmpty(url)) {
                return url.equals(request.url());
            }
            if (predicate != null) {
                return predicate.test((Request)request);
            }
            return false;
        };
        AtomicReference targetCloseException = new AtomicReference();
        Consumer<Object> targetCloseListener = ignore -> targetCloseException.set(new TargetCloseException("Page closed!"));
        this.once(PageEvent.Close, targetCloseListener);
        Consumer<Request> requestListener = request -> {
            if (requestPredicate.test((Request)request)) {
                result.set(request);
            }
        };
        this.on(PageEvent.Request, requestListener);
        Supplier<Boolean> conditionChecker = () -> {
            if (targetCloseException.get() != null) {
                throw (TargetCloseException)targetCloseException.get();
            }
            return result.get() == null ? null : Boolean.valueOf(true);
        };
        try {
            Helper.waitForCondition(conditionChecker, timeout, "WaitForRequest timeout of " + timeout + " ms exceeded");
        }
        finally {
            this.off(PageEvent.Request, requestListener);
            this.off(PageEvent.Close, targetCloseListener);
        }
        return (Request)result.get();
    }

    public Response waitForResponse(Predicate<Response> predicate) {
        return this.waitForResponse(null, predicate);
    }

    public Response waitForResponse(String url) {
        return this.waitForResponse(url, null, this._timeoutSettings.timeout());
    }

    public Response waitForResponse(String url, Predicate<Response> predicate) {
        return this.waitForResponse(url, predicate, this._timeoutSettings.timeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response waitForResponse(String url, Predicate<Response> predicate, int timeout) {
        if (timeout <= 0) {
            timeout = this._timeoutSettings.timeout();
        }
        Predicate<Response> predi = response -> {
            if (StringUtil.isNotEmpty(url)) {
                return url.equals(response.url());
            }
            if (predicate != null) {
                return predicate.test((Response)response);
            }
            return false;
        };
        AtomicReference result = new AtomicReference();
        Consumer<Response> responseListener = response -> {
            if (predi.test((Response)response)) {
                result.set(response);
            }
        };
        this.on(PageEvent.Response, responseListener);
        AtomicReference targetCloseException = new AtomicReference();
        this.once(PageEvent.Close, s -> targetCloseException.set(new TargetCloseException("Page closed!")));
        Supplier<Boolean> conditonChecker = () -> {
            if (targetCloseException.get() != null) {
                throw (TargetCloseException)targetCloseException.get();
            }
            return result.get() == null ? null : Boolean.valueOf(true);
        };
        try {
            Helper.waitForCondition(conditonChecker, timeout, "WaitForResponse timeout of " + timeout + " ms exceeded");
        }
        finally {
            this.off(PageEvent.Response, responseListener);
        }
        return (Response)result.get();
    }

    public Frame waitForFrame(String url) {
        return this.waitForFrame(url, null, 30000);
    }

    public Frame waitForFrame(Predicate<Frame> framePredicate) {
        return this.waitForFrame(null, framePredicate, 30000);
    }

    public Frame waitForFrame(String url, Predicate<Frame> framePredicate, int timeout) {
        if (timeout <= 0) {
            timeout = this._timeoutSettings.timeout();
        }
        Predicate<Frame> predicate = frame -> {
            if (StringUtil.isNotEmpty(url)) {
                return url.equals(frame.url());
            }
            if (framePredicate != null) {
                return framePredicate.test((Frame)frame);
            }
            return false;
        };
        AtomicReference targetCloseException = new AtomicReference();
        this.once(PageEvent.Close, s -> targetCloseException.set(new TargetCloseException("Page closed!")));
        Supplier<Frame> conditionChecker = () -> {
            if (targetCloseException.get() != null) {
                throw (TargetCloseException)targetCloseException.get();
            }
            return Helper.filter(this.frames(), predicate);
        };
        return Helper.waitForCondition(conditionChecker, timeout, "WaitForFrame timeout of " + timeout + " ms exceeded");
    }

    public Object evaluate(String pageFunction) throws JsonProcessingException, EvaluateException {
        return this.evaluate(pageFunction, null);
    }

    public Object evaluate(String pageFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pageFunction = Helper.withSourcePuppeteerURLIfNone("evaluate", pageFunction);
        return this.mainFrame().evaluate(pageFunction, args);
    }

    private void onBindingCalled(IsolatedWorld world, BindingCalledEvent event) {
        BindingPayload payload;
        String payloadStr = event.getPayload();
        try {
            payload = (BindingPayload)Constant.OBJECTMAPPER.readValue(payloadStr, BindingPayload.class);
        }
        catch (JsonProcessingException e) {
            return;
        }
        if (!"exposedFun".equals(payload.getType())) {
            return;
        }
        if (world.context() == null) {
            return;
        }
        Binding binding = this.bindings.get(payload.getName());
        Optional.ofNullable(binding).ifPresent(b -> b.run(world.context(), payload.getSeq(), payload.getArgs(), payload.getIsTrivial()));
    }

    private void onDialog(JavascriptDialogOpeningEvent event) {
        Dialog dialog = new Dialog(this.primaryTargetClient, event.getType(), event.getMessage(), event.getDefaultPrompt());
        this.emit(PageEvent.Dialog, dialog);
    }

    private String addPageBinding() {
        return "function addPageBinding(type, name, prefix) {\n\n\n\n\n    if (globalThis[name]) {\n        return;\n    }\n\n    Object.assign(globalThis, {\n        [name](...args) {\n\n\n            const callPuppeteer = globalThis[name];\n            callPuppeteer.args ??= new Map();\n            callPuppeteer.callbacks ??= new Map();\n            const seq = (callPuppeteer.lastSeq ?? 0) + 1;\n            callPuppeteer.lastSeq = seq;\n            callPuppeteer.args.set(seq, args);\n\n\n            globalThis[prefix + name](JSON.stringify({\n                type,\n                name,\n                seq,\n                args,\n                isTrivial: !args.some(value => {\n                    return value instanceof Node;\n                }),\n            }));\n            return new Promise((resolve, reject) => {\n                callPuppeteer.callbacks.set(seq, {\n                    resolve(value) {\n                        callPuppeteer.args.delete(seq);\n                        resolve(value);\n                    },\n                    reject(value) {\n                        callPuppeteer.args.delete(seq);\n                        reject(value);\n                    },\n                });\n            });\n        },\n    });\n}";
    }

    public ElementHandle waitForSelector(String selector) throws JsonProcessingException {
        return this.waitForSelector(selector, new WaitForSelectorOptions());
    }

    public ElementHandle waitForSelector(String selector, WaitForSelectorOptions options) throws JsonProcessingException {
        return this.mainFrame().waitForSelector(selector, options);
    }

    public JSHandle waitForFunction(String pageFunction) {
        return this.waitForFunction(pageFunction, new WaitForSelectorOptions(), new Object[0]);
    }

    public JSHandle waitForFunction(String pageFunction, WaitForSelectorOptions options, Object ... args) {
        return this.mainFrame().waitForFunction(pageFunction, options, args == null ? null : Arrays.asList(args));
    }

    private Double convertPrintParameterToInches(String parameter, LengthUnit lengthUnit) {
        double pixels;
        if (StringUtil.isEmpty(parameter)) {
            return null;
        }
        if (Helper.isNumber(parameter)) {
            pixels = Double.parseDouble(parameter);
        } else if (parameter.endsWith("px") || parameter.endsWith("in") || parameter.endsWith("cm") || parameter.endsWith("mm")) {
            String valueText;
            String unit = parameter.substring(parameter.length() - 2).toLowerCase();
            if (unitToPixels.containsKey(unit)) {
                valueText = parameter.substring(0, parameter.length() - 2);
            } else {
                unit = "px";
                valueText = parameter;
            }
            double value = Double.parseDouble(valueText);
            ValidateUtil.assertArg(!Double.isNaN(value), "Failed to parse parameter value: " + parameter);
            pixels = value * unitToPixels.get(unit);
        } else {
            throw new IllegalArgumentException("page.pdf() Cannot handle parameter type: " + parameter);
        }
        return pixels / unitToPixels.get(lengthUnit.getValue());
    }

    private ConsoleMessageType convertConsoleMessageLevel(String method) {
        if ("warning".equals(method)) {
            return ConsoleMessageType.WARN;
        }
        return ConsoleMessageType.valueOf(method.toUpperCase());
    }

    public String title() throws JsonProcessingException {
        return this.mainFrame().title();
    }

    public void emulate(Device device) {
        this.setUserAgent(device.getUserAgent());
        this.setViewport(device.getViewport());
    }

    public void setIsDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public Accessibility accessibility() {
        return this.mainFrame().accessibility();
    }

    public ScreenRecorder screencast(ScreencastOptions options) throws IOException {
        ValidateUtil.assertArg(StringUtil.isNotBlank(options.getPath()), "Path must be specified");
        if (options.getFormat() != null) {
            ValidateUtil.assertArg(options.getPath().endsWith(options.getFormat().getFormat()), "Extension of Path (" + options.getPath() + ")+ has to match the used output format (" + options.getFormat().getFormat() + ").");
        }
        Viewport defaultViewport = this.viewport();
        Viewport tempViewport = null;
        if (defaultViewport != null && defaultViewport.getDeviceScaleFactor() != 0.0) {
            tempViewport = new Viewport(defaultViewport.getWidth(), defaultViewport.getHeight(), 0.0, defaultViewport.getIsMobile(), defaultViewport.getHasTouch(), defaultViewport.getIsLandscape());
            this.setViewport(tempViewport);
        }
        ArrayList response = (ArrayList)this.mainFrame().isolatedRealm().evaluate("() => {\n                    return [\n                      window.visualViewport.width * window.devicePixelRatio,\n                      window.visualViewport.height * window.devicePixelRatio,\n                      window.devicePixelRatio,\n                    ]\n                }");
        double width = Double.parseDouble(response.get(0) + "");
        double height = Double.parseDouble(response.get(1) + "");
        double devicePixelRatio = Double.parseDouble(response.get(2) + "");
        BoundingBox crop = null;
        if (Objects.nonNull(options.getCrop())) {
            ScreenshotClip boundingBox = this.roundRectangle(this.normalizeRectangle(new ScreenshotClip(options.getCrop().getX(), options.getCrop().getY(), options.getCrop().getWidth(), options.getCrop().getHeight())));
            if (boundingBox.getX() < 0.0 || boundingBox.getY() < 0.0) {
                throw new JvppeteerException("crop.x and crop.y must be greater than or equal to 0.");
            }
            if (boundingBox.getWidth() <= 0.0 || boundingBox.getHeight() <= 0.0) {
                throw new JvppeteerException("crop.width and crop.height must be greater than 0.");
            }
            double viewportWidth = width / devicePixelRatio;
            double viewportHeight = height / devicePixelRatio;
            if (boundingBox.getX() + boundingBox.getWidth() > viewportWidth) {
                throw new JvppeteerException("crop.width cannot be larger than the viewport width(" + viewportWidth + ")");
            }
            if (boundingBox.getY() + boundingBox.getHeight() > viewportHeight) {
                throw new JvppeteerException("crop.height cannot be larger than the viewport width(" + viewportHeight + ")");
            }
            crop = new BoundingBox(boundingBox.getX() * devicePixelRatio, boundingBox.getY() * devicePixelRatio, boundingBox.getWidth() * devicePixelRatio, boundingBox.getHeight() * devicePixelRatio);
        }
        if (options.getSpeed() <= 0.0) {
            throw new JvppeteerException("speed must be greater than 0.");
        }
        if (options.getScale() <= 0.0) {
            throw new JvppeteerException("scale must be greater than 0.");
        }
        ScreenRecorder recorder = new ScreenRecorder(this, width, height, new ScreenRecorderOptions(options.getSpeed(), crop, options.getPath(), options.getFormat(), options.getScale(), options.getFfmpegPath()), defaultViewport, tempViewport);
        try {
            this.startScreencast();
        }
        catch (Exception e) {
            recorder.stop();
            LOGGER.error("startScreencast error: ", (Throwable)e);
            return null;
        }
        return recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startScreencast() {
        this.screencastSessionCount.incrementAndGet();
        if (!this.startScreencasted) {
            Page page = this;
            synchronized (page) {
                if (!this.startScreencasted) {
                    AwaitableResult awaitableResult = AwaitableResult.create();
                    this.mainFrame().client().on(CDPSession.CDPSessionEvent.Page_screencastFrame, (? event) -> awaitableResult.complete());
                    Map<String, Object> params = ParamsFactory.create();
                    params.put("format", "png");
                    this.mainFrame().client().send("Page.startScreencast", params);
                    awaitableResult.waiting();
                    this.startScreencasted = true;
                }
            }
        }
    }

    public void stopScreencast() {
        long count = this.screencastSessionCount.decrementAndGet();
        if (!this.startScreencasted) {
            return;
        }
        this.startScreencasted = false;
        if (count == 0L) {
            this.mainFrame().client().send("Page.stopScreencast");
        }
    }

    public static enum PageEvent {
        Close("close"),
        Console("console"),
        Dialog("dialog"),
        Domcontentloaded("domcontentloaded"),
        Error("error"),
        FrameAttached("frameattached"),
        FrameDetached("framedetached"),
        FrameNavigated("framenavigated"),
        Load("load"),
        Metrics("metrics"),
        PageError("pageerror"),
        Popup("popup"),
        Request("request"),
        RequestServedFromCache("requestservedfromcache"),
        RequestFailed("requestfailed"),
        RequestFinished("requestfinished"),
        Response("response"),
        WorkerCreated("workercreated"),
        WorkerDestroyed("workerdestroyed");

        private String eventName;

        private PageEvent(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }
    }
}

