/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.ruiyun.jvppeteer.core.Request;
import com.ruiyun.jvppeteer.entities.QueuedEventGroup;
import com.ruiyun.jvppeteer.entities.RedirectInfo;
import com.ruiyun.jvppeteer.events.RequestPausedEvent;
import com.ruiyun.jvppeteer.events.RequestWillBeSentEvent;
import com.ruiyun.jvppeteer.events.ResponseReceivedExtraInfoEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class NetworkEventManager {
    private final Map<String, RequestWillBeSentEvent> requestWillBeSentMap = new HashMap<String, RequestWillBeSentEvent>();
    private final Map<String, RequestPausedEvent> requestPausedMap = new HashMap<String, RequestPausedEvent>();
    private final Map<String, Request> httpRequestsMap = new HashMap<String, Request>();
    private final Map<String, LinkedList<ResponseReceivedExtraInfoEvent>> responseReceivedExtraInfoMap = new HashMap<String, LinkedList<ResponseReceivedExtraInfoEvent>>();
    private final Map<String, LinkedList<RedirectInfo>> queuedRedirectInfoMap = new HashMap<String, LinkedList<RedirectInfo>>();
    private final Map<String, QueuedEventGroup> queuedEventGroupMap = new HashMap<String, QueuedEventGroup>();

    public void forget(String networkRequestId) {
        this.requestWillBeSentMap.remove(networkRequestId);
        this.requestPausedMap.remove(networkRequestId);
        this.queuedEventGroupMap.remove(networkRequestId);
        this.queuedRedirectInfoMap.remove(networkRequestId);
        this.responseReceivedExtraInfoMap.remove(networkRequestId);
    }

    public LinkedList<ResponseReceivedExtraInfoEvent> responseExtraInfo(String networkRequestId) {
        if (!this.responseReceivedExtraInfoMap.containsKey(networkRequestId)) {
            this.responseReceivedExtraInfoMap.put(networkRequestId, new LinkedList());
        }
        return this.responseReceivedExtraInfoMap.get(networkRequestId);
    }

    private LinkedList<RedirectInfo> queuedRedirectInfo(String fetchRequestId) {
        if (!this.queuedRedirectInfoMap.containsKey(fetchRequestId)) {
            this.queuedRedirectInfoMap.put(fetchRequestId, new LinkedList());
        }
        return this.queuedRedirectInfoMap.get(fetchRequestId);
    }

    public void queueRedirectInfo(String fetchRequestId, RedirectInfo redirectInfo) {
        this.queuedRedirectInfo(fetchRequestId).add(redirectInfo);
    }

    public RedirectInfo takeQueuedRedirectInfo(String fetchRequestId) {
        return this.queuedRedirectInfo(fetchRequestId).poll();
    }

    public int inFlightRequestsCount() {
        int inFlightRequestCounter = 0;
        for (Request request : this.httpRequestsMap.values()) {
            if (request.response() != null) continue;
            ++inFlightRequestCounter;
        }
        return inFlightRequestCounter;
    }

    public void storeRequestWillBeSent(String networkRequestId, RequestWillBeSentEvent event) {
        this.requestWillBeSentMap.put(networkRequestId, event);
    }

    public RequestWillBeSentEvent getRequestWillBeSent(String networkRequestId) {
        return this.requestWillBeSentMap.get(networkRequestId);
    }

    public void forgetRequestWillBeSent(String networkRequestId) {
        this.requestWillBeSentMap.remove(networkRequestId);
    }

    public RequestPausedEvent getRequestPaused(String networkRequestId) {
        return this.requestPausedMap.get(networkRequestId);
    }

    public void forgetRequestPaused(String networkRequestId) {
        this.requestPausedMap.remove(networkRequestId);
    }

    public void storeRequestPaused(String networkRequestId, RequestPausedEvent event) {
        this.requestPausedMap.put(networkRequestId, event);
    }

    public Request getRequest(String networkRequestId) {
        return this.httpRequestsMap.get(networkRequestId);
    }

    public void storeRequest(String networkRequestId, Request request) {
        this.httpRequestsMap.put(networkRequestId, request);
    }

    public void forgetRequest(String networkRequestId) {
        this.httpRequestsMap.remove(networkRequestId);
    }

    public QueuedEventGroup getQueuedEventGroup(String networkRequestId) {
        return this.queuedEventGroupMap.get(networkRequestId);
    }

    public void queueEventGroup(String networkRequestId, QueuedEventGroup event) {
        this.queuedEventGroupMap.put(networkRequestId, event);
    }

    public void forgetQueuedEventGroup(String networkRequestId) {
        this.queuedEventGroupMap.remove(networkRequestId);
    }
}

