/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.core.Frame;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;

public class FrameTree {
    private final Map<String, Frame> frames = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, String> parentIds = new ConcurrentHashMap<String, String>();
    private final Map<String, Set<String>> childIds = new ConcurrentHashMap<String, Set<String>>();
    private Frame mainFrame;
    private volatile boolean isMainFrameStale = false;
    final Map<String, Set<AwaitableResult<Frame>>> waitRequests = new ConcurrentHashMap<String, Set<AwaitableResult<Frame>>>();

    public Frame getMainFrame() {
        return this.mainFrame;
    }

    public Frame getById(String frameId) {
        return this.frames.get(frameId);
    }

    public Frame waitForFrame(String frameId) {
        AwaitableResult awaitableResult = AwaitableResult.create();
        this.waitRequests.computeIfAbsent(frameId, k -> new CopyOnWriteArraySet()).add(awaitableResult);
        Frame frame = this.getById(frameId);
        if (frame != null) {
            return frame;
        }
        return (Frame)awaitableResult.waitingGetResult(30000, TimeUnit.MILLISECONDS);
    }

    public List<Frame> frames() {
        return new ArrayList<Frame>(this.frames.values());
    }

    public void addFrame(Frame frame) {
        this.frames.put(frame.id(), frame);
        if (StringUtil.isNotEmpty(frame.parentId())) {
            this.parentIds.put(frame.id(), frame.parentId());
            this.childIds.computeIfAbsent(frame.parentId(), k -> new HashSet()).add(frame.id());
        } else if (this.mainFrame == null || this.isMainFrameStale) {
            this.mainFrame = frame;
            this.isMainFrameStale = false;
        }
        Set<AwaitableResult<Frame>> callbacks = this.waitRequests.remove(frame.id());
        if (ValidateUtil.isNotEmpty(callbacks)) {
            callbacks.forEach(request -> request.onSuccess(frame));
        }
    }

    public void removeFrame(Frame frame) {
        String frameId = frame.id();
        this.frames.remove(frameId);
        this.parentIds.remove(frameId);
        if (StringUtil.isNotEmpty(frame.parentId())) {
            Set<String> children = this.childIds.get(frame.parentId());
            if (children != null) {
                children.remove(frameId);
            }
        } else {
            this.isMainFrameStale = true;
        }
    }

    public List<Frame> childFrames(String frameId) {
        Set<String> childIds = this.childIds.get(frameId);
        if (childIds == null) {
            return new ArrayList<Frame>();
        }
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (String id : childIds) {
            Frame frame = this.getById(id);
            if (frame == null) continue;
            frames.add(frame);
        }
        return frames;
    }

    public Frame parentFrame(String frameId) {
        String parentId = this.parentIds.get(frameId);
        return StringUtil.isNotEmpty(parentId) ? this.getById(parentId) : null;
    }
}

