/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ruiyun.jvppeteer.core.ElementHandle;
import com.ruiyun.jvppeteer.events.FileChooserOpenedEvent;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.List;

public class FileChooser {
    private ElementHandle element;
    private volatile boolean handled;
    private boolean multiple;

    public FileChooser() {
    }

    public FileChooser(ElementHandle element, FileChooserOpenedEvent event) {
        this.element = element;
        this.multiple = !"selectSingle".equals(event.getMode());
        this.handled = false;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void accept(List<String> filePaths) throws JsonProcessingException, EvaluateException {
        ValidateUtil.assertArg(!this.handled, "Cannot accept FileChooser which is already handled!");
        this.handled = true;
        this.element.uploadFile(filePaths);
    }

    public void cancel() {
        ValidateUtil.assertArg(!this.handled, "Cannot cancel FileChooser which is already handled!");
        this.handled = true;
    }
}

