/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.LaunchException;
import com.ruiyun.jvppeteer.exception.TimeoutException;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.transport.WebSocketTransport;
import com.ruiyun.jvppeteer.transport.WebSocketTransportFactory;
import com.ruiyun.jvppeteer.util.FileUtil;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserRunner.class);
    private static final Pattern WS_ENDPOINT_PATTERN = Pattern.compile("^DevTools listening on (ws://.*)$");
    private final String executablePath;
    private final List<String> processArguments;
    private final String tempDirectory;
    private Process process;
    private Connection connection;
    private volatile boolean closed;
    private static final List<BrowserRunner> runners = new ArrayList<BrowserRunner>();
    private static boolean isRegisterShutdownHook = false;
    private String pid;

    public BrowserRunner(String executablePath, List<String> processArguments, String tempDirectory) {
        this.executablePath = executablePath;
        this.processArguments = processArguments;
        this.tempDirectory = tempDirectory;
        this.closed = true;
    }

    public void start() throws IOException {
        if (this.process != null) {
            throw new JvppeteerException("This process has previously been started.");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.executablePath);
        arguments.addAll(this.processArguments);
        ProcessBuilder processBuilder = new ProcessBuilder(arguments).redirectErrorStream(true);
        this.process = processBuilder.start();
        this.closed = false;
        this.registerHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerHook() {
        runners.add(this);
        if (isRegisterShutdownHook) {
            return;
        }
        Class<BrowserRunner> clazz = BrowserRunner.class;
        synchronized (BrowserRunner.class) {
            if (!isRegisterShutdownHook) {
                RuntimeShutdownHookRegistry hook = new RuntimeShutdownHookRegistry();
                hook.register(new Thread(this::closeAllBrowser));
                isRegisterShutdownHook = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.closed) {
            return;
        }
        try {
            if ("-1".equals(this.pid) || StringUtil.isEmpty(this.pid)) {
                this.destroyProcess(this.process);
                return;
            }
            Process exec = null;
            String command = "";
            this.destroyProcess(this.process);
            if (Helper.isLinux() || Helper.isMac()) {
                command = "kill -9 " + this.pid;
                exec = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
            } else if (this.process.isAlive()) {
                command = "cmd.exe /c taskkill /PID " + this.pid + " /F /T ";
                exec = Runtime.getRuntime().exec(command);
            }
            try {
                if (exec != null) {
                    LOGGER.info("kill chrome process by pid,command:  {}", (Object)command);
                    exec.waitFor(30000L, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                this.destroyProcess(exec);
            }
        }
        catch (Exception e) {
            LOGGER.error("kill chrome process error ", (Throwable)e);
        }
        finally {
            this.deleteTempUserDir();
        }
    }

    public void destroyProcess(Process process) {
        if (process == null) {
            return;
        }
        process.destroy();
        if (process.isAlive()) {
            process.destroyForcibly();
        }
    }

    public Connection setUpConnection(boolean usePipe, int timeout, int slowMo, boolean dumpio) throws InterruptedException {
        if (usePipe) {
            throw new LaunchException("Temporarily not supported pipe connect to chromuim.If you have a pipe connect to chromium idea,pleaze new a issue in github:https://github.com/fanyong920/jvppeteer/issues");
        }
        String waitForWSEndpoint = this.waitForWSEndpoint(timeout, dumpio);
        WebSocketTransport transport = WebSocketTransportFactory.create(waitForWSEndpoint);
        this.connection = new Connection(waitForWSEndpoint, transport, slowMo, timeout);
        LOGGER.trace("Connect to browser by websocket url: {}", (Object)waitForWSEndpoint);
        return this.connection;
    }

    private String waitForWSEndpoint(int timeout, boolean dumpio) {
        StreamReader reader = new StreamReader(timeout, dumpio, this.process.getInputStream());
        return reader.getResult();
    }

    public Process getProcess() {
        return this.process;
    }

    public void closeAllBrowser() {
        for (BrowserRunner browserRunner : runners) {
            browserRunner.closeBrowser();
        }
    }

    public void closeBrowser() {
        if (this.closed) {
            return;
        }
        if (this.connection != null && !this.connection.closed()) {
            this.connection.send("Browser.close");
        }
        this.destroy();
        this.closed = true;
    }

    private void deleteTempUserDir() {
        if (StringUtil.isNotEmpty(this.tempDirectory)) {
            try {
                FileUtil.removeFolderOnExit(this.tempDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public static class RuntimeShutdownHookRegistry
    implements ShutdownHookRegistry {
    }

    public static interface ShutdownHookRegistry {
        default public void register(Thread thread) {
            Runtime.getRuntime().addShutdownHook(thread);
        }

        default public void remove(Thread thread) {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
    }

    static class StreamReader {
        private final StringBuilder ws = new StringBuilder();
        private final int timeout;
        private final boolean dumpio;
        private final InputStream inputStream;

        public StreamReader(int timeout, boolean dumpio, InputStream inputStream) {
            this.timeout = timeout;
            this.dumpio = dumpio;
            this.inputStream = inputStream;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getResult() {
            StringBuilder chromeOutputBuilder = new StringBuilder();
            long now = System.currentTimeMillis();
            long base = 0L;
            try (InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream);
                 BufferedReader reader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    long remaining;
                    if (this.dumpio) {
                        System.out.println(line);
                    }
                    if ((remaining = (long)this.timeout - base) <= 0L) {
                        throw new TimeoutException("Timed out after " + this.timeout + " ms while trying to connect to the browser!Chrome output: " + chromeOutputBuilder);
                    }
                    Matcher matcher = WS_ENDPOINT_PATTERN.matcher(line);
                    if (matcher.find()) {
                        String string = matcher.group(1);
                        return string;
                    }
                    if (chromeOutputBuilder.length() != 0) {
                        chromeOutputBuilder.append(System.lineSeparator());
                    }
                    chromeOutputBuilder.append(line);
                    base = System.currentTimeMillis() - now;
                }
                throw new LaunchException("Can't get WSEndpoint");
            }
            catch (Exception e) {
                LOGGER.error("Failed to launch the browser process!please see TROUBLESHOOTING: https://github.com/puppeteer/puppeteer/blob/master/docs/troubleshooting.md:", (Throwable)e);
            }
            throw new LaunchException("Can't get WSEndpoint");
        }
    }
}

