/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.common.ChromeReleaseChannel;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.Product;
import com.ruiyun.jvppeteer.entities.FetcherOptions;
import com.ruiyun.jvppeteer.entities.RevisionInfo;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.util.FileUtil;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StreamUtil;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserFetcher.class);
    private static final String LINUX = "linux64";
    private static final String MAC_ARM64 = "mac-arm64";
    private static final String MAC_X64 = "mac-x64";
    private static final String WIN32 = "win32";
    private static final String WIN64 = "win64";
    public static final Map<Product, Map<String, String>> downloadURLs = new HashMap<Product, Map<String, String>>();
    private final String version;
    private String platform;
    private final String downloadHost;
    private String downloadsFolder;
    private final Product product;

    public BrowserFetcher(FetcherOptions options) {
        this.product = options.getProduct() != null ? options.getProduct() : Product.CHROME;
        this.downloadsFolder = options.getCacheDir();
        this.downloadHost = StringUtil.isNotEmpty(options.getHost()) ? options.getHost() : downloadURLs.get((Object)this.product).get("host");
        this.platform = StringUtil.isNotEmpty(options.getPlatform()) ? options.getPlatform() : BrowserFetcher.detectBrowserPlatform();
        this.version = this.resolveVersion(options);
        Objects.requireNonNull(downloadURLs.get((Object)this.product).get(this.platform), "Unsupported platform: " + this.platform);
    }

    private String resolveVersion(FetcherOptions options) {
        if (StringUtil.isNotBlank(options.getVersion())) {
            return options.getVersion();
        }
        if (Objects.nonNull((Object)options.getChannel())) {
            return this.getLastKnownGoodReleaseForChannel(options.getChannel());
        }
        if (StringUtil.isNotBlank(options.getMilestone())) {
            return this.getLastKnownGoodReleaseForMilestone(options.getMilestone());
        }
        if (StringUtil.isNotBlank(options.getBuild())) {
            return this.getLastKnownGoodReleaseForBuild(options.getBuild());
        }
        return null;
    }

    private String getLastKnownGoodReleaseForChannel(ChromeReleaseChannel channel) {
        try {
            String url = "https://googlechromelabs.github.io/chrome-for-testing/last-known-good-versions.json";
            if (Product.CHROMIUM.equals((Object)this.product)) {
                if (channel == ChromeReleaseChannel.LATEST) {
                    url = "https://storage.googleapis.com/chromium-browser-snapshots/" + this.folder() + "/LAST_CHANGE";
                    return this.sendRequest(url, "GET");
                }
                throw new JvppeteerException((Object)((Object)channel) + " is not supported for Chromium. Use 'latest' instead.");
            }
            if (channel == ChromeReleaseChannel.LATEST) {
                channel = ChromeReleaseChannel.CANARY;
            }
            String json = this.sendRequest(url, "GET");
            JsonNode data = Constant.OBJECTMAPPER.readTree(json);
            HashMap channels = new HashMap();
            data.get("channels").fields().forEachRemaining(entry -> channels.put(((String)entry.getKey()).toLowerCase(), entry.getValue()));
            JsonNode channelData = (JsonNode)channels.get(channel.getValue());
            if (channelData == null) {
                throw new JvppeteerException("No Such channel: " + channel.getValue());
            }
            return channelData.get("version").asText();
        }
        catch (Exception e) {
            LOGGER.error("Fail to get release by channel {}", (Object)channel, (Object)e);
            return null;
        }
    }

    private String getLastKnownGoodReleaseForBuild(String buildPrefix) {
        Pattern pattern = Pattern.compile("^\\d+\\.\\d+\\.\\d+$");
        ValidateUtil.assertArg(pattern.matcher(buildPrefix).matches(), "Invalid buildId: " + buildPrefix);
        String url = "https://googlechromelabs.github.io/chrome-for-testing/latest-patch-versions-per-build.json";
        try {
            String json = this.sendRequest(url, "GET");
            JsonNode data = Constant.OBJECTMAPPER.readTree(json);
            JsonNode build = data.get("builds").get(buildPrefix);
            if (build == null) {
                throw new JvppeteerException("No Such buildId: " + buildPrefix);
            }
            return build.get("version").asText();
        }
        catch (Exception e) {
            LOGGER.error("Fail to get release by build {}", (Object)buildPrefix, (Object)e);
            return null;
        }
    }

    private String getLastKnownGoodReleaseForMilestone(String milestone) {
        Pattern pattern = Pattern.compile("^\\d+$");
        ValidateUtil.assertArg(pattern.matcher(milestone).matches(), "Invalid milestone: " + milestone);
        String url = "https://googlechromelabs.github.io/chrome-for-testing/latest-versions-per-milestone.json";
        try {
            String json = this.sendRequest(url, "GET");
            JsonNode data = Constant.OBJECTMAPPER.readTree(json);
            JsonNode milestoneData = data.get("milestones").get(milestone);
            if (milestoneData == null) {
                throw new JvppeteerException("No Such milestone: " + milestone);
            }
            return milestoneData.get("version").asText();
        }
        catch (Exception e) {
            LOGGER.error("Fail to get release by milestone {}", (Object)milestone, (Object)e);
            return null;
        }
    }

    private static String detectBrowserPlatform() {
        if (Helper.isMac()) {
            return Helper.is64() ? MAC_ARM64 : MAC_X64;
        }
        if (Helper.isLinux()) {
            return LINUX;
        }
        if (Helper.isWindows()) {
            return Helper.is64() ? WIN64 : WIN32;
        }
        throw new JvppeteerException("Unsupported platform: " + Helper.platform());
    }

    public RevisionInfo downloadBrowser() throws InterruptedException, IOException {
        ValidateUtil.assertArg(StringUtil.isNotBlank(this.version), "Browser version must be specified");
        RevisionInfo revisionInfo = this.revisionInfo(this.version);
        if (!revisionInfo.getLocal()) {
            return this.download(this.version);
        }
        return revisionInfo;
    }

    public boolean canDownload(String url) {
        try {
            this.sendRequest(url, "HEAD");
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Fail to check if browser is downloadable", (Throwable)e);
            return false;
        }
    }

    private String sendRequest(String url, String method) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL urlSend = new URL(url);
            conn = (HttpURLConnection)urlSend.openConnection();
            conn.setRequestMethod(method);
            conn.connect();
            if (conn.getResponseCode() == 200) {
                String string = StreamUtil.toString(conn.getInputStream());
                return string;
            }
            throw new IOException("Failed to fetch data: HTTP error code " + conn.getResponseCode());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private RevisionInfo download(String revision) throws IOException, InterruptedException {
        String url = this.getDownloadURL(this.product, this.platform, this.downloadHost, revision);
        boolean canDownload = this.canDownload(url);
        if (!canDownload) {
            throw new JvppeteerException("The URL: " + url + " cannot be downloaded");
        }
        String folderPath = this.relativeVersionPath(revision);
        if (!this.exists(this.downloadsFolder)) {
            this.mkdir(this.downloadsFolder);
        }
        if (!this.exists(folderPath)) {
            this.mkdir(folderPath);
        }
        this.shell(url, folderPath, this.archive(this.product, this.platform, revision), this.executableName());
        RevisionInfo revisionInfo = this.revisionInfo(revision);
        if (revisionInfo != null) {
            File executableFile = new File(revisionInfo.getExecutablePath());
            executableFile.setExecutable(true, false);
        }
        return revisionInfo;
    }

    public List<String> localRevisions() throws IOException {
        if (!this.exists(this.downloadsFolder)) {
            return new ArrayList<String>();
        }
        try (Stream<Path> list = Files.list(Paths.get(this.downloadsFolder, new String[0]));){
            List<String> list2 = list.map(revisionsPath -> this.parseRevisionsPath(this.product, (Path)revisionsPath)).filter(entry -> entry != null && this.platform.equals(entry.getPlatform())).map(RevisionEntry::getRevision).collect(Collectors.toList());
            return list2;
        }
    }

    public void remove(String revision) throws IOException {
        String folderPath = this.relativeVersionPath(revision);
        ValidateUtil.assertArg(this.exists(folderPath), "Failed to remove: revision " + revision + " is not downloaded");
        Files.delete(Paths.get(folderPath, new String[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RevisionEntry parseRevisionsPath(Product product, Path revisionsPath) {
        Pattern pattern;
        Matcher matcher;
        Path fileName = revisionsPath.getFileName();
        String[] split = fileName.toString().split("-");
        if (split.length != 2) {
            return null;
        }
        if (downloadURLs.get((Object)product).get(split[0]) == null) {
            return null;
        }
        if ((product.equals((Object)Product.CHROME) || product.equals((Object)Product.CHROMEHEADLESSSHELL) || product.equals((Object)Product.CHROMEDRIVER)) && !(matcher = (pattern = Pattern.compile("^\\d+\\.\\d+\\.\\d+(.\\d+)?$")).matcher(split[1])).matches()) {
            return null;
        }
        if (product.equals((Object)Product.CHROMIUM) && !(matcher = (pattern = Pattern.compile("^\\d+$")).matcher(split[1])).matches()) {
            return null;
        }
        try (Stream<Path> list = Files.list(revisionsPath);){
            List products = list.filter(path -> path.getFileName().toString().contains(this.archive(product, split[0], split[1]))).collect(Collectors.toList());
            if (products.isEmpty()) {
                RevisionEntry revisionEntry = null;
                return revisionEntry;
            }
        }
        catch (IOException e) {
            return null;
        }
        RevisionEntry entry = new RevisionEntry();
        entry.setPlatform(split[0]);
        entry.setProduct(product);
        entry.setRevision(split[1]);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shell(String url, String folderPath, String archiveName, String executableName) throws IOException, InterruptedException {
        Path shellPath = null;
        BufferedReader stderrReader = null;
        BufferedReader stdoutReader = null;
        try {
            Process process;
            if (Helper.isLinux()) {
                shellPath = this.copyShellFile("install-chrome-for-testing-linux.sh");
                process = new ProcessBuilder("/bin/sh", "-c", shellPath.toAbsolutePath() + " " + folderPath + " " + url + " " + archiveName + " " + executableName).redirectErrorStream(true).start();
            } else if (Helper.isWindows()) {
                shellPath = this.copyShellFile("install-chrome-for-testing-win.ps1");
                process = new ProcessBuilder("powershell.exe", "-ExecutionPolicy", "Bypass", "-File", shellPath.toAbsolutePath().toString(), "-url", url, "-savePath", folderPath, "-archive", archiveName, "-executableName", executableName).redirectErrorStream(true).start();
            } else if (Helper.isMac()) {
                shellPath = this.copyShellFile("install-chrome-for-testing-mac.sh");
                process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shellPath.toAbsolutePath().toString()});
            } else {
                throw new JvppeteerException("Unsupported platform: " + Helper.platform());
            }
            if (process != null) {
                String stdoutLine;
                stdoutReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
                stderrReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
                while ((stdoutLine = stdoutReader.readLine()) != null) {
                    LOGGER.info(stdoutLine);
                }
                boolean exitCode = process.waitFor(10L, TimeUnit.MINUTES);
                if (!exitCode) {
                    process.destroy();
                    throw new JvppeteerException("install chrome for testing failed");
                }
            }
        }
        finally {
            if (stdoutReader != null) {
                stdoutReader.close();
            }
            if (stderrReader != null) {
                stderrReader.close();
            }
            if (shellPath != null) {
                shellPath.toFile().delete();
                shellPath.getParent().toFile().delete();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executableName() {
        if (Product.CHROME.equals((Object)this.product)) {
            if (MAC_ARM64.equals(this.platform)) return "Google Chrome for Testing";
            if (MAC_X64.equals(this.platform)) {
                return "Google Chrome for Testing";
            }
            if (LINUX.equals(this.platform)) {
                return "chrome";
            }
            if (WIN32.equals(this.platform)) return "chrome.exe";
            if (!WIN64.equals(this.platform)) throw new IllegalArgumentException("Unsupported platform: " + this.platform);
            return "chrome.exe";
        }
        if (Product.CHROMIUM.equals((Object)this.product)) {
            if (MAC_ARM64.equals(this.platform)) return "Chromium";
            if (MAC_X64.equals(this.platform)) {
                return "Chromium";
            }
            if (LINUX.equals(this.platform)) {
                return "chrome";
            }
            if (WIN32.equals(this.platform)) return "chrome.exe";
            if (!WIN64.equals(this.platform)) throw new IllegalArgumentException("Unsupported platform: " + this.platform);
            return "chrome.exe";
        }
        if (Product.CHROMEDRIVER.equals((Object)this.product)) {
            if (MAC_ARM64.equals(this.platform)) return "chromedriver";
            if (MAC_X64.equals(this.platform)) {
                return "chromedriver";
            }
            if (LINUX.equals(this.platform)) {
                return "chromedriver";
            }
            if (WIN32.equals(this.platform)) return "chromedriver.exe";
            if (!WIN64.equals(this.platform)) throw new IllegalArgumentException("Unsupported platform: " + this.platform);
            return "chromedriver.exe";
        }
        if (!Product.CHROMEHEADLESSSHELL.equals((Object)this.product)) throw new IllegalArgumentException("Unsupported product: " + (Object)((Object)this.product));
        if (MAC_ARM64.equals(this.platform)) return "chrome-headless-shell";
        if (MAC_X64.equals(this.platform)) {
            return "chrome-headless-shell";
        }
        if (LINUX.equals(this.platform)) {
            return "chrome-headless-shell";
        }
        if (WIN32.equals(this.platform)) return "chrome-headless-shell.exe";
        if (!WIN64.equals(this.platform)) throw new IllegalArgumentException("Unsupported platform: " + this.platform);
        return "chrome-headless-shell.exe";
    }

    private Path copyShellFile(String path) throws IOException {
        Path tempDirectory = Paths.get(FileUtil.createProfileDir("jvppeteer_browser_install_shells-"), new String[0]);
        Path shellPath = tempDirectory.resolve(path);
        if (Helper.isMac() || Helper.isLinux()) {
            Files.createFile(shellPath, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx")));
        } else if (Helper.isWindows()) {
            Files.createFile(shellPath, new FileAttribute[0]);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(shellPath.toFile()));
             BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream("/scripts/" + path))));){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
        }
        return shellPath;
    }

    private void mkdir(String folder) throws IOException {
        File file = new File(folder);
        if (!file.exists()) {
            Files.createDirectory(file.toPath(), new FileAttribute[0]);
        }
    }

    public String relativeVersionPath(String revision) {
        return Helper.join(this.downloadsFolder, this.platform + "-" + revision);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RevisionInfo revisionInfo(String revision) {
        String executablePath;
        String versionPath = this.relativeVersionPath(revision);
        if (Product.CHROME.equals((Object)this.product)) {
            if (MAC_ARM64.equals(this.platform) || MAC_X64.equals(this.platform)) {
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "Google Chrome for Testing.app", "Contents", "MacOS", "Google Chrome for Testing");
            } else if (LINUX.equals(this.platform)) {
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "chrome");
            } else {
                if (!WIN32.equals(this.platform) && !WIN64.equals(this.platform)) throw new IllegalArgumentException("Unsupported platform: " + this.platform);
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "chrome.exe");
            }
        } else if (Product.CHROMIUM.equals((Object)this.product)) {
            if (MAC_ARM64.equals(this.platform) || MAC_X64.equals(this.platform)) {
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "Chromium.app", "Contents", "MacOS", "Chromium");
            } else if (LINUX.equals(this.platform)) {
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "chrome");
            } else {
                if (!WIN32.equals(this.platform) && !WIN64.equals(this.platform)) throw new IllegalArgumentException("Unsupported platform: " + this.platform);
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "chrome.exe");
            }
        } else if (Product.CHROMEDRIVER.equals((Object)this.product)) {
            if (MAC_ARM64.equals(this.platform) || MAC_X64.equals(this.platform)) {
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "chromedriver");
            } else if (LINUX.equals(this.platform)) {
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "chromedriver");
            } else {
                if (!WIN32.equals(this.platform) && !WIN64.equals(this.platform)) throw new IllegalArgumentException("Unsupported platform: " + this.platform);
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "chromedriver.exe");
            }
        } else {
            if (!Product.CHROMEHEADLESSSHELL.equals((Object)this.product)) throw new IllegalArgumentException("Unsupported product: " + (Object)((Object)this.product));
            if (MAC_ARM64.equals(this.platform) || MAC_X64.equals(this.platform)) {
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "chrome-headless-shell");
            } else if (LINUX.equals(this.platform)) {
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "chrome-headless-shell");
            } else {
                if (!WIN32.equals(this.platform) && !WIN64.equals(this.platform)) throw new IllegalArgumentException("Unsupported platform: " + this.platform);
                executablePath = Helper.join(versionPath, this.archive(this.product, this.platform, revision), "chrome-headless-shell.exe");
            }
        }
        String url = this.getDownloadURL(this.product, this.platform, this.downloadHost, revision);
        boolean local = this.exists(executablePath);
        LOGGER.info("revision:{}, executablePath:{}, folderPath:{}, local:{}, url:{}, product:{}", new Object[]{revision, executablePath, versionPath, local, url, this.product});
        return new RevisionInfo(revision, executablePath, versionPath, local, url, this.product);
    }

    public boolean exists(String filePath) {
        return Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
    }

    public String archive(Product product, String platform, String version) {
        boolean match;
        boolean bl = match = LINUX.equals(platform) || MAC_X64.equals(platform) || MAC_ARM64.equals(platform) || WIN32.equals(platform) || WIN64.equals(platform);
        if (Product.CHROME.equals((Object)product)) {
            if (match) {
                return "chrome-" + platform;
            }
            throw new JvppeteerException("Unsupported platform: " + platform);
        }
        if (Product.CHROMIUM.equals((Object)product)) {
            if (LINUX.equals(platform)) {
                return "chrome-linux";
            }
            if (MAC_ARM64.equals(platform) || MAC_X64.equals(platform)) {
                return "chrome-mac";
            }
            if (WIN32.equals(platform) || WIN64.equals(platform)) {
                if (Integer.parseInt(version, 10) > 591479) {
                    return "chrome-win";
                }
                return "chrome-win32";
            }
            throw new JvppeteerException("Unsupported platform: " + platform);
        }
        if (Product.CHROMEDRIVER.equals((Object)product)) {
            if (match) {
                return "chromedriver-" + platform;
            }
            throw new JvppeteerException("Unsupported platform: " + platform);
        }
        if (Product.CHROMEHEADLESSSHELL.equals((Object)product)) {
            if (match) {
                return "chrome-headless-shell-" + platform;
            }
            throw new JvppeteerException("Unsupported platform: " + platform);
        }
        return null;
    }

    private String folder() {
        String[] strings = downloadURLs.get((Object)this.product).get(this.platform).split("/");
        if (Product.CHROMIUM.equals((Object)this.product)) {
            return strings[2];
        }
        return strings[3];
    }

    public String getDownloadURL(Product product, String platform, String host, String revision) {
        return String.format(downloadURLs.get((Object)product).get(platform), host, revision, this.archive(product, platform, revision));
    }

    public String host() {
        return this.downloadHost;
    }

    public String platform() {
        return this.platform;
    }

    public String getDownloadsFolder() {
        return this.downloadsFolder;
    }

    public void setDownloadsFolder(String downloadsFolder) {
        this.downloadsFolder = downloadsFolder;
    }

    public Product product() {
        return this.product;
    }

    static {
        HashMap<String, String> chrome = new HashMap<String, String>();
        chrome.put("host", "http://storage.googleapis.com");
        chrome.put(LINUX, "%s/chrome-for-testing-public/%s/linux64/%s.zip");
        chrome.put(MAC_ARM64, "%s/chrome-for-testing-public/%s/mac-arm64/%s.zip");
        chrome.put(MAC_X64, "%s/chrome-for-testing-public/%s/mac-x64/%s.zip");
        chrome.put(WIN32, "%s/chrome-for-testing-public/%s/win32/%s.zip");
        chrome.put(WIN64, "%s/chrome-for-testing-public/%s/win64/%s.zip");
        downloadURLs.put(Product.CHROME, chrome);
        HashMap<String, String> chromium = new HashMap<String, String>();
        chromium.put("host", "https://storage.googleapis.com");
        chromium.put(LINUX, "%s/chromium-browser-snapshots/Linux_x64/%s/%s.zip");
        chromium.put(MAC_ARM64, "%s/chromium-browser-snapshots/Mac_Arm/%s/%s.zip");
        chromium.put(MAC_X64, "%s/chromium-browser-snapshots/Mac/%s/%s.zip");
        chromium.put(WIN32, "%s/chromium-browser-snapshots/Win/%s/%s.zip");
        chromium.put(WIN64, "%s/chromium-browser-snapshots/Win_x64/%s/%s.zip");
        downloadURLs.put(Product.CHROMIUM, chromium);
        HashMap<String, String> chromedriver = new HashMap<String, String>();
        chromedriver.put("host", "https://storage.googleapis.com");
        chromedriver.put(LINUX, "%s/chrome-for-testing-public/%s/linux64/%s.zip");
        chromedriver.put(MAC_ARM64, "%s/chrome-for-testing-public/%s/mac-arm64/%s.zip");
        chromedriver.put(MAC_X64, "%s/chrome-for-testing-public/%s/mac-x64/%s.zip");
        chromedriver.put(WIN32, "%s/chrome-for-testing-public/%s/win32/%s.zip");
        chromedriver.put(WIN64, "%s/chrome-for-testing-public/%s/win64/%s.zip");
        downloadURLs.put(Product.CHROMEDRIVER, chromedriver);
        HashMap<String, String> chrome_headless_shell = new HashMap<String, String>();
        chrome_headless_shell.put("host", "https://storage.googleapis.com");
        chrome_headless_shell.put(LINUX, "%s/chrome-for-testing-public/%s/linux64/%s.zip");
        chrome_headless_shell.put(MAC_ARM64, "%s/chrome-for-testing-public/%s/mac-arm64/%s.zip");
        chrome_headless_shell.put(MAC_X64, "%s/chrome-for-testing-public/%s/mac-x64/%s.zip");
        chrome_headless_shell.put(WIN32, "%s/chrome-for-testing-public/%s/win32/%s.zip");
        chrome_headless_shell.put(WIN64, "%s/chrome-for-testing-public/%s/win64/%s.zip");
        downloadURLs.put(Product.CHROMEHEADLESSSHELL, chrome_headless_shell);
    }

    public static class RevisionEntry {
        private Product product;
        private String platform;
        private String revision;

        public Product getProduct() {
            return this.product;
        }

        public void setProduct(Product product) {
            this.product = product;
        }

        public String getPlatform() {
            return this.platform;
        }

        public void setPlatform(String platform) {
            this.platform = StringUtil.isNotEmpty(platform) ? platform : BrowserFetcher.detectBrowserPlatform();
        }

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }
    }
}

