/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.common.WebPermission;
import com.ruiyun.jvppeteer.core.Browser;
import com.ruiyun.jvppeteer.core.Page;
import com.ruiyun.jvppeteer.core.Target;
import com.ruiyun.jvppeteer.entities.TargetType;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BrowserContext
extends EventEmitter<BrowserContextEvent> {
    private Connection connection;
    private Browser browser;
    private String id;

    public BrowserContext() {
    }

    public BrowserContext(Connection connection, Browser browser, String contextId) {
        this.connection = connection;
        this.browser = browser;
        this.id = contextId;
    }

    public List<Target> targets() {
        return this.browser.targets().stream().filter(target -> target.browserContext() == this).collect(Collectors.toList());
    }

    public List<Page> pages() {
        return this.targets().stream().filter(target -> TargetType.PAGE.equals((Object)target.type()) || !TargetType.OTHER.equals((Object)target.type()) || this.browser.getIsPageTargetCallback() == null || this.browser.getIsPageTargetCallback().apply((Target)target) != false).map(Target::page).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void overridePermissions(String origin, WebPermission ... webPermissions) {
        ArrayList<String> protocolPermissions = new ArrayList<String>();
        if (webPermissions != null) {
            for (WebPermission permission : webPermissions) {
                String protocolPermission = Constant.WEB_PERMISSION_TO_PROTOCOL_PERMISSION.get((Object)permission);
                ValidateUtil.assertArg(protocolPermission != null, "Unknown permission: " + (Object)((Object)permission));
                protocolPermissions.add(protocolPermission);
            }
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("origin", origin);
        if (StringUtil.isNotEmpty(this.id)) {
            params.put("browserContextId", this.id);
        }
        params.put("permissions", protocolPermissions);
        this.connection.send("Browser.grantPermissions", params);
    }

    public void clearPermissionOverrides() {
        Map<String, Object> params = ParamsFactory.create();
        params.put("browserContextId", this.id);
        this.connection.send("Browser.resetPermissions", params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page newPage() {
        BrowserContext browserContext = this;
        synchronized (browserContext) {
            return this.browser.createPageInContext(this.id);
        }
    }

    public void close() {
        ValidateUtil.assertArg(StringUtil.isNotEmpty(this.id), "Default BrowserContext cannot be closed!");
        this.browser.disposeContext(this.id);
    }

    public boolean closed() {
        return !this.browser.browserContexts().contains(this);
    }

    public Target waitForTarget(Predicate<Target> predicate) {
        return this.waitForTarget(predicate, 30000);
    }

    public Target waitForTarget(Predicate<Target> predicate, int timeout) {
        Supplier<Target> conditionChecker = () -> Helper.filter(this.targets(), predicate);
        return Helper.waitForCondition(conditionChecker, timeout, "waiting for target failed: timeout " + timeout + "ms exceeded");
    }

    public Browser browser() {
        return this.browser;
    }

    public String getId() {
        return this.id;
    }

    public static enum BrowserContextEvent {
        TargetChanged("targetchanged"),
        TargetCreated("targetcreated"),
        TargetDestroyed("targetdestroyed");

        private final String eventName;

        private BrowserContextEvent(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }
    }
}

