/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.core.AXNode;
import com.ruiyun.jvppeteer.core.Realm;
import com.ruiyun.jvppeteer.entities.SerializedAXNode;
import com.ruiyun.jvppeteer.entities.SnapshotOptions;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Accessibility {
    private final Realm realm;

    public Accessibility(Realm realm) {
        this.realm = realm;
    }

    public SerializedAXNode snapshot() throws JsonProcessingException, IllegalAccessException, IntrospectionException, InvocationTargetException {
        return this.snapshot(new SnapshotOptions());
    }

    public SerializedAXNode snapshot(SnapshotOptions options) throws JsonProcessingException, IllegalAccessException, IntrospectionException, InvocationTargetException {
        String finalBackendNodeId;
        AXNode defaultRoot;
        JsonNode nodes = this.realm.environment().client().send("Accessibility.getFullAXTree").get("nodes");
        String backendNodeId = null;
        if (options.getRoot() != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("objectId", options.getRoot().id());
            JsonNode node = this.realm.environment().client().send("DOM.describeNode", params);
            backendNodeId = node.get("backendNodeId").asText();
        }
        Iterator elements = nodes.elements();
        ArrayList<com.ruiyun.jvppeteer.entities.AXNode> payloads = new ArrayList<com.ruiyun.jvppeteer.entities.AXNode>();
        while (elements.hasNext()) {
            JsonNode next = (JsonNode)elements.next();
            payloads.add((com.ruiyun.jvppeteer.entities.AXNode)Constant.OBJECTMAPPER.treeToValue((TreeNode)next, com.ruiyun.jvppeteer.entities.AXNode.class));
        }
        AXNode needle = defaultRoot = AXNode.createTree(this.realm, payloads);
        if (StringUtil.isNotEmpty(backendNodeId) && (needle = defaultRoot.find(arg_0 -> Accessibility.lambda$snapshot$0(finalBackendNodeId = backendNodeId, arg_0))) == null) {
            return null;
        }
        if (!options.getInterestingOnly()) {
            return this.serializeTree(needle, null).get(0);
        }
        HashSet<AXNode> interestingNodes = new HashSet<AXNode>();
        this.collectInterestingNodes(interestingNodes, defaultRoot, false);
        if (!interestingNodes.contains(needle)) {
            return null;
        }
        return this.serializeTree(needle, interestingNodes).get(0);
    }

    private void collectInterestingNodes(Set<AXNode> collection, AXNode node, boolean insideControl) {
        if (node.isInteresting(insideControl)) {
            collection.add(node);
        }
        if (node.isLeafNode()) {
            return;
        }
        insideControl = insideControl || node.isControl();
        for (AXNode child : node.getChildren()) {
            this.collectInterestingNodes(collection, child, insideControl);
        }
    }

    private List<SerializedAXNode> serializeTree(AXNode node, Set<AXNode> interestingNodes) throws IllegalAccessException, IntrospectionException, InvocationTargetException, JsonProcessingException {
        ArrayList<SerializedAXNode> children = new ArrayList<SerializedAXNode>();
        if (ValidateUtil.isNotEmpty(node.getChildren())) {
            for (AXNode child : node.getChildren()) {
                children.addAll(this.serializeTree(child, interestingNodes));
            }
        }
        if (ValidateUtil.isNotEmpty(interestingNodes) && !interestingNodes.contains(node)) {
            return children;
        }
        SerializedAXNode serializedNode = node.serialize();
        if (ValidateUtil.isNotEmpty(children)) {
            serializedNode.setChildren(children);
        }
        ArrayList<SerializedAXNode> result = new ArrayList<SerializedAXNode>();
        result.add(serializedNode);
        return result;
    }

    private static /* synthetic */ boolean lambda$snapshot$0(String finalBackendNodeId, AXNode node) {
        return finalBackendNodeId.equals(node.getPayload().getBackendDOMNodeId() + "");
    }
}

