/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.common;

import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.core.Page;
import com.ruiyun.jvppeteer.entities.ScreenCastFormat;
import com.ruiyun.jvppeteer.entities.ScreenRecorderOptions;
import com.ruiyun.jvppeteer.entities.Viewport;
import com.ruiyun.jvppeteer.events.ScreencastFrameEvent;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.util.Base64Util;
import com.ruiyun.jvppeteer.util.FileUtil;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StreamUtil;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenRecorder.class);
    private static final int DEFAULT_FPS = 30;
    private static final int CRF_VALUE = 30;
    private static final String SCREENCAST_TEMP_CAAHE_DIR = "jvppeteer-screencast-temp-cache-";
    private final Page page;
    private final double width;
    private final double height;
    private final ScreenRecorderOptions options;
    private final Viewport defaultViewport;
    private final Viewport tempViewport;
    private String tempCacheDir;
    private volatile BigDecimal previousTimestamp;
    private volatile byte[] previousBuffer;
    AtomicLong imgIndex = new AtomicLong(0L);
    private volatile boolean stoped = false;

    public ScreenRecorder(Page page, double width, double height, ScreenRecorderOptions options, Viewport defaultViewport, Viewport tempViewport) {
        this.page = page;
        this.options = options;
        this.width = width;
        this.height = height;
        this.defaultViewport = defaultViewport;
        this.tempViewport = tempViewport;
        this.createTempCacheDir();
        Consumer<Object> closeListener = o -> this.stop();
        this.stoped = false;
        page.mainFrame().client().once(CDPSession.CDPSessionEvent.disconnected, closeListener);
        page.mainFrame().client().on(CDPSession.CDPSessionEvent.Page_screencastFrame, this::writeFrame);
    }

    private void createTempCacheDir() {
        this.tempCacheDir = FileUtil.createProfileDir(SCREENCAST_TEMP_CAAHE_DIR);
    }

    private void writeFrame(ScreencastFrameEvent event) {
        Map<String, Object> params = ParamsFactory.create();
        params.put("sessionId", event.getSessionId());
        this.page.mainFrame().client().send("Page.screencastFrameAck", params);
        BigDecimal timestamp = event.getMetadata().getTimestamp();
        byte[] buffer = Base64Util.decode(event.getData().getBytes());
        if (timestamp != null) {
            if (Objects.isNull(this.previousTimestamp) && Objects.isNull(this.previousBuffer)) {
                this.previousTimestamp = timestamp;
                this.previousBuffer = buffer;
                return;
            }
            long count = new BigDecimal(30).multiply(timestamp.subtract(this.previousTimestamp)).max(BigDecimal.ZERO).setScale(0, RoundingMode.HALF_UP).longValue();
            this.toFile(count);
            this.previousTimestamp = this.stoped ? this.currentTimestamp() : timestamp;
            this.previousBuffer = buffer;
        }
    }

    private void toFile(long count) {
        if (count > 0L) {
            int i = 0;
            while ((long)i < count) {
                try {
                    Path imgPath = Paths.get(Helper.join(this.tempCacheDir, this.imgIndex.incrementAndGet() + ".png"), new String[0]);
                    Files.write(imgPath, this.previousBuffer, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                }
                catch (IOException e) {
                    LOGGER.error("jvppeteer error", (Throwable)e);
                }
                ++i;
            }
        }
    }

    private List<String> getFormatArgs(ScreenCastFormat format) {
        ArrayList<String> args = new ArrayList<String>();
        switch (format) {
            case WEBM: {
                args.add("-c:v");
                args.add("vp9");
                args.add("-f");
                args.add("webm");
                args.add("-crf");
                args.add(String.valueOf(30));
                args.add("-deadline");
                args.add("realtime");
                args.add("-cpu-used");
                args.add("8");
                return args;
            }
            case GIF: {
                args.add("-f");
                args.add("gif");
                return args;
            }
        }
        return args;
    }

    public void stop() {
        try {
            this.previousTimestamp = this.currentTimestamp();
            this.page.stopScreencast();
            this.stoped = true;
            long count = new BigDecimal(30).multiply(this.currentTimestamp().subtract(this.previousTimestamp)).divide(new BigDecimal(1000), 6, RoundingMode.HALF_UP).setScale(0, RoundingMode.HALF_UP).max(new BigDecimal(1)).longValue();
            this.toFile(count);
            this.convert();
        }
        catch (Exception e) {
            LOGGER.error("jvppeteer error: ", (Throwable)e);
        }
        finally {
            if (Objects.nonNull(this.defaultViewport) && Objects.nonNull(this.tempViewport)) {
                this.page.setViewport(this.defaultViewport);
            }
            try {
                FileUtil.removeFolder(this.tempCacheDir);
            }
            catch (IOException iOException) {}
        }
    }

    private void convert() throws IOException, InterruptedException {
        ArrayList<String> commands = new ArrayList<String>();
        if (StringUtil.isEmpty(this.options.getFfmpegPath())) {
            this.options.setFfmpegPath("ffmpeg");
        }
        commands.add(this.options.getFfmpegPath());
        commands.add("-loglevel");
        commands.add("error");
        commands.add("-avioflags");
        commands.add("direct");
        commands.add("-y");
        commands.add("-an");
        commands.add("-threads");
        commands.add("1");
        commands.add("-framerate");
        commands.add(Integer.toString(30));
        commands.add("-i");
        commands.add(Helper.join(this.tempCacheDir, "%d.png"));
        commands.addAll(this.getFormatArgs(Objects.isNull((Object)this.options.getFormat()) ? ScreenCastFormat.WEBM : this.options.getFormat()));
        commands.add("-b:v");
        commands.add("0");
        commands.add("-vf");
        StringBuilder builder = new StringBuilder();
        if (this.options.getSpeed() != null) {
            builder.append("setpts=").append(1.0 / this.options.getSpeed()).append("*PTS");
        }
        if (this.options.getCrop() != null) {
            builder.append(",crop='min(").append(this.width).append(",iw):min(").append(this.height).append(",ih):0:0',pad=").append(this.width).append(":").append(this.height).append(":0:0");
            builder.append(",crop=").append(this.options.getCrop().getWidth()).append(":").append(this.options.getCrop().getHeight()).append(":").append(this.options.getCrop().getX()).append(":").append(this.options.getCrop().getY());
        }
        if (this.options.getScale() != null) {
            builder.append(",scale=iw*").append(this.options.getScale()).append(":").append("-1");
        }
        if (ScreenCastFormat.GIF.equals((Object)this.options.getFormat())) {
            builder.append(",fps=5,split[s0][s1];[s0]palettegen=stats_mode=diff[pal];[s1][pal]paletteuse");
        }
        commands.add(builder.toString());
        commands.add(this.options.getPath());
        ProcessBuilder pb = new ProcessBuilder(commands).redirectErrorStream(true);
        Process process = pb.start();
        String input = StreamUtil.toString(process.getInputStream());
        if (StringUtil.isNotEmpty(input)) {
            LOGGER.info(input);
        }
        process.waitFor();
    }

    private BigDecimal currentTimestamp() {
        LocalDateTime now = LocalDateTime.now();
        Instant instant = now.atZone(ZoneOffset.UTC).toInstant();
        long timestampMillis = instant.toEpochMilli();
        BigDecimal timestampDecimal = new BigDecimal(timestampMillis);
        int nanoseconds = instant.getNano();
        BigDecimal nanosecondsAsMilli = new BigDecimal(nanoseconds).divide(new BigDecimal(1000000), 6, RoundingMode.HALF_UP);
        return timestampDecimal.add(nanosecondsAsMilli);
    }
}

