/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5.extension.page;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Consumer;
import net.serenitybdd.core.environment.WebDriverConfiguredEnvironment;
import net.serenitybdd.junit5.extension.page.PatchedManagedWebDriverAnnotatedField;
import net.serenitybdd.junit5.extension.page.TestConfiguration;
import net.serenitybdd.junit5.extension.page.TestMethodAnnotations;
import net.thucydides.core.annotations.ClearCookiesPolicy;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SerenityPageExtension
implements BeforeEachCallback {
    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        TestConfiguration testConfiguration = TestConfiguration.forClass(extensionContext.getRequiredTestClass()).withSystemConfiguration((Configuration)WebDriverConfiguredEnvironment.getDriverConfiguration());
        if (testConfiguration.isAWebTest()) {
            this.applyTestClassOrTestMethodSpecificWebDriverConfiguration(extensionContext);
            ThucydidesWebDriverSupport.initializeFieldsIn((Object)extensionContext.getRequiredTestInstance());
            this.injectPageObjectIntoTest(extensionContext.getRequiredTestInstance());
            this.prepareBrowserForTest(extensionContext);
        }
    }

    private void applyTestClassOrTestMethodSpecificWebDriverConfiguration(ExtensionContext extensionContext) {
        ThucydidesWebDriverSupport.clearDefaultDriver();
        Optional<ExplicitWebDriverConfiguration> explicitWebDriverConfiguration = this.explicitWebDriverConfiguration(extensionContext);
        explicitWebDriverConfiguration.ifPresent(it -> {
            String value = it.getTestSpecificDriver();
            Consumer<String> consumer = ThucydidesWebDriverSupport::useDefaultDriver;
            this.notEmpty(value).ifPresent(consumer);
            this.notEmpty(it.getDriverOptions()).ifPresent(ThucydidesWebDriverSupport::useDriverOptions);
            this.workaroundForOtherwiseIgnoredWebDriverOptions();
        });
    }

    private Optional<String> notEmpty(String value) {
        return Optional.ofNullable(value).filter(StringUtils::isNotEmpty);
    }

    private void workaroundForOtherwiseIgnoredWebDriverOptions() {
        if (!ThucydidesWebDriverSupport.getDefaultDriverType().isPresent() && ThucydidesWebDriverSupport.getDefaultDriverOptions().isPresent()) {
            ThucydidesWebDriverSupport.useDefaultDriver((String)WebDriverConfiguredEnvironment.getDriverConfiguration().getDriverType().name());
        }
    }

    private Optional<ExplicitWebDriverConfiguration> explicitWebDriverConfiguration(ExtensionContext extensionContext) {
        Method testMethod = extensionContext.getRequiredTestMethod();
        Class requiredTestClass = extensionContext.getRequiredTestClass();
        if (this.hasExplicitWebDriverConfigurationOnTestMethod(testMethod)) {
            String testSpecificDriver = TestMethodAnnotations.forTest(testMethod).specifiedDriver();
            String driverOptions = TestMethodAnnotations.forTest(testMethod).driverOptions();
            return this.explicitWebDriverConfiguration(testSpecificDriver, driverOptions);
        }
        if (this.hasExplicitWebDriverConfigurationOnTestClass(requiredTestClass)) {
            ManagedWebDriverAnnotatedField firstAnnotatedField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField((Class)requiredTestClass);
            return this.explicitWebDriverConfiguration(firstAnnotatedField.getDriver(), firstAnnotatedField.getOptions());
        }
        return Optional.empty();
    }

    private void prepareBrowserForTest(ExtensionContext extensionContext) {
        PatchedManagedWebDriverAnnotatedField.findAnnotatedFields(extensionContext.getRequiredTestClass()).stream().filter(it -> ClearCookiesPolicy.BeforeEachTest.equals((Object)it.getClearCookiesPolicy())).map(it -> it.getValue(extensionContext.getRequiredTestInstance())).forEach(WebdriverProxyFactory::clearBrowserSession);
    }

    @NotNull
    private Optional<ExplicitWebDriverConfiguration> explicitWebDriverConfiguration(String testSpecificDriver, String driverOptions) {
        return Optional.of(new ExplicitWebDriverConfiguration(testSpecificDriver, driverOptions));
    }

    private boolean hasExplicitWebDriverConfigurationOnTestClass(Class<?> requiredTestClass) {
        return ManagedWebDriverAnnotatedField.hasManagedWebdriverField(requiredTestClass);
    }

    private boolean hasExplicitWebDriverConfigurationOnTestMethod(Method testMethod) {
        return TestMethodAnnotations.forTest(testMethod).isDriverSpecified();
    }

    private void injectPageObjectIntoTest(Object testClass) {
        new PageObjectDependencyInjector(ThucydidesWebDriverSupport.getPages()).injectDependenciesInto(testClass);
    }

    public static class ExplicitWebDriverConfiguration {
        private final String testSpecificDriver;
        private final String driverOptions;

        public ExplicitWebDriverConfiguration(String testSpecificDriver, String driverOptions) {
            this.testSpecificDriver = testSpecificDriver;
            this.driverOptions = driverOptions;
        }

        public String getTestSpecificDriver() {
            return this.testSpecificDriver;
        }

        public String getDriverOptions() {
            return this.driverOptions;
        }
    }
}

