/*
 * Decompiled with CFR 0.152.
 */
package org.MediaPlayer.PlayM4;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.util.Log;
import android.util.Range;

public class MediaCodecHwDecImpl {
    private String TAG = "PlayerSDK";
    private int nMaxWeight = 0;
    private int nMinWeight = 0;
    private int nMaxHeight = 0;
    private int nMinHeight = 0;

    public int Init(int type) {
        if (type < 0) {
            return 32771;
        }
        String mime = "";
        switch (type) {
            case 0: {
                mime = "video/avc";
                Log.i((String)this.TAG, (String)"Create H264 MediaCodec and MediaFormat");
                break;
            }
            case 1: {
                mime = "video/hevc";
                Log.i((String)this.TAG, (String)"Create H265 MediaCodec and MediaFormat");
                break;
            }
            case 2: {
                mime = "video/mp4v-es";
                Log.i((String)this.TAG, (String)"Create MPEG4 MediaCodec and MediaFormat");
                break;
            }
            case 3: {
                mime = "video/mjpeg";
                Log.i((String)this.TAG, (String)"Create MJPEG MediaCodec and MediaFormat");
                break;
            }
            default: {
                Log.i((String)this.TAG, (String)"other type is not support set mime null");
            }
        }
        if (mime.isEmpty()) {
            return 33025;
        }
        try {
            MediaCodecInfo.VideoCapabilities videoCapabilities;
            MediaCodecInfo decoderInfo = this.chooseCodec(mime);
            if (null == decoderInfo) {
                return 33027;
            }
            MediaCodecInfo.CodecCapabilities capabilities = decoderInfo.getCapabilitiesForType(mime);
            if (capabilities != null && (videoCapabilities = capabilities.getVideoCapabilities()) != null) {
                Range supportedHeights = videoCapabilities.getSupportedHeights();
                Range supportedWidths = videoCapabilities.getSupportedWidths();
                if (supportedHeights != null && supportedWidths != null) {
                    this.nMaxHeight = (Integer)supportedHeights.getUpper();
                    this.nMinHeight = (Integer)supportedHeights.getLower();
                    this.nMaxWeight = (Integer)supportedWidths.getUpper();
                    this.nMinWeight = (Integer)supportedWidths.getLower();
                }
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("MEDIACODEC_TRY_CATCH_ERR createDecoderByType mime: " + mime));
            e.printStackTrace();
            return 32772;
        }
        return 0;
    }

    private MediaCodecInfo chooseCodec(String mimeType) {
        int codecNum = MediaCodecList.getCodecCount();
        for (int i = 0; i < codecNum; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (codecInfo.isEncoder()) continue;
            String[] type = codecInfo.getSupportedTypes();
            for (int j = 0; j < type.length; ++j) {
                if (!type[j].equalsIgnoreCase(mimeType)) continue;
                return codecInfo;
            }
        }
        return null;
    }

    public int GetMaxHeight() {
        return this.nMaxHeight;
    }

    public int GetMinHeight() {
        return this.nMinHeight;
    }

    public int GetMaxWeight() {
        return this.nMaxWeight;
    }

    public int GetMinWeight() {
        return this.nMinWeight;
    }
}

