/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.sdk.configwifi.apLink;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.ezviz.sdk.configwifi.Config;
import com.ezviz.sdk.configwifi.EZConfigWifiErrorEnum;
import com.ezviz.sdk.configwifi.EZConfigWifiInfoEnum;
import com.ezviz.sdk.configwifi.ap.WiFiConnectResultListener;
import com.ezviz.sdk.configwifi.ap.WiFiConnectorAbstract;
import com.ezviz.sdk.configwifi.ap.WiFiConnectorManager;
import com.ezviz.sdk.configwifi.common.EZConfigWifiCallback;
import com.ezviz.utils.AppUtil;
import com.google.gson.Gson;
import com.videogo.ezlink.EzLinkManager;
import com.videogo.ezlink.bean.OtapMessageInfo;
import com.videogo.ezlink.bean.PairDeviceInfo;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

@SuppressLint(value={"MissingPermission"})
public class ApLinkConfigController {
    private static final String TAG = "APLinkWifiConfig";
    private Context mContext;
    private ExecutorService cachedThreadPool;
    private EZConfigWifiCallback mLinkConfigCallback;
    @SuppressLint(value={"StaticFieldLeak"})
    private static ApLinkConfigController mLinkWifiConfig;
    private String mSSID;
    private String mTargetWifiMacAddress;
    private int mTargetWifiNetId;
    private String mPassword;
    private String mDeviceSerial;
    private String mVerifyCode;
    private String mDeviceWifiSSID = null;
    private WifiManager mWifiManager;
    private boolean isAutoConnectDeviceHotSpot = false;
    private int mTimeOutSecond = Config.mTimeoutSecond;
    private volatile boolean isTimeOut;
    private WiFiConnectorAbstract mWiFiConnector;
    private CountDownTimer countDownTimer;
    private Runnable mTryToPaireDeviceAndConfigWifiTask = new Runnable(){

        @Override
        public void run() {
            if (!ApLinkConfigController.this.isTimeOut) {
                int rt;
                ApLinkConfigController.this.bindAppToTargetDeviceNetwork();
                String uuid = AppUtil.getInstance(ApLinkConfigController.this.mContext).getTerminalId();
                String devID = uuid.substring(0, 10);
                System.loadLibrary("c++_shared");
                EzLinkManager.getInstance();
                if (Config.LOGGING) {
                    EzLinkManager.getInstance().openEzlinkDebugLog();
                }
                int state = EzLinkManager.getInstance().startEzlink(ApLinkConfigController.this.mContext, "", devID, Build.MANUFACTURER);
                Log.v((String)ApLinkConfigController.TAG, (String)("startEzlink return state : " + state));
                if (state != 0 && state != 6800) {
                    Log.e((String)ApLinkConfigController.TAG, (String)"start ezlink failed");
                    this.connectFailedHandler();
                    return;
                }
                final Handler handler = new Handler(Looper.getMainLooper());
                final Runnable overTime = new Runnable(){

                    @Override
                    public void run() {
                        Log.e((String)ApLinkConfigController.TAG, (String)"ezlink search device overtime");
                        this.connectFailedHandler();
                    }
                };
                if (state == 0) {
                    EzLinkManager.getInstance().registerQueryPairDeviceCallBack(new EzLinkManager.PairDeviceListCallBack(){

                        public void onQueryPairDeviceChanged(List<PairDeviceInfo> list) {
                            Log.v((String)ApLinkConfigController.TAG, (String)("onQueryPairDeviceChanged:" + new Gson().toJson(list)));
                            if (list == null || list.size() == 0) {
                                this.connectFailedHandler();
                                return;
                            }
                            handler.removeCallbacks(overTime);
                            this.doPaireDevice(list);
                        }
                    });
                }
                if (0 == (rt = EzLinkManager.getInstance().queryDevices())) {
                    handler.postDelayed(overTime, 10000L);
                    Log.v((String)ApLinkConfigController.TAG, (String)"registerQueryPairDeviceCallBack succerss:0");
                } else {
                    Log.e((String)ApLinkConfigController.TAG, (String)("registerQueryPairDeviceCallBack failed:" + rt));
                    this.connectFailedHandler();
                }
            }
        }

        private void doPaireDevice(List<PairDeviceInfo> list) {
            PairDeviceInfo deviceInfo = null;
            for (PairDeviceInfo pairDeviceInfo : list) {
                if (!pairDeviceInfo.deviceSerial.contains(ApLinkConfigController.this.mDeviceSerial)) continue;
                deviceInfo = pairDeviceInfo;
                break;
            }
            if (deviceInfo == null) {
                this.connectFailedHandler();
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            final Runnable overTime = new Runnable(){

                @Override
                public void run() {
                    Log.e((String)ApLinkConfigController.TAG, (String)"ezlink doPairDevice overtime");
                    this.connectFailedHandler();
                }
            };
            int result = EzLinkManager.getInstance().doPairDevice(deviceInfo, ApLinkConfigController.this.mVerifyCode, new EzLinkManager.PairDeviceResultCallBack(){

                public void onPairDeviceResult(final int code, PairDeviceInfo pairDeviceInfo) {
                    Log.d((String)ApLinkConfigController.TAG, (String)("doPairDevice result: " + code));
                    handler.removeCallbacks(overTime);
                    this.sendWifiConfig(new EzLinkManager.OnMessageResultCallBack(){

                        public void onMessageResult(int i, OtapMessageInfo otapMessageInfo) {
                            Log.d((String)ApLinkConfigController.TAG, (String)"ezlink device receive wifi info, start connect to wifi");
                            if (code == 6808 || this.getStatusCode(otapMessageInfo) == 200) {
                                Log.w((String)ApLinkConfigController.TAG, (String)"config wifi success");
                                if (Build.VERSION.SDK_INT < 29) {
                                    boolean isSuccess = ApLinkConfigController.this.mWifiManager.enableNetwork(ApLinkConfigController.this.mTargetWifiNetId, true);
                                    Log.w((String)ApLinkConfigController.TAG, (String)("connect to target wifi : " + isSuccess));
                                }
                                if (ApLinkConfigController.this.countDownTimer != null) {
                                    ApLinkConfigController.this.countDownTimer.cancel();
                                    ApLinkConfigController.this.countDownTimer = null;
                                }
                                if (ApLinkConfigController.this.mLinkConfigCallback != null) {
                                    ApLinkConfigController.this.mLinkConfigCallback.reportInfo(EZConfigWifiInfoEnum.CONNECTING_SENT_CONFIGURATION_TO_DEVICE);
                                }
                                EzLinkManager.getInstance().unPairDevice(ApLinkConfigController.this.mDeviceSerial, new EzLinkManager.UnPairDeviceResultCallBack(){

                                    public void onUnPairDeviceResult(boolean b) {
                                        Log.d((String)ApLinkConfigController.TAG, (String)("ezlink unPairDevice:" + ApLinkConfigController.this.mDeviceSerial + ", result:" + b));
                                    }
                                });
                                ApLinkConfigController.this.stopAPLinkConfigWifiWithSsid();
                            } else {
                                this.connectFailedHandler();
                            }
                        }
                    });
                }
            });
            Log.v((String)ApLinkConfigController.TAG, (String)("doPairDevice return code : " + result));
            if (0 == result) {
                Log.v((String)ApLinkConfigController.TAG, (String)"doPairDevice succerss:0");
                handler.postDelayed(overTime, 10000L);
            } else {
                Log.e((String)ApLinkConfigController.TAG, (String)"doPairDevice failed");
                this.connectFailedHandler();
            }
        }

        private void sendWifiConfig(EzLinkManager.OnMessageResultCallBack callback) {
            String securityMode = ApLinkConfigController.this.mPassword.length() > 0 ? "WPA-personal" : "disable";
            String body = String.format("{\"data\":{\"Value\":[{\"SSID\":\"%s\",\"wirelessSecurity\":{\"securityMode\":\"%s\"},\"password\":\"%s\",\"macAddress\":\"%s\"}]}}", ApLinkConfigController.this.mSSID, securityMode, ApLinkConfigController.this.mPassword, !TextUtils.isEmpty((CharSequence)ApLinkConfigController.this.mTargetWifiMacAddress) ? ApLinkConfigController.this.mTargetWifiMacAddress : "undefined");
            OtapMessageInfo msg = new OtapMessageInfo();
            msg.deviceSerial = ApLinkConfigController.this.mDeviceSerial;
            msg.subDeviceSerial = "";
            msg.resourceId = "1";
            msg.resourceType = "Global";
            msg.domain = "WIFIMgr";
            msg.identifier = "WirelessConfigList";
            msg.body = body;
            Log.d((String)"sendMsgSetAttr", (String)("OtapMessageInfo: " + msg.toString()));
            EzLinkManager.getInstance().sendMsgSetAttr(msg, callback, 5000L);
        }

        private void connectFailedHandler() {
            Log.v((String)ApLinkConfigController.TAG, (String)"connectFailedHandler");
            ApLinkConfigController.this.recoveryAppToNormalNetwork();
            if (ApLinkConfigController.this.isAutoConnectDeviceHotSpot && !ApLinkConfigController.this.isConnectedToDeviceWifi() && ApLinkConfigController.this.mWiFiConnector != null && ApLinkConfigController.this.mWiFiConnector.isPaused()) {
                Log.v((String)ApLinkConfigController.TAG, (String)"not connected to device wifi, try to connect again!");
                ApLinkConfigController.this.mWiFiConnector.resume();
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!ApLinkConfigController.this.cachedThreadPool.isShutdown()) {
                ApLinkConfigController.this.cachedThreadPool.submit(ApLinkConfigController.this.mTryToPaireDeviceAndConfigWifiTask);
            }
        }

        private int getStatusCode(OtapMessageInfo otapMessageInfo) {
            if (otapMessageInfo != null) {
                try {
                    int status = new JSONObject(otapMessageInfo.body).optInt("status");
                    return status;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return -1;
        }
    };

    private ApLinkConfigController() {
        this.cachedThreadPool = Executors.newSingleThreadExecutor();
    }

    public static ApLinkConfigController getInstance() {
        if (mLinkWifiConfig == null) {
            mLinkWifiConfig = new ApLinkConfigController();
        }
        return mLinkWifiConfig;
    }

    public void setApLinkConfigCallback(EZConfigWifiCallback linkConfigCallback) {
        this.mLinkConfigCallback = linkConfigCallback;
    }

    private void bindAppToTargetDeviceNetwork() {
        try {
            ConnectivityManager mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            if (mConnectivityManager == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                Network[] nets;
                boolean isSuc = false;
                for (Network net : nets = mConnectivityManager.getAllNetworks()) {
                    NetworkInfo networkInfo = mConnectivityManager.getNetworkInfo(net);
                    if (networkInfo == null || networkInfo.getType() != 1) continue;
                    mConnectivityManager.bindProcessToNetwork(net);
                    isSuc = true;
                }
                Log.d((String)TAG, (String)("the result of binding app net traffic to wifi is: " + isSuc));
            } else {
                Log.d((String)TAG, (String)"do not need  binding app net traffic to wifi");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"NewApi"})
    private void recoveryAppToNormalNetwork() {
        try {
            ConnectivityManager mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            if (mConnectivityManager == null) {
                return;
            }
            mConnectivityManager.bindProcessToNetwork(null);
            Log.d((String)TAG, (String)"binding app net traffic to null (recovery normal)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isConnectedToDeviceWifi() {
        boolean ret = false;
        if (this.mWifiManager != null && this.mWifiManager.getConnectionInfo() != null && this.mWifiManager.getConnectionInfo().getSSID() != null) {
            String currentWifiSSID = this.mWifiManager.getConnectionInfo().getSSID();
            Log.v((String)TAG, (String)("deviceWifiSSID: " + this.mDeviceWifiSSID));
            Log.v((String)TAG, (String)("currentWifiSSID: " + currentWifiSSID));
            if (currentWifiSSID != null && this.mDeviceWifiSSID != null) {
                ret = currentWifiSSID.contains(this.mDeviceWifiSSID);
            }
        }
        Log.e((String)TAG, (String)("isConnectedToDeviceWifi: " + ret));
        return ret;
    }

    public void stopAPLinkConfigWifiWithSsid() {
        Log.i((String)TAG, (String)"stopAPLinkConfigWifiWithSsid");
        EzLinkManager.getInstance().stopEzlink();
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
            this.countDownTimer = null;
        }
        this.isTimeOut = true;
        if (this.isConnectedToDeviceWifi()) {
            this.recoveryAppToNormalNetwork();
        }
        this.cachedThreadPool.shutdown();
        if (this.mWiFiConnector != null) {
            this.mWiFiConnector.stop();
        }
    }

    public void startAPLinkConfigWifiWithSsid(Context context, String targetWifiName, String targetWifiPwd, String deviceSerial, String verifyCode) {
        this.startAPLinkConfigWifiWithSsid(context, targetWifiName, targetWifiPwd, deviceSerial, verifyCode, "", "", true);
    }

    public void startAPLinkConfigWifiWithSsid(Context context, String targetWifiName, String targetWifiPwd, String deviceSerial, String verifyCode, String deviceHotspotSSID, String deviceHotspotPwd, boolean isAutoConnectDeviceHotSpot) {
        Log.i((String)TAG, (String)"startAPLinkConfigWifiWithSsid");
        this.mContext = context;
        this.isAutoConnectDeviceHotSpot = isAutoConnectDeviceHotSpot;
        this.mWifiManager = (WifiManager)this.mContext.getApplicationContext().getSystemService("wifi");
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
            this.countDownTimer = null;
        }
        this.isTimeOut = true;
        this.cachedThreadPool.shutdown();
        if (this.mWiFiConnector != null) {
            this.mWiFiConnector.stop();
        }
        if (this.cachedThreadPool.isShutdown()) {
            this.cachedThreadPool = Executors.newSingleThreadExecutor();
        }
        this.countDownTimer = new CountDownTimer(this.mTimeOutSecond * 1000, 1000L){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                ApLinkConfigController.this.isTimeOut = true;
                if (ApLinkConfigController.this.mLinkConfigCallback != null) {
                    ApLinkConfigController.this.mLinkConfigCallback.reportError(EZConfigWifiErrorEnum.CONFIG_TIMEOUT);
                }
                ApLinkConfigController.this.stopAPLinkConfigWifiWithSsid();
            }
        };
        this.countDownTimer.start();
        WifiInfo mWifiInfo = this.mWifiManager.getConnectionInfo();
        this.isTimeOut = false;
        this.mSSID = targetWifiName;
        this.mPassword = targetWifiPwd;
        this.mDeviceSerial = deviceSerial;
        this.mVerifyCode = verifyCode;
        this.mTargetWifiMacAddress = mWifiInfo.getBSSID();
        this.mTargetWifiNetId = mWifiInfo.getNetworkId();
        if (!isAutoConnectDeviceHotSpot) {
            this.cachedThreadPool.submit(this.mTryToPaireDeviceAndConfigWifiTask);
            return;
        }
        this.mDeviceWifiSSID = TextUtils.isEmpty((CharSequence)deviceHotspotSSID) ? "EZVIZ_" + deviceSerial : deviceHotspotSSID;
        String mDeviceWifiPwd = TextUtils.isEmpty((CharSequence)deviceHotspotPwd) ? "EZVIZ_" + verifyCode : deviceHotspotPwd;
        this.mWiFiConnector = WiFiConnectorManager.getWiFiConnectorByOsVersion(this.mContext, this.mDeviceWifiSSID, mDeviceWifiPwd);
        this.mWiFiConnector.setListener(new WiFiConnectResultListener(){

            @Override
            public void onSuccess() {
                Log.d((String)ApLinkConfigController.TAG, (String)"WiFiConnecter onSuccess");
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ApLinkConfigController.this.cachedThreadPool.submit(ApLinkConfigController.this.mTryToPaireDeviceAndConfigWifiTask);
                    }
                }, 5000L);
            }

            @Override
            public void onFailure(int errorCode) {
                Log.d((String)ApLinkConfigController.TAG, (String)("WiFiConnecter onFailure " + errorCode));
                ApLinkConfigController.this.mLinkConfigCallback.onError(errorCode, null);
            }
        });
        this.mWiFiConnector.start();
    }
}

