/*
 * Decompiled with CFR 0.152.
 */
package com.videogo.util;

import com.videogo.util.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtil {
    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_FORMAT_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DAY_FORMAT = "yyyy-MM-dd";

    public static Date getNow() {
        Calendar c = Calendar.getInstance();
        return c.getTime();
    }

    public static Date beginDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date endDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static String formatDateToString(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = Utils.getEZDateFormat(pattern);
        return sdf.format(date);
    }

    public static String formatTimeString(long seconds) {
        String pattern = "HH:mm:ss";
        Date date = new Date(seconds * 1000L);
        SimpleDateFormat sdf = Utils.getEZDateFormat(pattern);
        return sdf.format(date);
    }

    public static Date parseStringToDate(String strDate, String pattern) {
        if (strDate == null || strDate.isEmpty()) {
            return null;
        }
        try {
            SimpleDateFormat sdf = Utils.getEZDateFormat(pattern);
            return sdf.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatTimeToString(long time, String pattern) {
        Date date = new Date();
        date.setTime(time);
        SimpleDateFormat sdf = Utils.getEZDateFormat(pattern);
        return sdf.format(date);
    }
}

