/*
 * Decompiled with CFR 0.152.
 */
package com.videogo.ezlink.local;

import android.content.Context;
import android.content.SharedPreferences;

public class EzlinkDataCache {
    public static final String LOCAL_DEVICE_LIST = "local_device_list";
    public static final String LOCAL_ONE_LOCAL_KEY = "local_one_local_key";
    public static final String LOCAL_GROUP_ID = "local_group_id";
    public static final String LOCAL_DEVICE_ID = "local_device_id";
    private SharedPreferences share;
    private SharedPreferences.Editor editor;
    private String SHARED_NAME = "ezlink_cache";
    private static EzlinkDataCache instance;

    private EzlinkDataCache() {
    }

    public void initDataCache(Context context) {
        this.share = context.getSharedPreferences(this.SHARED_NAME, 0);
        this.editor = this.share.edit();
    }

    public boolean hasNotInit() {
        return this.share == null || this.editor == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EzlinkDataCache getInstance() {
        if (instance != null) return instance;
        Class<EzlinkDataCache> clazz = EzlinkDataCache.class;
        synchronized (EzlinkDataCache.class) {
            if (instance != null) return instance;
            instance = new EzlinkDataCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void putInt(String spName, int value) {
        this.editor.putInt(spName, value);
        this.editor.commit();
    }

    public int getInt(String spName, int defaultvalue) {
        return this.share.getInt(spName, defaultvalue);
    }

    public void putString(String spName, String value) {
        this.editor.putString(spName, value);
        this.editor.commit();
    }

    public String getString(String spName, String defaultvalue) {
        return this.share.getString(spName, defaultvalue);
    }

    public String getString(String spName) {
        return this.share.getString(spName, "");
    }

    public void putBoolean(String key, boolean value) {
        this.editor.putBoolean(key, value);
        this.editor.commit();
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.share.getBoolean(key, defValue);
    }

    public void putFloat(String key, float value) {
        this.editor.putFloat(key, value);
        this.editor.commit();
    }

    public float getFloat(String key, float defValue) {
        return this.share.getFloat(key, defValue);
    }

    public void putLong(String key, long value) {
        this.editor.putLong(key, value);
        this.editor.commit();
    }

    public long getLong(String key, long defValue) {
        return this.share.getLong(key, defValue);
    }

    public void clear() {
        this.editor.clear();
        this.editor.commit();
    }

    public void remove(String key) {
        this.editor.remove(key);
        this.editor.commit();
    }

    public boolean contains(String key) {
        return this.share.contains(key);
    }
}

