/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.wifi.configuration;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.hikvision.wifi.configuration.BonjorBase;
import com.hikvision.wifi.configuration.DeviceDiscoveryListener;
import com.hikvision.wifi.configuration.DeviceInfo;
import java.io.IOException;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;

@SuppressLint(value={"NewApi"})
public class BonjorManage
extends BonjorBase {
    protected static final String TAG = "BonjorManage";
    private Context mContext;
    private NsdManager mNsdManager;
    private JmDNS jmdns;
    private DeviceDiscoveryListener myDevDiscoveryListener;
    private NsdManager.DiscoveryListener mNsdDiscoveryListener;
    private NsdManager.DiscoveryListener mSmartNsdDiscoveryListener;
    private ServiceListener myJmdnsDisCoveryLitener;
    private ServiceListener myJmdnsSmartDisCoveryLitener;
    private boolean abandonCache = false;
    private static final String TYPE = "_http._tcp.";
    private static final String SMART_TYPE = "_smart._tcp.";

    public BonjorManage(Context context, DeviceDiscoveryListener discoveryListener) {
        this.myDevDiscoveryListener = discoveryListener;
        this.mContext = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean start() {
        if (this.isSupportNSD()) {
            this.mNsdManager = (NsdManager)this.mContext.getSystemService("servicediscovery");
            if (this.mNsdManager != null) {
                this.mNsdDiscoveryListener = this.getDiscoveryListener();
                this.mSmartNsdDiscoveryListener = this.getDiscoveryListener();
                this.mNsdManager.discoverServices(TYPE, 1, this.mNsdDiscoveryListener);
                this.mNsdManager.discoverServices(SMART_TYPE, 1, this.mSmartNsdDiscoveryListener);
                return true;
            }
            Log.e((String)TAG, (String)"mContext.getSystemService(Context.NSD_SERVICE) failed .bonjor start failed");
            return false;
        }
        try {
            this.jmdns = JmDNS.create();
            Log.e((String)TAG, (String)"bonjour find \u542f\u52a8bonjor\u6210\u529f");
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e((String)"bonjour find", (String)("bonjour find \u542f\u52a8bonjor\u5931\u8d25 " + e.toString()));
        }
        if (this.jmdns == null) return true;
        this.myJmdnsDisCoveryLitener = this.getJmdnsDiscoveryListener();
        this.myJmdnsSmartDisCoveryLitener = this.getJmdnsDiscoveryListener();
        this.jmdns.addServiceListener(TYPE, this.myJmdnsDisCoveryLitener);
        this.jmdns.addServiceListener(SMART_TYPE, this.myJmdnsSmartDisCoveryLitener);
        return true;
    }

    @Override
    boolean stop() {
        if (this.jmdns != null) {
            if (this.myJmdnsDisCoveryLitener != null) {
                this.jmdns.removeServiceListener(TYPE, this.myJmdnsDisCoveryLitener);
            }
            if (this.myJmdnsSmartDisCoveryLitener != null) {
                this.jmdns.removeServiceListener(SMART_TYPE, this.myJmdnsSmartDisCoveryLitener);
            }
            Log.e((String)TAG, (String)"bonjour find \u505c\u6b62bonjor\u6210\u529f");
            try {
                this.jmdns.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Log.e((String)"bonjour find", (String)("bonjour find \u505c\u6b62bonjor\u5931\u8d25 " + e.toString()));
            }
            this.jmdns = null;
        }
        if (this.mNsdManager != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                if (this.mNsdDiscoveryListener != null) {
                    this.mNsdManager.stopServiceDiscovery(this.mNsdDiscoveryListener);
                }
                if (this.mSmartNsdDiscoveryListener != null) {
                    this.mNsdManager.stopServiceDiscovery(this.mSmartNsdDiscoveryListener);
                }
            }
            this.mNsdManager = null;
        }
        this.myDevDiscoveryListener = null;
        return true;
    }

    public boolean resolveServices(NsdServiceInfo serviceInfo) {
        Log.i((String)TAG, (String)"start resolve");
        if (this.mNsdManager != null && serviceInfo != null && !TextUtils.isEmpty((CharSequence)serviceInfo.getServiceName()) && !TextUtils.isEmpty((CharSequence)serviceInfo.getServiceType())) {
            this.mNsdManager.resolveService(serviceInfo, this.getResolveListener());
            return true;
        }
        return false;
    }

    private NsdManager.ResolveListener getResolveListener() {
        return new NsdManager.ResolveListener(){

            public void onServiceResolved(NsdServiceInfo serviceInfo) {
                Log.d((String)BonjorManage.TAG, (String)("onServiceResolved serviceInfo = " + serviceInfo));
                DeviceInfo devInfo = BonjorManage.this.parseServiceEvent(serviceInfo);
                if (devInfo != null && BonjorManage.this.myDevDiscoveryListener != null) {
                    BonjorManage.this.myDevDiscoveryListener.onDeviceFound(devInfo);
                }
            }

            public void onResolveFailed(NsdServiceInfo serviceInfo, int errorCode) {
                Log.d((String)BonjorManage.TAG, (String)("Resolve failed:" + errorCode + ", serviceInfo = " + serviceInfo));
            }
        };
    }

    private NsdManager.DiscoveryListener getDiscoveryListener() {
        return new NsdManager.DiscoveryListener(){
            long startTime = 0L;

            public void onDiscoveryStarted(String regType) {
                Log.d((String)BonjorManage.TAG, (String)"NSD Service discovery started\u2026\u2026");
                this.startTime = System.currentTimeMillis();
            }

            public void onServiceFound(NsdServiceInfo service) {
                Log.d((String)BonjorManage.TAG, (String)("NSD \u627e\u5230\u65b0\u7684\u8bbe\u5907\uff01name:" + service.getServiceName()));
                if (BonjorManage.this.abandonCache && System.currentTimeMillis() - this.startTime <= 2000L) {
                    Log.d((String)BonjorManage.TAG, (String)("\u629b\u5f03\u7f13\u5b58\u6570\u636e (" + (System.currentTimeMillis() - this.startTime) + "ms):" + service.getServiceName()));
                    return;
                }
                DeviceInfo devInfo = BonjorManage.this.parseServiceEvent(service);
                if (devInfo != null && BonjorManage.this.myDevDiscoveryListener != null) {
                    BonjorManage.this.myDevDiscoveryListener.onDeviceFound(devInfo);
                }
                if (devInfo != null && TextUtils.isEmpty((CharSequence)devInfo.getIp())) {
                    BonjorManage.this.resolveServices(service);
                }
            }

            public void onServiceLost(NsdServiceInfo service) {
                Log.d((String)BonjorManage.TAG, (String)("NSD \u8bbe\u5907\u5df2\u6ce8\u9500 name:" + service.getServiceName() + "\u8bbe\u5907\u5df2\u6ce8\u9500\uff01"));
                DeviceInfo devInfo = BonjorManage.this.parseServiceEvent(service);
                if (devInfo != null && BonjorManage.this.myDevDiscoveryListener != null) {
                    BonjorManage.this.myDevDiscoveryListener.onDeviceLost(devInfo);
                }
            }

            public void onDiscoveryStopped(String serviceType) {
                Log.d((String)BonjorManage.TAG, (String)("NSD Discovery stopped: " + serviceType));
            }

            public void onStartDiscoveryFailed(String serviceType, int errorCode) {
                Log.d((String)BonjorManage.TAG, (String)("NSD onStartDiscoveryFailed." + errorCode));
                if (BonjorManage.this.myDevDiscoveryListener != null) {
                    BonjorManage.this.myDevDiscoveryListener.onError("NSD onStartDiscoveryFailed.", errorCode);
                }
            }

            public void onStopDiscoveryFailed(String serviceType, int errorCode) {
                Log.d((String)BonjorManage.TAG, (String)("NSD Discovery failed: Error code:" + errorCode));
                if (BonjorManage.this.myDevDiscoveryListener != null) {
                    BonjorManage.this.myDevDiscoveryListener.onError("NSD onStopDiscoveryFailed.", errorCode);
                }
            }
        };
    }

    private ServiceListener getJmdnsDiscoveryListener() {
        return new ServiceListener(){

            public void serviceAdded(ServiceEvent ev) {
                Log.e((String)BonjorManage.TAG, (String)"bonjour find \u6536\u5230\u6d88\u606f serviceAdded ");
                BonjorManage.this.jmdns.requestServiceInfo(ev.getType(), ev.getName(), 100L);
                DeviceInfo devInfo = BonjorManage.this.parseServiceEvent(ev);
                if (devInfo != null && TextUtils.isEmpty((CharSequence)devInfo.getIp())) {
                    ServiceInfo serviceInfo = BonjorManage.this.jmdns.getServiceInfo(ev.getType(), ev.getName());
                    Log.i((String)BonjorManage.TAG, (String)("getServiceInfo: " + serviceInfo.toString()));
                    BonjorManage.this.parseServiceInfo(serviceInfo, devInfo);
                }
                if (BonjorManage.this.myDevDiscoveryListener != null) {
                    BonjorManage.this.myDevDiscoveryListener.onDeviceFound(devInfo);
                }
            }

            public void serviceRemoved(ServiceEvent ev) {
                Log.e((String)BonjorManage.TAG, (String)"bonjour find \u6536\u5230\u6d88\u606f Removed ");
                DeviceInfo devInfo = BonjorManage.this.parseServiceEvent(ev);
                if (BonjorManage.this.myDevDiscoveryListener != null) {
                    BonjorManage.this.myDevDiscoveryListener.onDeviceLost(devInfo);
                }
            }

            public void serviceResolved(ServiceEvent ev) {
                Log.e((String)BonjorManage.TAG, (String)"bonjour find \u6536\u5230\u6d88\u606f Resolved ");
                DeviceInfo devInfo = BonjorManage.this.parseServiceEvent(ev);
                if (BonjorManage.this.myDevDiscoveryListener != null) {
                    BonjorManage.this.myDevDiscoveryListener.onDeviceFound(devInfo);
                }
            }
        };
    }

    public boolean isAbandonCache() {
        return this.abandonCache;
    }

    public void setAbandonCache(boolean abandonCache) {
        this.abandonCache = abandonCache;
    }
}

