/*
 * Decompiled with CFR 0.152.
 */
package com.videogo.stream;

import android.content.Context;
import com.ez.player.EZMediaPlayer;
import com.ez.statistics.RootStatistics;
import com.ez.stream.EZStreamClientManager;
import com.ez.stream.VideoStreamInfo;
import com.videogo.errorlayer.ErrorInfo;
import com.videogo.ezdclog.EZDcLogManager;
import com.videogo.openapi.ConfigLoader;
import com.videogo.openapi.EZMediaPlayerEx;
import com.videogo.openapi.PlayAPI;
import com.videogo.openapi.bean.EZCloudRecordFile;
import com.videogo.openapi.bean.EZDevicePtzAngleInfo;
import com.videogo.openapi.bean.EZPMPlayPrivateTokenInfo;
import com.videogo.stream.EZFecStreamBase;
import com.videogo.stream.EZStreamParamHelp;
import com.videogo.util.JsonTools;
import com.videogo.util.LogUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class EZPlayback
extends EZFecStreamBase {
    private String startTime = null;
    private String stopTime = null;
    private Calendar stopTimeCalendar = null;
    private EZCloudRecordFile cloudRecordFile = null;

    public void setStopTimeCalendar(Calendar stopTimeCalendar) {
        this.stopTimeCalendar = stopTimeCalendar;
    }

    public EZPlayback(EZStreamParamHelp streamParamHelp, int iStreamSource, ConfigLoader.PlayConfig playConfig) {
        super(streamParamHelp, playConfig);
        this.streamSource = iStreamSource;
    }

    @Override
    protected boolean createEZMediaPlayer() {
        if (this.streamSource == 9) {
            this.initParam = this.streamParamHelp.paramAddCloudInfo(this.initParam, this.cloudRecordFile);
            if (this.cloudRecordFile != null) {
                this.initParam.szFileID = this.cloudRecordFile.getFileId();
                if (this.cloudRecordFile.getVideoType() >= -1 && this.cloudRecordFile.getiStorageVersion() >= -1) {
                    this.initParam.iVideoType = this.cloudRecordFile.getVideoType();
                    this.initParam.iStorageVersion = this.cloudRecordFile.getiStorageVersion();
                } else {
                    LogUtil.e("EZFecStreamBase", "createEZMediaPlayer: invalid iVideoType " + this.cloudRecordFile.getVideoType() + ", invalid iStorageVersion " + this.cloudRecordFile.getiStorageVersion());
                }
                if (this.cloudRecordFile.getSpaceId() > 0L) {
                    this.initParam.iBusType = 7;
                }
            }
        }
        if (this.startTime != null) {
            this.initParam.szStartTime = this.startTime;
        }
        if (this.stopTime != null) {
            this.initParam.szStopTime = this.stopTime;
        }
        LogUtil.d("EZFecStreamBase", "playback initParam is " + this.initParam.toString());
        this.mediaPlayer = new EZMediaPlayerEx(EZStreamClientManager.create((Context)PlayAPI.mApplication.getApplicationContext()), this.initParam);
        this.getEZLogStreamClientParams().opId = this.mediaPlayer.getUUID();
        this.getEZLogStreamClientParams().plTp = 2;
        return true;
    }

    @Override
    public boolean start() {
        ArrayList<VideoStreamInfo> videoList = new ArrayList<VideoStreamInfo>();
        VideoStreamInfo currentVideo = new VideoStreamInfo();
        currentVideo.beginTime = this.startTime;
        currentVideo.endTime = this.stopTime;
        videoList.add(currentVideo);
        if (!super.startPlayback(videoList)) {
            return false;
        }
        LogUtil.d("EZFecStreamBase", "streamsdk. start playback");
        return true;
    }

    @Override
    public void stop() {
        super.stop();
        this.handleStopSuccess();
    }

    public void setTimeInfo(String startTime, String stopTime) {
        this.startTime = startTime;
        this.stopTime = stopTime;
    }

    public void setCloudInfo(EZCloudRecordFile cloudRecordFile) {
        this.cloudRecordFile = cloudRecordFile;
    }

    public boolean pausePlayback() {
        if (this.mediaPlayer == null) {
            return false;
        }
        this.mediaPlayer.pausePlayback();
        return true;
    }

    public boolean resumePlayback() {
        if (this.mediaPlayer == null) {
            return false;
        }
        this.mediaPlayer.resumePlayback();
        return true;
    }

    @Override
    public void release() {
        super.release();
    }

    @Override
    protected void handlePlayerFailed(ErrorInfo errorInfo) {
        if ((errorInfo.errorCode == 380102 || errorInfo.errorCode == 380101 || errorInfo.errorCode == 380355 || errorInfo.errorCode == 380356) && this.mediaPlayer != null) {
            EZMediaPlayer.EZOSDTime ezosdTime = this.mediaPlayer.getOSDTime();
            if (this.stopTimeCalendar != null && ezosdTime != null) {
                GregorianCalendar mOSDTime = new GregorianCalendar();
                mOSDTime.set(ezosdTime.year, ezosdTime.month - 1, ezosdTime.day, ezosdTime.hour, ezosdTime.min, ezosdTime.sec);
                LogUtil.d("EZFecStreamBase", "EZPlayback. stopTimeCalendar= " + this.stopTimeCalendar.getTimeInMillis());
                LogUtil.d("EZFecStreamBase", "EZPlayback. mOSDTime= " + mOSDTime.getTimeInMillis());
                LogUtil.d("EZFecStreamBase", "EZPlayback. stopTimeCalendar - mOSDTime= " + (this.stopTimeCalendar.getTimeInMillis() - mOSDTime.getTimeInMillis()));
                long thresholdTime = 5000L;
                if (this.stopTimeCalendar.getTimeInMillis() - mOSDTime.getTimeInMillis() < 5000L) {
                    this.handlePlayFinished();
                    return;
                }
            } else {
                LogUtil.d("EZFecStreamBase", "EZPlayback. handlePlayerFailed mediaPlayer.getOSDTime() = null");
            }
        }
        LogUtil.d("EZFecStreamBase", "EZPlayback. handlePlayerFailed= " + errorInfo.errorCode);
        this.sendMessage(206, errorInfo.errorCode, errorInfo);
        if (errorInfo.errorCode != 400037 && this.getEZLogStreamClientParams().cost == 0) {
            this.getEZLogStreamClientParams().errCd = errorInfo.errorCode;
            this.getEZLogStreamClientParams().cost = (int)(System.currentTimeMillis() - this.getEZLogStreamClientParams().timebyLong);
            EZDcLogManager.getInstance().submit(this.getEZLogStreamClientParams());
        }
    }

    @Override
    protected void handlePlaySuccess() {
        LogUtil.d("EZFecStreamBase", "EZPlayback. handlePlaySuccess");
        this.sendMessage(205, 0, null);
        if (this.mediaPlayer != null && this.getEZLogStreamClientParams().cost == 0) {
            this.getEZLogStreamClientParams().cost = (int)(System.currentTimeMillis() - this.getEZLogStreamClientParams().timebyLong);
            RootStatistics rootStatistics = JsonTools.fromJson(this.mediaPlayer.getRootStatistics(), RootStatistics.class);
            this.getEZLogStreamClientParams().via = rootStatistics != null ? rootStatistics.mFirstVIA_OK : -1;
            this.getEZLogStreamClientParams().errCd = 0;
        }
    }

    @Override
    protected void handlePlayFinished() {
        LogUtil.d("EZFecStreamBase", "EZPlayback. handlePlayFinished");
        this.sendMessage(201, 0, null);
    }

    @Override
    protected void handleVideoSizeChange(int width, int height) {
        LogUtil.d("EZFecStreamBase", "EZPlayback. handleVideoSizeChange");
        this.sendMessage(134, 0, new StringBuffer().append(width).append(":").append(height).toString());
    }

    @Override
    protected void handlePlayAdditionalInfo(EZDevicePtzAngleInfo info) {
    }

    @Override
    protected void handlePlayPrivateTokenInfo(EZPMPlayPrivateTokenInfo info) {
    }

    protected void handleStopSuccess() {
        LogUtil.d("EZFecStreamBase", "EZPlayback. handleStopSuccess");
        this.sendMessage(221, 0, null);
    }
}

