/*
 * Decompiled with CFR 0.152.
 */
package com.videogo.ezlink;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.videogo.ezlink.bean.FeatureConfigInfo;
import com.videogo.ezlink.bean.OtapMessageInfo;
import com.videogo.ezlink.bean.PairDeviceInfo;
import com.videogo.ezlink.bean.SearchRecordByMonthResultInfo;
import com.videogo.ezlink.bean.SearchRecordResultInfo;
import com.videogo.ezlink.callback.EzLinkCallBack;
import com.videogo.ezlink.local.EzlinkDataCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EzLinkManager
implements EzLinkCallBack {
    private static EzLinkManager INSTANCE;
    private static final String TAG = "EzLinkManager";
    public static final int CMD_EVENT = 0;
    public static final int CMD_ATTR = 1;
    public static final int CMD_OPERATION = 2;
    public static final String CMD_SET_ATTR = "set";
    public static final String CMD_GET_ATTR = "get";
    public static final String CMD_ACTION = "operate";
    private Map<String, FeatureConfigInfo> deviceConfigMap;
    private Handler uiHandler;
    private AtomicInteger seqId;
    private Map<DeviceStateChangeCallBack, Object> statusChangeCallBackMap;
    private Map<PairDeviceListCallBack, Object> queryPairDeviceCallBackMap;
    private Map<String, PairDeviceResultCallBack> pairDeviceCallBackMap;
    private Map<String, UnPairDeviceResultCallBack> unpairDeviceCallBackMap;
    private Map<String, OnMessageResultCallBack> msgResultCallBackMap;
    private Map<String, OnDeviceFeatureInfoCallBack> deviceFeatureInfoResultCallBackMap;
    private Map<String, OnSearchRecordResultCallBack> searchRecordResultCallBackMap;
    private Map<String, OnSearchRecordByMonthResultCallBack> searchRecordByMonthResultCallBackMap;
    private Map<String, PairDeviceInfo> queryPairedDeviceInfoMap;
    private List<PairDeviceInfo> cachePairedDeviceList;
    private volatile boolean startFlag = false;
    private volatile boolean pairModelInit = false;
    private ExecutorService singleThreadPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EzLinkManager getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<EzLinkManager> clazz = EzLinkManager.class;
        synchronized (EzLinkManager.class) {
            if (INSTANCE == null) {
                INSTANCE = new EzLinkManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private EzLinkManager() {
        System.loadLibrary("c++_shared");
        System.loadLibrary("ezlinkapp");
        System.loadLibrary("ezlinksdk");
        this.singleThreadPool = Executors.newSingleThreadExecutor();
        this.uiHandler = new Handler(Looper.getMainLooper());
        this.deviceConfigMap = new HashMap<String, FeatureConfigInfo>();
        this.statusChangeCallBackMap = new WeakHashMap<DeviceStateChangeCallBack, Object>();
        this.queryPairDeviceCallBackMap = new WeakHashMap<PairDeviceListCallBack, Object>();
        this.pairDeviceCallBackMap = new WeakHashMap<String, PairDeviceResultCallBack>();
        this.unpairDeviceCallBackMap = new WeakHashMap<String, UnPairDeviceResultCallBack>();
        this.msgResultCallBackMap = new WeakHashMap<String, OnMessageResultCallBack>();
        this.deviceFeatureInfoResultCallBackMap = new WeakHashMap<String, OnDeviceFeatureInfoCallBack>();
        this.searchRecordResultCallBackMap = new WeakHashMap<String, OnSearchRecordResultCallBack>();
        this.searchRecordByMonthResultCallBackMap = new WeakHashMap<String, OnSearchRecordByMonthResultCallBack>();
        this.cachePairedDeviceList = new ArrayList<PairDeviceInfo>();
        this.queryPairedDeviceInfoMap = new ConcurrentHashMap<String, PairDeviceInfo>();
        this.seqId = new AtomicInteger(1);
    }

    public List<PairDeviceInfo> getLocalPairedDevices(Context context) {
        if (EzlinkDataCache.getInstance().hasNotInit()) {
            EzlinkDataCache.getInstance().initDataCache(context);
        }
        String cacheDataValue = EzlinkDataCache.getInstance().getString("local_device_list");
        this.xlog("EzLinkManager: local saved data: " + cacheDataValue);
        this.cachePairedDeviceList.clear();
        ArrayList<String> serials = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)cacheDataValue)) {
            try {
                JSONObject obj;
                JSONArray arr = new JSONArray(cacheDataValue);
                for (int i = 0; i < arr.length() && (obj = arr.getJSONObject(i)) != null; ++i) {
                    if (serials.contains(arr.getJSONObject(i).getString("deviceSerial"))) continue;
                    PairDeviceInfo tmp = new PairDeviceInfo();
                    tmp.parseFromJSONObj(arr.getJSONObject(i));
                    tmp.isDeviceOnline = false;
                    serials.add(tmp.deviceSerial);
                    this.cachePairedDeviceList.add(tmp);
                    this.queryPairedDeviceInfoMap.put(tmp.deviceSerial, tmp);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this.cachePairedDeviceList;
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo wifiNetworkInfo = connectivityManager.getNetworkInfo(1);
        return wifiNetworkInfo.isConnected();
    }

    public void openEzlinkDebugLog() {
        if (this.startFlag) {
            this.openDebugLog();
        }
    }

    public int startEzlink(Context context, String authKey, String deviceId, String model) {
        int resultCode = 6806;
        if (this.startFlag) {
            Log.d((String)"start", (String)"\u5df2\u7ecf\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u65e0\u9700\u518d\u6267\u884c\u521d\u59cb\u5316");
            return 6800;
        }
        try {
            String ezlinkConfigPath = context.getExternalFilesDir("").getAbsolutePath();
            Log.d((String)"start", (String)("ezlinkConfigPath\uff1a " + ezlinkConfigPath));
            resultCode = this.initEzLink(deviceId, model, Build.MANUFACTURER, authKey, ezlinkConfigPath);
            this.startFlag = resultCode == 0;
            Log.d((String)"start", (String)("\u521d\u59cb\u5316\u7ed3\u679c\uff1a " + resultCode));
            this.getLocalPairedDevices(context);
            if (!this.pairModelInit) {
                resultCode = this.initEzlinkPair();
                this.pairModelInit = resultCode == 0;
                Log.d((String)"start", (String)("\u521d\u59cb\u5316\u914d\u5bf9\u7ed3\u679c\uff1a " + resultCode));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            resultCode = 6888;
        }
        return resultCode;
    }

    public boolean isDeviceLinked(String deviceSerial) {
        for (PairDeviceInfo item : this.cachePairedDeviceList) {
            if (!TextUtils.equals((CharSequence)item.deviceSerial, (CharSequence)deviceSerial)) continue;
            return item.isDeviceOnline;
        }
        return false;
    }

    private PairDeviceInfo getLocalPairDeviceInfo(String deviceSerial) {
        PairDeviceInfo deviceInfo = null;
        for (int i = 0; i < this.cachePairedDeviceList.size(); ++i) {
            if (!TextUtils.equals((CharSequence)deviceSerial, (CharSequence)this.cachePairedDeviceList.get((int)i).deviceSerial)) continue;
            deviceInfo = this.cachePairedDeviceList.get(i);
            break;
        }
        return deviceInfo;
    }

    public boolean isDeviceSleep(String deviceSerial) {
        PairDeviceInfo item = this.getLocalPairDeviceInfo(deviceSerial);
        if (item != null && item.isDeviceOnline) {
            return this.isDeviceWeakup(deviceSerial, item.deviceIP) == 1;
        }
        return true;
    }

    public int initEzlinkPair() {
        int resultCode = 6804;
        if (this.pairModelInit) {
            Log.d((String)"start", (String)"\u5df2\u7ecf\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u65e0\u9700\u518d\u6267\u884c\u521d\u59cb\u5316");
            return 6800;
        }
        resultCode = this.initEzLinkPair();
        this.pairModelInit = resultCode == 0;
        return resultCode;
    }

    public int queryDevices() {
        this.queryPairedDeviceInfoMap.clear();
        return this.startEzLinkPairQuery();
    }

    public void sendCmdBeforePair(final String verifyCode, final OtapMessageInfo cmdMsg, final OnMessageResultCallBack callBack, final long timeout, final int type, final String operate) {
        if (!this.startFlag) {
            if (callBack != null) {
                callBack.onMessageResult(6806, null);
            }
            return;
        }
        this.xlog("EzLinkManager: sendCmdBeforePair: " + this.queryPairedDeviceInfoMap.toString());
        final PairDeviceInfo pairDeviceInfo = this.queryPairedDeviceInfoMap.get(cmdMsg.deviceSerial);
        if (pairDeviceInfo == null) {
            if (callBack != null) {
                callBack.onMessageResult(6805, null);
            }
            return;
        }
        this.singleThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                int result = -1;
                try {
                    int seqIDVal;
                    cmdMsg.msgSeq = seqIDVal = EzLinkManager.this.seqId.getAndIncrement();
                    Log.d((String)EzLinkManager.TAG, (String)("cmdMsg: " + cmdMsg.toString()));
                    final String msgKey = cmdMsg.domain + "_" + cmdMsg.identifier + "_" + seqIDVal;
                    EzLinkManager.this.msgResultCallBackMap.put(msgKey, callBack);
                    for (int i = 0; i < 5; ++i) {
                        OnMessageResultCallBack msgCallBack;
                        if (i > 0 && callBack != null && (msgCallBack = (OnMessageResultCallBack)EzLinkManager.this.msgResultCallBackMap.get(msgKey)) == null) {
                            EzLinkManager.this.xlog("EzLinkManager: \u56de\u8c03\u4e3a\u7a7a\uff0c" + msgKey + " \u53d1\u9001\u6210\u529f, \u5e76\u4e14\u56de\u8c03\u5df2\u8fd4\u56de\uff0c \u4e0d\u7ee7\u7eed\u53d1\u9001");
                            return;
                        }
                        EzLinkManager.this.xlog("EzLinkManager: sendCmdBeforePair with msgKey: " + msgKey);
                        result = EzLinkManager.this.sendMsgBeforePair(verifyCode, cmdMsg.deviceSerial, cmdMsg.subDeviceSerial, pairDeviceInfo.deviceIP, cmdMsg.resourceId, cmdMsg.resourceType, cmdMsg.domain, cmdMsg.identifier, cmdMsg.body, seqIDVal, type, operate);
                        Thread.sleep(400L);
                    }
                    if (callBack == null) {
                        Log.d((String)EzLinkManager.TAG, (String)"sendCmdBeforePair without callback");
                        return;
                    }
                    Log.d((String)EzLinkManager.TAG, (String)("sendCmdBeforePair result \uff1a " + result));
                    if (result == 0) {
                        EzLinkManager.this.uiHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                OnMessageResultCallBack msgCallBack = (OnMessageResultCallBack)EzLinkManager.this.msgResultCallBackMap.get(msgKey);
                                if (msgCallBack != null) {
                                    EzLinkManager.this.xlog("EzLinkManager: sendCmdBeforePair \u8d85\u65f6\u56de\u8c03\uff1amap key: " + msgKey);
                                    msgCallBack.onMessageResult(6808, null);
                                    EzLinkManager.this.msgResultCallBackMap.remove(msgKey);
                                }
                            }
                        }, timeout);
                    } else {
                        final int resultCode = result;
                        EzLinkManager.this.uiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (callBack != null) {
                                    callBack.onMessageResult(resultCode, null);
                                }
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    EzLinkManager.this.uiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (callBack != null) {
                                callBack.onMessageResult(6888, null);
                            }
                        }
                    });
                }
            }
        });
    }

    public int doPairDevice(PairDeviceInfo deviceInfo, String verifyCode, PairDeviceResultCallBack callBack) {
        if (!this.pairModelInit) {
            callBack.onPairDeviceResult(6804, null);
            return 6804;
        }
        if (TextUtils.isEmpty((CharSequence)verifyCode) || deviceInfo == null || TextUtils.isEmpty((CharSequence)deviceInfo.deviceSerial) || TextUtils.isEmpty((CharSequence)deviceInfo.deviceIP) || TextUtils.isEmpty((CharSequence)deviceInfo.deviceRand)) {
            callBack.onPairDeviceResult(6899, null);
            return 6899;
        }
        int result = this.doEzLinkPair(deviceInfo.deviceSerial, deviceInfo.deviceIP, deviceInfo.deviceRand, verifyCode);
        if (result == 0) {
            this.queryPairedDeviceInfoMap.put(deviceInfo.deviceSerial, deviceInfo);
            this.addOrUpdatePairedDeviceInfo(deviceInfo);
            callBack.onPairDeviceResult(0, deviceInfo);
        } else {
            callBack.onPairDeviceResult(result, deviceInfo);
        }
        return result;
    }

    public int queryDeviceFeatureInfo(final String deviceSerial, OnDeviceFeatureInfoCallBack callBack) {
        if (TextUtils.isEmpty((CharSequence)deviceSerial)) {
            callBack.onDeviceFeatureInfoResult(6899, null);
            return 6899;
        }
        if (this.deviceConfigMap.containsKey(deviceSerial + "_feature")) {
            FeatureConfigInfo cacheData;
            block5: {
                cacheData = this.deviceConfigMap.get(deviceSerial + "_feature");
                Log.d((String)TAG, (String)("cache feature data: " + cacheData));
                int length = cacheData.toString().length();
                if (length > 2000) {
                    Log.d((String)TAG, (String)("length: " + length));
                    int i = 0;
                    while (true) {
                        if (i + 2000 >= length) {
                            Log.d((String)TAG, (String)("onDeviceFeatureResult : " + cacheData.toString().substring(i)));
                            break block5;
                        }
                        Log.d((String)TAG, (String)("onDeviceFeatureResult: " + cacheData.toString().substring(i, i + 2000)));
                        i += 2000;
                    }
                }
                Log.d((String)TAG, (String)("onDeviceFeatureResult: " + cacheData));
            }
            callBack.onDeviceFeatureInfoResult(0, cacheData);
            return 0;
        }
        this.deviceFeatureInfoResultCallBackMap.put(deviceSerial, callBack);
        this.uiHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                OnDeviceFeatureInfoCallBack msgCallBack = (OnDeviceFeatureInfoCallBack)EzLinkManager.this.deviceFeatureInfoResultCallBackMap.get(deviceSerial);
                if (msgCallBack != null) {
                    Log.d((String)EzLinkManager.TAG, (String)("queryDeviceFeatureInfo \u8d85\u65f6\u56de\u8c03\uff1amap key: " + deviceSerial));
                    msgCallBack.onDeviceFeatureInfoResult(6808, null);
                    EzLinkManager.this.deviceFeatureInfoResultCallBackMap.remove(deviceSerial);
                }
            }
        }, 15000L);
        return this.getDeviceFeatureInfo(deviceSerial);
    }

    public int unPairDevice(final String deviceSerial, UnPairDeviceResultCallBack callBack) {
        if (!this.pairModelInit) {
            callBack.onUnPairDeviceResult(false);
            return 6804;
        }
        this.unpairDeviceCallBackMap.put(deviceSerial, callBack);
        this.uiHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                UnPairDeviceResultCallBack msgCallBack = (UnPairDeviceResultCallBack)EzLinkManager.this.unpairDeviceCallBackMap.get(deviceSerial);
                if (msgCallBack != null) {
                    Log.d((String)EzLinkManager.TAG, (String)("unPairDevice \u8d85\u65f6\u56de\u8c03\uff1amap key: " + deviceSerial));
                    msgCallBack.onUnPairDeviceResult(false);
                    EzLinkManager.this.unpairDeviceCallBackMap.remove(deviceSerial);
                }
            }
        }, 5000L);
        return this.unBindEzLink(deviceSerial);
    }

    public void stopEzlinkPair() {
        this.singleThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                if (EzLinkManager.this.pairModelInit) {
                    EzLinkManager.this.releaseEzLinkPair();
                }
                EzLinkManager.this.pairModelInit = false;
            }
        });
    }

    public void stopEzlink() {
        this.singleThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                if (EzLinkManager.this.startFlag) {
                    try {
                        if (EzLinkManager.this.pairModelInit) {
                            EzLinkManager.this.releaseEzLinkPair();
                            EzLinkManager.this.pairModelInit = false;
                        }
                        EzLinkManager.this.releaseEzLink();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    EzLinkManager.this.startFlag = false;
                }
            }
        });
    }

    public void registerQueryPairDeviceCallBack(PairDeviceListCallBack callBack) {
        this.queryPairDeviceCallBackMap.put(callBack, this);
    }

    public void removeQueryPairDeviceCallBack(PairDeviceListCallBack callBack) {
        this.queryPairDeviceCallBackMap.remove(callBack);
    }

    public void clearQueryPairDeviceCallBack() {
        this.queryPairDeviceCallBackMap.clear();
    }

    public void sendMsgSetAttr(OtapMessageInfo cmdMsg, OnMessageResultCallBack callBack, long timeout) {
        this.sendMsg2Ezlink(cmdMsg, callBack, timeout, 1, CMD_SET_ATTR);
    }

    public void sendMsgReadAttr(OtapMessageInfo cmdMsg, OnMessageResultCallBack callBack, long timeout) {
        this.sendMsg2Ezlink(cmdMsg, callBack, timeout, 1, CMD_GET_ATTR);
    }

    public void sendMsgDoAction(OtapMessageInfo cmdMsg, OnMessageResultCallBack callBack, long timeout) {
        this.sendMsg2Ezlink(cmdMsg, callBack, timeout, 2, CMD_ACTION);
    }

    public void sendMsg2Ezlink(final OtapMessageInfo cmdMsg, final OnMessageResultCallBack callBack, final long timeout, final int type, final String operate) {
        if (!this.startFlag) {
            if (callBack != null) {
                callBack.onMessageResult(6806, null);
            }
            return;
        }
        final PairDeviceInfo pairDeviceInfo = this.getLocalPairDeviceInfo(cmdMsg.deviceSerial);
        if (pairDeviceInfo == null) {
            if (callBack != null) {
                callBack.onMessageResult(6805, null);
            }
            return;
        }
        this.singleThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                int result = -1;
                try {
                    int seqIDVal = EzLinkManager.this.seqId.getAndIncrement();
                    final String msgKey = cmdMsg.domain + "_" + cmdMsg.identifier + "_" + seqIDVal;
                    EzLinkManager.this.xlog("EzLinkManager: sendMsg2Ezlink with msgKey: " + msgKey);
                    result = EzLinkManager.this.sendMsg(cmdMsg.deviceSerial, cmdMsg.subDeviceSerial, pairDeviceInfo.deviceIP, cmdMsg.resourceId, cmdMsg.resourceType, cmdMsg.domain, cmdMsg.identifier, cmdMsg.body, seqIDVal, type, operate);
                    if (callBack == null) {
                        Log.d((String)EzLinkManager.TAG, (String)"send without callback");
                        return;
                    }
                    Log.d((String)EzLinkManager.TAG, (String)("send result: " + result + ", timeout: " + timeout));
                    if (result == 0) {
                        EzLinkManager.this.msgResultCallBackMap.put(msgKey, callBack);
                        EzLinkManager.this.uiHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                OnMessageResultCallBack msgCallBack = (OnMessageResultCallBack)EzLinkManager.this.msgResultCallBackMap.get(msgKey);
                                if (msgCallBack != null) {
                                    EzLinkManager.this.xlog("EzLinkManager: sendMsg2Ezlink \u8d85\u65f6\u56de\u8c03\uff1amap key: " + msgKey);
                                    msgCallBack.onMessageResult(6808, null);
                                    EzLinkManager.this.msgResultCallBackMap.remove(msgKey);
                                }
                            }
                        }, timeout);
                    } else {
                        final int resultCode = result;
                        EzLinkManager.this.uiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (callBack != null) {
                                    callBack.onMessageResult(resultCode, null);
                                }
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    EzLinkManager.this.uiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (callBack != null) {
                                callBack.onMessageResult(6888, null);
                            }
                        }
                    });
                }
            }
        });
    }

    public void initStreamNativeModule() {
        this.initStreamModule();
    }

    public void queryRecordByTime(String deviceID, String startTime, String endTime, OnSearchRecordResultCallBack callBack) {
        final int seqIDVal = this.seqId.getAndIncrement();
        this.searchRecordResultCallBackMap.put("RecordByTime_" + seqIDVal, callBack);
        this.xlog("EzLinkManager: searchRecordResultCallBackMap add key: RecordByTime_" + seqIDVal);
        this.searchRecordsByTime(deviceID, startTime, endTime);
        this.uiHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                String msgKey = "RecordByTime_" + seqIDVal;
                OnSearchRecordResultCallBack tmpCallback = (OnSearchRecordResultCallBack)EzLinkManager.this.searchRecordResultCallBackMap.get(msgKey);
                if (tmpCallback != null) {
                    EzLinkManager.this.xlog("EzLinkManager: queryRecordByTime \u8d85\u65f6\u56de\u8c03");
                    tmpCallback.onSearchRecordResult(6808, null);
                    EzLinkManager.this.searchRecordResultCallBackMap.remove(msgKey);
                }
            }
        }, 5000L);
    }

    public void queryRecordByMonth(String deviceID, int year, int month, OnSearchRecordByMonthResultCallBack callBack) {
        int seqIDVal = this.seqId.getAndIncrement();
        final String msgKey = "" + year + "_" + month + "_" + seqIDVal;
        this.xlog("EzLinkManager: queryRecordByMonth add key: " + msgKey);
        this.searchRecordByMonthResultCallBackMap.put(msgKey, callBack);
        this.searchRecordsByMonth(deviceID, year, month);
        this.uiHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                OnSearchRecordByMonthResultCallBack msgCallBack = (OnSearchRecordByMonthResultCallBack)EzLinkManager.this.searchRecordByMonthResultCallBackMap.get(msgKey);
                if (msgCallBack != null) {
                    EzLinkManager.this.xlog("EzLinkManager: queryRecordByMonth \u8d85\u65f6\u56de\u8c03\uff1amap key: " + msgKey);
                    msgCallBack.onSearchRecordByMonthResult(6808, null);
                    EzLinkManager.this.searchRecordByMonthResultCallBackMap.remove(msgKey);
                }
            }
        }, 5000L);
    }

    public void registerOtapPushListener(OtapMessageInfo cmdMsg, OnMessageResultCallBack callBack, long timeout, int type, String operate) {
    }

    @Override
    public void onDeviceStatusChanged(String deviceSerial, int status) {
        boolean isOnline = status == 1;
        PairDeviceInfo deviceInfo = this.getLocalPairDeviceInfo(deviceSerial);
        if (deviceInfo != null && deviceInfo.isDeviceOnline != isOnline) {
            this.xlog("EzLinkManager: onDeviceStatusChanged: " + deviceSerial + " isOnline\uff1a " + isOnline);
            deviceInfo.isDeviceOnline = isOnline;
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (DeviceStateChangeCallBack callBack : EzLinkManager.this.statusChangeCallBackMap.keySet()) {
                        callBack.onDeviceStateChanged(EzLinkManager.this.cachePairedDeviceList);
                    }
                }
            });
        }
    }

    @Override
    public void onDeviceIpChanged(String deviceSerial, String ipAddr) {
        PairDeviceInfo deviceInfo = this.getLocalPairDeviceInfo(deviceSerial);
        if (deviceInfo != null) {
            this.xlog("EzLinkManager: onDeviceIpChanged: " + deviceSerial + " ipAddr\uff1a " + ipAddr);
            this.onlyUpdatePairedDeviceIp(deviceSerial, ipAddr);
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (DeviceStateChangeCallBack callBack : EzLinkManager.this.statusChangeCallBackMap.keySet()) {
                        callBack.onDeviceStateChanged(EzLinkManager.this.cachePairedDeviceList);
                    }
                }
            });
        }
    }

    @Override
    public void onQueryDeviceCallback(PairDeviceInfo queryPairInfo) {
        this.xlog("EzLinkManager: onQueryDeviceCallback: " + queryPairInfo.deviceSerial);
        if (this.queryPairedDeviceInfoMap.containsKey(queryPairInfo.deviceSerial)) {
            PairDeviceInfo tmp = this.queryPairedDeviceInfoMap.get(queryPairInfo.deviceSerial);
            if (TextUtils.equals((CharSequence)tmp.deviceIP, (CharSequence)queryPairInfo.deviceIP) && TextUtils.equals((CharSequence)tmp.deviceRand, (CharSequence)queryPairInfo.deviceRand)) {
                return;
            }
        }
        this.queryPairedDeviceInfoMap.put(queryPairInfo.deviceSerial, queryPairInfo);
        this.onlyUpdatePairedDeviceIp(queryPairInfo.deviceSerial, queryPairInfo.deviceIP);
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                for (PairDeviceListCallBack callBack : EzLinkManager.this.queryPairDeviceCallBackMap.keySet()) {
                    callBack.onQueryPairDeviceChanged(new ArrayList<PairDeviceInfo>(EzLinkManager.this.queryPairedDeviceInfoMap.values()));
                }
            }
        });
    }

    @Override
    public void onPairResult(final PairDeviceInfo pairInfo) {
        this.xlog("EzLinkManager: onReceivePairDevice: " + pairInfo);
        if (pairInfo.pairResult == 0) {
            this.queryPairedDeviceInfoMap.put(pairInfo.deviceSerial, pairInfo);
            this.addOrUpdatePairedDeviceInfo(pairInfo);
        }
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                PairDeviceResultCallBack callBack = (PairDeviceResultCallBack)EzLinkManager.this.pairDeviceCallBackMap.get(pairInfo.deviceSerial);
                if (callBack != null) {
                    callBack.onPairDeviceResult(0, pairInfo);
                    EzLinkManager.this.pairDeviceCallBackMap.remove(pairInfo.deviceSerial);
                }
            }
        });
    }

    @Override
    public void onUnpairResult(final String deviceSerial) {
        final boolean flag = this.queryPairedDeviceInfoMap.containsKey(deviceSerial);
        this.queryPairedDeviceInfoMap.remove(deviceSerial);
        this.removePairedDeviceInfo(deviceSerial);
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                UnPairDeviceResultCallBack callBack = (UnPairDeviceResultCallBack)EzLinkManager.this.unpairDeviceCallBackMap.get(deviceSerial);
                if (callBack != null) {
                    callBack.onUnPairDeviceResult(flag);
                    EzLinkManager.this.unpairDeviceCallBackMap.remove(deviceSerial);
                }
            }
        });
    }

    private void onlyUpdatePairedDeviceIp(String deviceSerial, String deviceIP) {
        if (TextUtils.isEmpty((CharSequence)deviceSerial) || TextUtils.isEmpty((CharSequence)deviceIP)) {
            return;
        }
        boolean updated = false;
        for (int i = 0; i < this.cachePairedDeviceList.size(); ++i) {
            if (!TextUtils.equals((CharSequence)this.cachePairedDeviceList.get((int)i).deviceSerial, (CharSequence)deviceSerial)) continue;
            if (deviceIP.equals(this.cachePairedDeviceList.get((int)i).deviceIP)) {
                return;
            }
            this.cachePairedDeviceList.get((int)i).deviceIP = deviceIP;
            updated = true;
            break;
        }
        if (!updated) {
            return;
        }
        JSONArray arr = new JSONArray();
        for (int i = 0; i < this.cachePairedDeviceList.size(); ++i) {
            PairDeviceInfo tmpObj = this.cachePairedDeviceList.get(i);
            arr.put((Object)tmpObj.toJSONObj());
        }
        this.xlog("EzLinkManager: addOrUpdate device list: " + arr.toString());
        EzlinkDataCache.getInstance().putString("local_device_list", arr.toString());
    }

    private void addOrUpdatePairedDeviceInfo(PairDeviceInfo pairInfo) {
        if (pairInfo == null || TextUtils.isEmpty((CharSequence)pairInfo.deviceSerial)) {
            return;
        }
        boolean updated = false;
        for (int i = 0; i < this.cachePairedDeviceList.size(); ++i) {
            if (!TextUtils.equals((CharSequence)this.cachePairedDeviceList.get((int)i).deviceSerial, (CharSequence)pairInfo.deviceSerial)) continue;
            if (pairInfo.toString().equals(this.cachePairedDeviceList.get(i).toString())) {
                return;
            }
            this.cachePairedDeviceList.get(i).copyFrom(pairInfo);
            updated = true;
            break;
        }
        if (!updated) {
            this.cachePairedDeviceList.add(pairInfo);
        }
        JSONArray arr = new JSONArray();
        for (int i = 0; i < this.cachePairedDeviceList.size(); ++i) {
            PairDeviceInfo tmpObj = this.cachePairedDeviceList.get(i);
            arr.put((Object)tmpObj.toJSONObj());
        }
        this.xlog("EzLinkManager: addOrUpdate device list: " + arr.toString());
        EzlinkDataCache.getInstance().putString("local_device_list", arr.toString());
    }

    private void removePairedDeviceInfo(String deviceSerial) {
        if (TextUtils.isEmpty((CharSequence)deviceSerial)) {
            return;
        }
        JSONArray arr = new JSONArray();
        int removeIndex = -1;
        for (int i = 0; i < this.cachePairedDeviceList.size(); ++i) {
            if (TextUtils.equals((CharSequence)this.cachePairedDeviceList.get((int)i).deviceSerial, (CharSequence)deviceSerial)) {
                removeIndex = i;
                continue;
            }
            PairDeviceInfo tmpObj = this.cachePairedDeviceList.get(i);
            arr.put((Object)tmpObj.toJSONObj());
        }
        if (removeIndex != -1) {
            this.cachePairedDeviceList.remove(removeIndex);
        }
        this.xlog("EzLinkManager: save device list: " + arr.toString());
        EzlinkDataCache.getInstance().putString("local_device_list", arr.toString());
    }

    @Override
    public void onMessageResult(final OtapMessageInfo msgInfo) {
        String tmpKey = "";
        if (TextUtils.isEmpty((CharSequence)msgInfo.domain) || TextUtils.isEmpty((CharSequence)msgInfo.identifier)) {
            for (String key : this.msgResultCallBackMap.keySet()) {
                String strID = key.split("_")[2];
                if (!strID.equals("" + msgInfo.msgSeq)) continue;
                tmpKey = key;
                break;
            }
        }
        final String msgKey = TextUtils.isEmpty((CharSequence)tmpKey) ? msgInfo.domain + "_" + msgInfo.identifier + "_" + msgInfo.msgSeq : tmpKey;
        this.xlog("EzLinkManager: onMessageResult: " + msgKey);
        final OnMessageResultCallBack callBack = this.msgResultCallBackMap.get(msgKey);
        if (callBack != null) {
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (msgInfo.verifyFlag == 0) {
                        callBack.onMessageResult(0, msgInfo);
                    } else {
                        callBack.onMessageResult(6810, null);
                    }
                    EzLinkManager.this.msgResultCallBackMap.remove(msgKey);
                }
            });
        }
    }

    @Override
    public void onDeviceFeatureResult(final FeatureConfigInfo featureInfo) {
        block3: {
            int length = featureInfo.toString().length();
            if (length > 2000) {
                Log.d((String)TAG, (String)("length: " + length));
                int i = 0;
                while (true) {
                    if (i + 2000 >= length) {
                        Log.d((String)TAG, (String)("onDeviceFeatureResult : " + featureInfo.toString().substring(i)));
                        break block3;
                    }
                    Log.d((String)TAG, (String)("onDeviceFeatureResult: " + featureInfo.toString().substring(i, i + 2000)));
                    i += 2000;
                }
            }
            Log.d((String)TAG, (String)("onDeviceFeatureResult: " + featureInfo));
        }
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                String msgKey = featureInfo.deviceSerial;
                OnDeviceFeatureInfoCallBack callBack = (OnDeviceFeatureInfoCallBack)EzLinkManager.this.deviceFeatureInfoResultCallBackMap.get(msgKey);
                if (callBack != null) {
                    EzLinkManager.this.deviceConfigMap.put(msgKey + "_feature", featureInfo);
                    callBack.onDeviceFeatureInfoResult(0, featureInfo);
                    EzLinkManager.this.deviceFeatureInfoResultCallBackMap.remove(msgKey);
                }
            }
        });
    }

    @Override
    public void onSearchRecordResult(final SearchRecordResultInfo msgInfo) {
        Log.d((String)TAG, (String)("onSearchRecordResult: " + msgInfo));
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                String msgKey = "RecordByTime_" + msgInfo.seqId;
                EzLinkManager.this.xlog("EzLinkManager: msgKey: " + msgKey);
                EzLinkManager.this.xlog("EzLinkManager: searchRecordResultCallBackMap: " + EzLinkManager.this.searchRecordResultCallBackMap);
                OnSearchRecordResultCallBack tmpCallback = (OnSearchRecordResultCallBack)EzLinkManager.this.searchRecordResultCallBackMap.get(msgKey);
                if (tmpCallback != null) {
                    tmpCallback.onSearchRecordResult(0, null);
                    EzLinkManager.this.searchRecordResultCallBackMap.remove(msgKey);
                }
            }
        });
    }

    @Override
    public void onSearchRecordByMonthResult(final SearchRecordByMonthResultInfo msgInfo) {
        Log.d((String)TAG, (String)("onSearchRecordByMonthResult: " + msgInfo));
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                String msgKey = "" + msgInfo.searchYear + "_" + msgInfo.searchMonth + "_" + msgInfo.seqId;
                EzLinkManager.this.xlog("EzLinkManager: msgKey: " + msgKey);
                EzLinkManager.this.xlog("EzLinkManager: searchRecordByMonthResultCallBackMap: " + EzLinkManager.this.searchRecordByMonthResultCallBackMap);
                OnSearchRecordByMonthResultCallBack callBack = (OnSearchRecordByMonthResultCallBack)EzLinkManager.this.searchRecordByMonthResultCallBackMap.get(msgKey);
                if (callBack != null) {
                    callBack.onSearchRecordByMonthResult(0, msgInfo);
                    EzLinkManager.this.searchRecordByMonthResultCallBackMap.remove(msgKey);
                }
            }
        });
    }

    public void updateTopology() {
        this.singleThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EzLinkManager.this.requestTopology();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void registerStatusChangeCallBack(DeviceStateChangeCallBack callBack) {
        this.statusChangeCallBackMap.put(callBack, this);
    }

    private native int initEzLink(String var1, String var2, String var3, String var4, String var5);

    private native int openDebugLog();

    private native int requestTopology();

    private native int initEzLinkPair();

    private native int startEzLinkPairQuery();

    private native int doEzLinkPair(String var1, String var2, String var3, String var4);

    private native int unBindEzLink(String var1);

    private native int getDeviceFeatureInfo(String var1);

    private native int sendMsg(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, int var9, int var10, String var11);

    private native int sendMsgBeforePair(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, int var10, int var11, String var12);

    private native int releaseEzLinkPair();

    private native int releaseEzLink();

    private native int initStreamModule();

    private native int searchRecordsByTime(String var1, String var2, String var3);

    private native int searchRecordsByMonth(String var1, int var2, int var3);

    private native int isDeviceWeakup(String var1, String var2);

    private native void xlog(String var1);

    public static interface DeviceStateChangeCallBack {
        public void onDeviceStateChanged(List<PairDeviceInfo> var1);
    }

    public static interface OnSearchRecordByMonthResultCallBack {
        public void onSearchRecordByMonthResult(int var1, SearchRecordByMonthResultInfo var2);
    }

    public static interface OnSearchRecordResultCallBack {
        public void onSearchRecordResult(int var1, SearchRecordResultInfo var2);
    }

    public static interface OnDeviceFeatureInfoCallBack {
        public void onDeviceFeatureInfoResult(int var1, FeatureConfigInfo var2);
    }

    public static interface OnMessageResultCallBack {
        public void onMessageResult(int var1, OtapMessageInfo var2);
    }

    public static interface UnPairDeviceResultCallBack {
        public void onUnPairDeviceResult(boolean var1);
    }

    public static interface PairDeviceResultCallBack {
        public void onPairDeviceResult(int var1, PairDeviceInfo var2);
    }

    public static interface PairDeviceListCallBack {
        public void onQueryPairDeviceChanged(List<PairDeviceInfo> var1);
    }
}

