/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.sdk.configwifi.touchAp;

import android.app.Application;
import android.content.Context;
import com.ezviz.http.bean.request.ConfigNewApRequest;
import com.ezviz.http.bean.resp.GetDeviceWifiListResp;
import com.ezviz.http.bean.resp.GetTokenResp;
import com.ezviz.http.bean.resp.NewApConfigResp;
import com.ezviz.http.core.EzvizCallback;
import com.ezviz.http.core.EzvizHttpClient;
import com.ezviz.http.exception.EzConfigWifiException;
import com.ezviz.http.model.AccessDeviceInfo;
import com.ezviz.http.model.EzWifiInfo;
import com.ezviz.sdk.configwifi.Config;
import com.ezviz.sdk.configwifi.EZConfigWifiErrorEnum;
import com.ezviz.sdk.configwifi.common.LogUtil;
import com.ezviz.sdk.configwifi.touchAp.GetAccessDeviceInfoCallback;
import com.ezviz.sdk.configwifi.touchAp.GetDeviceWifiListCallback;
import com.ezviz.sdk.configwifi.touchAp.GetTokenCallback;
import com.ezviz.sdk.configwifi.touchAp.QueryPlatformBindStatusCallback;
import com.ezviz.sdk.configwifi.touchAp.StartNewApConfigCallback;
import com.ezviz.utils.JsonUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TouchApApi {
    private static TouchApApi mTouchApApi;
    private static EzvizHttpClient mEzvizHttpClient;
    public static String TAG;
    public static String devRouteDomain;
    public static String responseData;

    private TouchApApi(Application application) {
        mEzvizHttpClient = new EzvizHttpClient((Context)application);
        devRouteDomain = "http:/192.168.4.1:80";
    }

    public static synchronized void init(Application application) {
        if (mTouchApApi == null) {
            mTouchApApi = new TouchApApi(application);
        }
    }

    private static String commonParameter(Map<String, Object> map) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, Object>> en = map.entrySet();
        for (Map.Entry<String, Object> entry : en) {
            sb.append("&");
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    public static void getToken(String accessToken, Map<String, Object> map, final GetTokenCallback callback) {
        String baseUrl = Config.baseUrl + "/api/route/userdevice/v3/userdevices/sdk/token?accessToken=" + accessToken;
        if (map != null && map.size() > 0) {
            baseUrl = baseUrl + TouchApApi.commonParameter(map);
        }
        final String url = baseUrl;
        LogUtil.d(TAG, "Request  >>>  " + url);
        Request.Builder requestBuilder = new Request.Builder().url(url).get();
        mEzvizHttpClient.ezEnqueue(requestBuilder.build(), new EzvizCallback(){

            @Override
            public void onSuccess(String data) {
                LogUtil.d(TAG, "Response <<<  " + url + "\n" + data);
                responseData = data;
                GetTokenResp getTokenResp = JsonUtils.fromJson(data, GetTokenResp.class);
                callback.onSuccess(getTokenResp.deviceTokenInfo);
            }

            @Override
            public void onException(EzConfigWifiException ezOpenException) {
                callback.onError(ezOpenException);
            }
        });
    }

    public static void queryPlatformBindStatus(String accessToken, String deviceSerial, Map<String, Object> map, final QueryPlatformBindStatusCallback callback) {
        String baseUrl = Config.baseUrl + "/api/route/userdevice/v3/devices/bind/" + deviceSerial + "?accessToken=" + accessToken;
        if (map != null && map.size() > 0) {
            baseUrl = baseUrl + TouchApApi.commonParameter(map);
        }
        final String url = baseUrl;
        LogUtil.d(TAG, "Request  >>>  " + url);
        Request.Builder requestBuilder = new Request.Builder().url(url).get();
        mEzvizHttpClient.ezEnqueue(requestBuilder.build(), new EzvizCallback(){

            @Override
            public void onSuccess(String data) {
                LogUtil.d(TAG, "Response <<<  " + url + "\n" + data);
                responseData = data;
                callback.onSuccess(true);
            }

            @Override
            public void onException(EzConfigWifiException ezOpenException) {
                ezOpenException.printStackTrace();
                callback.onError(ezOpenException);
            }
        });
    }

    public static void getAccessDeviceInfo(final GetAccessDeviceInfoCallback callback) {
        final String url = devRouteDomain + "/AccessDevInfo?format=json";
        LogUtil.d(TAG, "Request  >>>  " + url);
        Request.Builder requestBuilder = new Request.Builder().url(url).get();
        mEzvizHttpClient.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                callback.onError(new EzConfigWifiException(EZConfigWifiErrorEnum.NETWORK_EXCEPTION.code, e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
                responseData = response.body().string();
                LogUtil.d(TAG, "Response <<<  " + url + "\n" + responseData);
                if (response.isSuccessful()) {
                    AccessDeviceInfo accessDeviceInfo = JsonUtils.fromJson(responseData, AccessDeviceInfo.class);
                    callback.onSuccess(accessDeviceInfo);
                } else {
                    callback.onError(new EzConfigWifiException(response.code(), "server exception"));
                }
            }
        });
    }

    public static void getAccessDeviceWifiList(final GetDeviceWifiListCallback callback) {
        final String url = devRouteDomain + "/PreNetwork/SecurityAndAccessPoint?format=json";
        LogUtil.d(TAG, "Request  >>>  " + url);
        Request.Builder requestBuilder = new Request.Builder().url(url).get();
        mEzvizHttpClient.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                callback.onError(new EzConfigWifiException(EZConfigWifiErrorEnum.NETWORK_EXCEPTION.code, e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
                responseData = response.body().string();
                LogUtil.d(TAG, "Response <<<  " + url + "\n" + responseData);
                if (response.isSuccessful()) {
                    GetDeviceWifiListResp getDeviceWifiListResp = JsonUtils.fromJson(responseData, GetDeviceWifiListResp.class);
                    List<EzWifiInfo> ezWifiInfoList = getDeviceWifiListResp.ezWifiInfoList;
                    callback.onSuccess(ezWifiInfoList);
                } else {
                    callback.onError(new EzConfigWifiException(response.code(), "server exception"));
                }
            }
        });
    }

    public static void startNewApConfigWithToken(String token, String ssid, String password, String lbsDomain, final StartNewApConfigCallback callback) {
        final String url = devRouteDomain + "/PreNetwork/WifiConfig?format=json";
        ConfigNewApRequest.WifiInfo wifiInfo = new ConfigNewApRequest.WifiInfo();
        wifiInfo.ssid = ssid;
        wifiInfo.password = password;
        ConfigNewApRequest request = new ConfigNewApRequest();
        request.token = token;
        request.lbsDomain = lbsDomain;
        request.ezWifiInfo = wifiInfo;
        String postBody = JsonUtils.toJson(request);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)postBody);
        Request requestBuilder = new Request.Builder().url(url).put(requestBody).build();
        LogUtil.d(TAG, "Request  >>>  " + url + "\n" + postBody);
        mEzvizHttpClient.newCall(requestBuilder).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                callback.onError(new EzConfigWifiException(EZConfigWifiErrorEnum.NETWORK_EXCEPTION.code, e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
                responseData = response.body().string();
                LogUtil.d(TAG, "Response <<<  " + url + "\n" + responseData);
                if (response.isSuccessful()) {
                    NewApConfigResp newApConfigResp = JsonUtils.fromJson(responseData, NewApConfigResp.class);
                    callback.onResponse(newApConfigResp.statusCode, newApConfigResp.statusDesc);
                } else {
                    callback.onError(new EzConfigWifiException(response.code(), "server exception"));
                }
            }
        });
    }

    public static void setDevRouteDomain(String domain) {
        devRouteDomain = domain;
    }

    static {
        TAG = "TouchApApi";
    }
}

