/*
 * Decompiled with CFR 0.152.
 */
package com.mediaplayer.audio;

import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AutomaticGainControl;
import android.os.Build;
import android.util.Log;
import com.mediaplayer.audio.AudioCodec;
import com.mediaplayer.audio.AudioCodecParam;
import com.mediaplayer.audio.AudioEngineCallBack;
import java.io.FileOutputStream;

class AudioRecoder
implements AudioRecord.OnRecordPositionUpdateListener {
    private final String TAG = "AudioRecoder";
    private final int CHANNEL_CONFIG = 2;
    private final int AUDIO_FORMAT = 2;
    private final int RECORD_STATUS_START = 0;
    private final int RECORD_STATUS_STOP = 1;
    private final int RECORD_STATUS_RELEASE = 2;
    private AudioEngineCallBack.RecordDataCallBack mDataCallBack = null;
    private AudioEngineCallBack.CaptureDataCallBack mCapDataCallBack = null;
    private byte[] mAudioBuffer = null;
    private int mAudioBufferDataLen = 0;
    private byte[] mEncOutBuffer = null;
    private byte[] mMuxOutBuffer = null;
    private int mMic = 1;
    private int mSampleRateInHz = 8000;
    private int mCodecType = 0;
    private int mPeriodInFrames = this.mSampleRateInHz / 25 * 1;
    private int mBuffLen = this.mPeriodInFrames * 2;
    private int mEncOutBufferSize = 4096;
    private int mRecordState = 2;
    private int mReadDataLen = this.mSampleRateInHz * 16 * 2 / 1000;
    private AudioCodec mAudioCodec = null;
    private AudioRecord mAudioRecorder = null;
    private int mMinBufferSize = 0;
    private static int mID = 0;
    private AcousticEchoCanceler mAec = null;
    private AutomaticGainControl mAgc = null;
    private boolean mIntercomType = true;
    private Thread mRecordThread = null;
    private volatile boolean mIsThreadExit = false;
    private FileOutputStream mCaptrueFile = null;
    private boolean mbIsWrite = false;
    private int mAECTYpe = 1;
    private String mAddr = "/sdcard/";
    private FileOutputStream test = null;
    private boolean mbRecordDataFromOut = false;

    public AudioRecoder(AudioCodec audioCodec) {
        this.mAudioCodec = audioCodec;
    }

    public void setRecordIntercomType(boolean bFlag) {
        this.mIntercomType = bFlag;
    }

    public void setAudioPlayParam(AudioCodecParam param) {
        this.mSampleRateInHz = param.nSampleRate;
        this.mCodecType = param.nCodecType;
    }

    public static int getSessionID() {
        return mID;
    }

    public int startRecord(int audioType) {
        if (this.mRecordState == 0) {
            return -2147483628;
        }
        if (this.mbRecordDataFromOut) {
            return -2147483644;
        }
        int nRet = 0;
        try {
            if (this.mRecordState == 2) {
                this.mMinBufferSize = AudioRecord.getMinBufferSize((int)this.mSampleRateInHz, (int)2, (int)2);
                if (this.mAECTYpe == 1 && this.mIntercomType) {
                    this.mAudioRecorder = new AudioRecord(7, this.mSampleRateInHz, 2, 2, this.mMinBufferSize);
                    if (null == this.mAudioRecorder) {
                        return Integer.MIN_VALUE;
                    }
                    if (Build.VERSION.SDK_INT >= 16) {
                        mID = this.mAudioRecorder.getAudioSessionId();
                        if (AcousticEchoCanceler.isAvailable()) {
                            this.mAec = AcousticEchoCanceler.create((int)mID);
                            if (this.mAec != null) {
                                this.mAec.setEnabled(true);
                            }
                        }
                        if (AutomaticGainControl.isAvailable()) {
                            this.mAgc = AutomaticGainControl.create((int)mID);
                            if (this.mAgc != null) {
                                this.mAgc.setEnabled(true);
                            }
                        }
                    } else {
                        mID = -1;
                    }
                } else {
                    this.mAudioRecorder = new AudioRecord(this.mMic, this.mSampleRateInHz, 2, 2, this.mMinBufferSize);
                    if (null == this.mAudioRecorder) {
                        return Integer.MIN_VALUE;
                    }
                }
                if (this.mAudioRecorder.getState() == 0) {
                    Log.i((String)"AudioRecoder", (String)"AudioRecord STATE_UNINITIALIZED");
                    return Integer.MIN_VALUE;
                }
                nRet = this.initRecord();
                if (nRet != 0) {
                    return nRet;
                }
            }
            this.mAudioRecorder.startRecording();
        }
        catch (Exception e) {
            Log.i((String)"AudioRecoder", (String)("AudioRecord record exception: " + e.toString()));
            this.mAudioRecorder = null;
            return -2147483632;
        }
        this.mRecordState = 0;
        if (this.mAudioRecorder.getRecordingState() != 3) {
            this.closeRecord();
            Log.e((String)"AudioRecoder", (String)"AudioRecord RECORDSTATE_STOPPED");
            return -2147483632;
        }
        this.createRecordThread();
        return 0;
    }

    private synchronized int clearThread() {
        this.mIsThreadExit = true;
        Log.i((String)"AudioRecoder", (String)"clearThread");
        if (null != this.mRecordThread) {
            try {
                this.mRecordThread.interrupt();
                this.mRecordThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mRecordThread = null;
            Log.i((String)"AudioRecoder", (String)"record thread exit ok");
        }
        return 0;
    }

    public synchronized int stopRecord() {
        if (this.mRecordState != 0) {
            return -2147483628;
        }
        Log.i((String)"AudioRecoder", (String)"stop record");
        this.clearThread();
        if (null != this.mAudioRecorder) {
            this.mAudioRecorder.stop();
        }
        this.mIsThreadExit = false;
        this.mRecordState = 1;
        Log.i((String)"AudioRecoder", (String)"stop record ok");
        return 0;
    }

    public synchronized int closeRecord() {
        if (this.mRecordState == 2) {
            return -2147483646;
        }
        if (null != this.mAudioRecorder) {
            this.mAudioRecorder.stop();
            this.mAudioRecorder.release();
            this.mAudioRecorder = null;
        }
        if (this.mAec != null) {
            this.mAec.release();
            this.mAec = null;
        }
        if (this.mAgc != null) {
            this.mAgc.release();
            this.mAgc = null;
        }
        this.clearThread();
        this.mIsThreadExit = false;
        this.mDataCallBack = null;
        this.mEncOutBuffer = null;
        this.mMuxOutBuffer = null;
        Log.i((String)"AudioRecoder", (String)"close record");
        this.mRecordState = 2;
        this.mIntercomType = true;
        return 0;
    }

    public void onMarkerReached(AudioRecord recorder) {
    }

    public synchronized void onPeriodicNotification(AudioRecord recorder) {
    }

    public synchronized void setAudioDataCallBack(AudioEngineCallBack.RecordDataCallBack dataCbf) {
        this.mDataCallBack = dataCbf;
    }

    public synchronized void setAudioDataCallBack(AudioEngineCallBack.CaptureDataCallBack dataCbf) {
        this.mCapDataCallBack = dataCbf;
    }

    protected boolean initAudioFormat(int audioType) {
        if (this.mAECTYpe == 1) {
            int recordOutSize;
            this.mBuffLen = recordOutSize = 320;
            this.mPeriodInFrames = this.mBuffLen / 2;
            this.mEncOutBufferSize = recordOutSize;
            if (6 == audioType || 5 == audioType || 10 == audioType) {
                this.mEncOutBufferSize = 2048;
                this.mBuffLen = 640;
                this.mPeriodInFrames = this.mBuffLen / 2;
            } else if (9 == audioType) {
                this.mEncOutBufferSize = 1280;
                this.mBuffLen = this.mSampleRateInHz / 50;
                this.mPeriodInFrames = this.mBuffLen / 2;
            }
            this.mReadDataLen = this.mBuffLen;
        } else if (this.mSampleRateInHz == 8000 || this.mSampleRateInHz == 16000 || this.mSampleRateInHz == 32000 || this.mSampleRateInHz == 48000) {
            this.mBuffLen = this.mSampleRateInHz / 1000 * 2 * 16;
            this.mPeriodInFrames = this.mBuffLen / 2;
            this.mReadDataLen = this.mBuffLen;
        } else {
            this.mBuffLen = 320;
            this.mPeriodInFrames = this.mBuffLen / 2;
            this.mReadDataLen = this.mBuffLen;
        }
        return true;
    }

    public int setAECType(int nType) {
        if (this.mRecordState == 0) {
            return -2147483628;
        }
        this.mAECTYpe = nType;
        return 0;
    }

    public void setWriteFile(boolean bIsWrite) {
        this.mbIsWrite = bIsWrite;
    }

    public void setWriteFileEx(boolean bIsWrite, String sAddr) {
        this.mbIsWrite = bIsWrite;
        this.mAddr = sAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inputRecordData(byte[] recordData, int nDataLen) {
        if (nDataLen <= 0 || recordData == null) {
            return -2147483645;
        }
        if (!this.mbRecordDataFromOut) {
            if (this.mRecordState == 0) {
                return -2147483644;
            }
            int nRet = this.initRecord();
            if (nRet != 0) {
                return nRet;
            }
            this.mBuffLen = 0x100000;
            this.mbRecordDataFromOut = true;
            this.mRecordState = 0;
        }
        byte[] byArray = this.mAudioBuffer;
        synchronized (this.mAudioBuffer) {
            if (this.mAudioBufferDataLen + nDataLen > this.mAudioBuffer.length) {
                byte[] tempBuffer = new byte[this.mAudioBufferDataLen];
                System.arraycopy(this.mAudioBuffer, 0, tempBuffer, 0, this.mAudioBufferDataLen);
                this.mAudioBuffer = new byte[this.mAudioBufferDataLen + nDataLen];
                System.arraycopy(tempBuffer, 0, this.mAudioBuffer, 0, this.mAudioBufferDataLen);
            }
            System.arraycopy(recordData, 0, this.mAudioBuffer, this.mAudioBufferDataLen, nDataLen);
            this.mAudioBufferDataLen += nDataLen;
            try {
                if (null == this.test) {
                    this.test = new FileOutputStream("/sdcard/AudioEngine_inputRecordData.pcm");
                }
                this.test.write(recordData, 0, nDataLen);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mRecordThread == null) {
                this.mRecordState = 0;
                this.createRecordThread();
            }
            return 0;
        }
    }

    private void createRecordThread() {
        if (this.mRecordThread == null && this.mRecordState == 0) {
            this.mRecordThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!AudioRecoder.this.mIsThreadExit) {
                        if (null != AudioRecoder.this.mAudioRecorder || AudioRecoder.this.mbRecordDataFromOut) {
                            if (null != AudioRecoder.this.mAudioRecorder && !AudioRecoder.this.mbRecordDataFromOut) {
                                AudioRecoder.this.mAudioBufferDataLen = AudioRecoder.this.mAudioRecorder.read(AudioRecoder.this.mAudioBuffer, 0, AudioRecoder.this.mAudioBuffer.length);
                            }
                            while (AudioRecoder.this.mAudioBufferDataLen >= AudioRecoder.this.mReadDataLen && !AudioRecoder.this.mIsThreadExit) {
                                byte[] byArray = AudioRecoder.this.mAudioBuffer;
                                synchronized (byArray) {
                                    int nRet;
                                    if (AudioRecoder.this.mCapDataCallBack != null) {
                                        AudioRecoder.this.mCapDataCallBack.onCaptureDataCallBack(AudioRecoder.this.mAudioBuffer, AudioRecoder.this.mReadDataLen);
                                    }
                                    if ((nRet = AudioRecoder.this.mAudioCodec.preAudioData(AudioRecoder.this.mAudioBuffer, AudioRecoder.this.mReadDataLen)) != 0) {
                                        Log.e((String)"AudioRecoder", (String)("preAudioData return err: " + nRet));
                                        break;
                                    }
                                    int encOutSize = AudioRecoder.this.mAudioCodec.encodeAudioData(AudioRecoder.this.mEncOutBuffer);
                                    if (encOutSize > 0 && AudioRecoder.this.mDataCallBack != null) {
                                        AudioRecoder.this.mDataCallBack.onRecordDataCallBack(AudioRecoder.this.mEncOutBuffer, encOutSize);
                                    }
                                    AudioRecoder.this.mAudioBufferDataLen = AudioRecoder.this.mAudioBufferDataLen - AudioRecoder.this.mReadDataLen;
                                    if (AudioRecoder.this.mAudioBufferDataLen <= 0) {
                                        break;
                                    }
                                    System.arraycopy(AudioRecoder.this.mAudioBuffer, AudioRecoder.this.mReadDataLen, AudioRecoder.this.mAudioBuffer, 0, AudioRecoder.this.mAudioBufferDataLen);
                                }
                            }
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        Log.i((String)"AudioRecoder", (String)"record obj is null");
                    }
                    Log.i((String)"AudioRecoder", (String)"RecordThread exit");
                }
            });
            this.mRecordThread.start();
            this.mRecordThread.setName("AudioEngine_RecordThread");
        }
    }

    private int initRecord() {
        int nRet;
        this.initAudioFormat(this.mCodecType);
        if (this.mAudioBuffer == null) {
            this.mAudioBuffer = new byte[this.mBuffLen];
            if (null == this.mAudioBuffer) {
                return -2147483646;
            }
        }
        if ((nRet = this.mAudioCodec.openAudioEncoder(this.mCodecType)) != 0) {
            return nRet;
        }
        this.mEncOutBuffer = new byte[this.mEncOutBufferSize];
        if (null == this.mEncOutBuffer) {
            this.mEncOutBuffer = null;
            return -2147483646;
        }
        this.mMuxOutBuffer = new byte[3072];
        if (null == this.mMuxOutBuffer) {
            this.mMuxOutBuffer = null;
            return -2147483646;
        }
        return 0;
    }

    public int changeOutputBitrate(int nBitrate) {
        if (this.mRecordState != 0 || this.mAudioCodec == null) {
            return -2147483628;
        }
        return this.mAudioCodec.changeOutputBitrate(nBitrate);
    }
}

