/*
 * Decompiled with CFR 0.152.
 */
package com.mediaplayer.audio;

import android.media.AudioTrack;
import android.util.Log;
import com.mediaplayer.audio.AudioCodec;
import com.mediaplayer.audio.AudioCodecParam;
import com.mediaplayer.audio.AudioEngineCallBack;
import com.mediaplayer.audio.AudioRecoder;
import java.io.FileOutputStream;
import java.io.IOException;

class AudioPlayer {
    private final String TAG = "AudioPlayer";
    private AudioTrack mAudioPlayer = null;
    private AudioCodec mAudioCodec = null;
    private AudioEngineCallBack.PlayDataCallBack mDataCallBack = null;
    private byte[] mDecOutBuffer = null;
    private byte[] mDataBuffer = null;
    private byte[] mPCMDataBuffer = null;
    private byte[] mDecInBuffer = null;
    private final int CHANNEL_CONFIG = 2;
    private final int AUDIO_FORMAT = 2;
    private final int ADTS_LENGTH = 7;
    private final int PLAY_STATUS_START = 0;
    private final int PLAY_STATUS_STOP = 1;
    private final int PLAY_STATUS_RELEASE = 2;
    private int mAudioType = 1;
    private int mSampleRateInHz = 8000;
    private int mDataBufferSize = 102400;
    private int mPCMDataBufferSize = 102400;
    private int mDecInBufferSize = 320;
    private int mDataBufferOffset = 0;
    private int mPCMDataBufferOffset = 0;
    private int mDecOutSize = 4096;
    private int mPlayBufferSize = 0;
    private int mPlayState = 2;
    private boolean mIntercomType = true;
    private Thread mPlayThread = null;
    private volatile boolean mIsThreadExit = false;
    private volatile boolean mStartWritePCM = false;
    private int mMinBufferSize = 0;
    private int mInputLen = 320;
    private int mInputInterval = 100;
    private boolean mbIsWrite = false;
    private FileOutputStream mInputFile = null;
    private FileOutputStream mAudioTrack = null;
    private int mAECTYpe = 1;
    private String msAddr = "/sdcard/";

    public AudioPlayer(AudioCodec audioCodec) {
        this.mAudioCodec = audioCodec;
    }

    public int startPlay(int audioType) {
        if (this.mPlayState == 0) {
            return -2147483628;
        }
        if (this.mPlayState == 2) {
            this.initAudioFormat(audioType);
            int nRet = this.mAudioCodec.openAudioDecoder(audioType);
            if (nRet != 0) {
                return nRet;
            }
            this.mPlayBufferSize = this.mMinBufferSize = AudioTrack.getMinBufferSize((int)this.mSampleRateInHz, (int)2, (int)2);
            if (this.mAudioType == 0) {
                this.mDataBufferSize = 100 * this.mMinBufferSize;
                this.mPlayBufferSize = 4 * this.mMinBufferSize;
                this.mInputLen = this.mSampleRateInHz * 2 / this.mInputInterval;
                if (this.mDecOutSize < this.mInputLen) {
                    this.mDecOutSize = 2 * this.mInputLen;
                }
            }
            if (this.mAudioType == 6) {
                this.mInputLen = 2048;
            }
            this.mDecInBuffer = new byte[this.mDecInBufferSize];
            this.mDecOutBuffer = new byte[this.mDecOutSize];
            this.mDataBuffer = new byte[this.mDataBufferSize];
            if (this.mDecInBuffer == null || this.mDecOutBuffer == null || this.mDataBuffer == null) {
                return -2147483646;
            }
            this.mPCMDataBuffer = new byte[this.mPCMDataBufferSize];
            if (this.mPCMDataBuffer == null) {
                return -2147483646;
            }
            try {
                if (this.mAECTYpe == 1) {
                    int nID = AudioRecoder.getSessionID();
                    if (nID == -1) {
                        Log.i((String)"AudioPlayer", (String)"startPlay: new track id = -1,no id");
                        this.mAudioPlayer = new AudioTrack(0, this.mSampleRateInHz, 2, 2, this.mPlayBufferSize, 1);
                    } else {
                        Log.i((String)"AudioPlayer", (String)"startPlay: new track with id");
                        this.mAudioPlayer = new AudioTrack(0, this.mSampleRateInHz, 2, 2, this.mPlayBufferSize, 1, nID);
                    }
                } else {
                    Log.i((String)"AudioPlayer", (String)"startPlay: new track with no id");
                    this.mAudioPlayer = new AudioTrack(3, this.mSampleRateInHz, 2, 2, this.mPlayBufferSize, 1);
                }
            }
            catch (IllegalArgumentException e) {
                Log.i((String)"AudioPlayer", (String)("new AudioTrack exception: " + e.toString()));
                return Integer.MIN_VALUE;
            }
        }
        try {
            this.mAudioPlayer.play();
        }
        catch (IllegalStateException e) {
            Log.i((String)"AudioPlayer", (String)("AudioTrack play exception: " + e.toString()));
            this.mAudioPlayer = null;
            return -2147483639;
        }
        this.mPlayState = 0;
        if (this.mPlayThread == null) {
            this.mPlayThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!AudioPlayer.this.mIsThreadExit) {
                        if (!AudioPlayer.this.mStartWritePCM && AudioPlayer.this.mPCMDataBufferOffset > AudioPlayer.this.mPlayBufferSize) {
                            AudioPlayer.this.mStartWritePCM = true;
                        }
                        if (AudioPlayer.this.mPCMDataBufferOffset >= AudioPlayer.this.mInputLen && AudioPlayer.this.mStartWritePCM) {
                            AudioPlayer.this.writeTrack(AudioPlayer.this.mPCMDataBuffer, AudioPlayer.this.mInputLen);
                            continue;
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            this.mPlayThread.start();
            this.mPlayThread.setName("AudioEngine_PlayThread");
        }
        return 0;
    }

    private int clearThread() {
        this.mIsThreadExit = true;
        if (this.mPlayThread != null) {
            try {
                this.mPlayThread.interrupt();
                this.mPlayThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mPlayThread = null;
            Log.i((String)"AudioPlayer", (String)"play thread exit ok");
        }
        return 0;
    }

    public synchronized int stopPlay() {
        if (this.mPlayState != 0) {
            return -2147483628;
        }
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.pause();
            this.mAudioPlayer.flush();
        }
        Log.e((String)"AudioPlayer", (String)"stopPlay: stop player");
        this.clearThread();
        this.mStartWritePCM = false;
        this.mIsThreadExit = false;
        this.mDataBufferOffset = 0;
        this.mPCMDataBufferOffset = 0;
        this.mPlayState = 1;
        return 0;
    }

    public synchronized int closePlay() {
        if (this.mPlayState == 2) {
            return -2147483644;
        }
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.flush();
            this.mAudioPlayer.stop();
            this.mAudioPlayer.release();
            this.mAudioPlayer = null;
        }
        this.clearThread();
        this.mDataCallBack = null;
        this.mDecOutBuffer = null;
        this.mDecInBuffer = null;
        this.mDataBuffer = null;
        this.mPCMDataBuffer = null;
        this.mDataBufferOffset = 0;
        this.mPCMDataBufferOffset = 0;
        this.mIsThreadExit = false;
        this.mPlayState = 2;
        this.mIntercomType = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeTrack(byte[] audioData, int len) {
        int nRet;
        if (this.mPlayState != 0) {
            return -2147483628;
        }
        if (audioData == null || len <= 0) {
            return -2147483645;
        }
        if (this.mbIsWrite) {
            try {
                if (this.mAudioTrack == null) {
                    this.mAudioTrack = new FileOutputStream(this.msAddr + "AudioEngine_audiotrack.data");
                }
                if (this.mAudioTrack != null) {
                    this.mAudioTrack.write(audioData, 0, len);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((nRet = this.mAudioPlayer.write(audioData, 0, len)) < 0) {
            this.mPCMDataBufferOffset = 0;
            return -2147483640;
        }
        byte[] byArray = this.mPCMDataBuffer;
        synchronized (this.mPCMDataBuffer) {
            this.mPCMDataBufferOffset -= nRet;
            if (this.mPCMDataBufferOffset >= 0) {
                System.arraycopy(this.mPCMDataBuffer, nRet, this.mPCMDataBuffer, 0, this.mPCMDataBufferOffset);
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return nRet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int inputData(byte[] audioData, int len, boolean bFlag) {
        int decOutSize;
        int iFrames;
        if (this.mPlayState != 0) {
            return -2147483628;
        }
        if (len <= 0) return -2147483645;
        if (audioData == null) {
            return -2147483645;
        }
        if (this.mbIsWrite) {
            try {
                if (this.mInputFile == null) {
                    this.mInputFile = new FileOutputStream(this.msAddr + "AudioEngine_input.data");
                }
                if (this.mInputFile != null) {
                    this.mInputFile.write(audioData, 0, len);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.mDataBufferOffset + len > this.mDataBuffer.length) {
            Log.e((String)"AudioPlayer", (String)"input data buffer over");
            return -2147483631;
        }
        if (this.mDataBufferOffset >= 0) {
            System.arraycopy(audioData, 0, this.mDataBuffer, this.mDataBufferOffset, len);
        }
        this.mDataBufferOffset += len;
        if (this.mAudioType != 6) {
            if (this.mAudioType == 0) {
                int decOutSize2 = this.mAudioCodec.decodeAudioData(this.mDataBuffer, len, this.mDecOutBuffer);
                if (decOutSize2 < 0) {
                    this.mDataBufferOffset = 0;
                    return -2147483640;
                }
                if (!bFlag) {
                    if (this.mPCMDataBufferOffset + decOutSize2 > this.mPCMDataBuffer.length) {
                        Log.e((String)"AudioPlayer", (String)"input pcm buffer overflow");
                        return -2147483631;
                    }
                    byte[] i = this.mPCMDataBuffer;
                    // MONITORENTER : this.mPCMDataBuffer
                    if (this.mPCMDataBufferOffset >= 0) {
                        System.arraycopy(this.mDecOutBuffer, 0, this.mPCMDataBuffer, this.mPCMDataBufferOffset, decOutSize2);
                    }
                    this.mPCMDataBufferOffset += decOutSize2;
                    // MONITOREXIT : i
                }
                this.mDataBufferOffset -= len;
                if (this.mDataBufferOffset >= 0) {
                    System.arraycopy(this.mDataBuffer, len, this.mDataBuffer, 0, this.mDataBufferOffset);
                    return 0;
                }
                this.mDataBufferOffset = 0;
                return 0;
            }
            if (this.mAudioType == 5 || this.mAudioType == 9 || this.mAudioType == 10) {
                int decOutSize3 = this.mAudioCodec.decodeAudioData(this.mDataBuffer, len, this.mDecOutBuffer);
                if (decOutSize3 < 0) {
                    this.mDataBufferOffset = 0;
                    return -2147483640;
                }
                if (this.mDataCallBack != null) {
                    this.mDataCallBack.onPlayDataCallBack(this.mDecOutBuffer, decOutSize3);
                }
                if (this.mPCMDataBufferOffset + decOutSize3 > this.mPCMDataBuffer.length) {
                    Log.e((String)"AudioPlayer", (String)"inputData: pcm buffer overflow");
                    return -2147483631;
                }
                byte[] i = this.mPCMDataBuffer;
                // MONITORENTER : this.mPCMDataBuffer
                if (this.mPCMDataBufferOffset >= 0) {
                    System.arraycopy(this.mDecOutBuffer, 0, this.mPCMDataBuffer, this.mPCMDataBufferOffset, decOutSize3);
                }
                this.mPCMDataBufferOffset += decOutSize3;
                // MONITOREXIT : i
                this.mDataBufferOffset -= len;
                if (this.mDataBufferOffset >= 0) {
                    System.arraycopy(this.mDataBuffer, len, this.mDataBuffer, 0, this.mDataBufferOffset);
                    return 0;
                }
                this.mDataBufferOffset = 0;
                return 0;
            }
            iFrames = this.mDataBufferOffset / this.mDecInBufferSize;
        } else {
            int decSize = 0;
            while (this.mDataBufferOffset >= 7 && this.mPlayState == 0) {
                int i;
                for (i = decSize; i < this.mDataBufferOffset - 2 && (this.mDataBuffer[i] != -1 || this.mDataBuffer[i + 1] != -7 && this.mDataBuffer[i + 1] != -15); ++i) {
                }
                if (i == this.mDataBufferOffset - 2) {
                    this.mDataBufferOffset = 0;
                    break;
                }
                this.mDataBufferOffset = this.mDataBufferOffset + decSize - i;
                decSize = i;
                int procSize = (this.mDataBuffer[decSize + 3] & 3) << 11 | this.mDataBuffer[decSize + 4] << 3 | (this.mDataBuffer[decSize + 5] & 0xE0) >> 5;
                if (procSize < 7) return -2147483630;
                if (procSize > this.mDecInBufferSize) {
                    return -2147483630;
                }
                if (procSize > this.mDataBufferOffset) {
                    Log.e((String)"AudioPlayer", (String)"procSize buffer over");
                    break;
                }
                System.arraycopy(this.mDataBuffer, decSize, this.mDecInBuffer, 0, procSize);
                int decOutSize4 = this.mAudioCodec.decodeAudioData(this.mDecInBuffer, procSize, this.mDecOutBuffer);
                if (decOutSize4 < 0) {
                    this.mDataBufferOffset = 0;
                    return -2147483640;
                }
                if (this.mDataCallBack != null && decOutSize4 > 0) {
                    this.mDataCallBack.onPlayDataCallBack(this.mDecOutBuffer, decOutSize4);
                }
                if (this.mPCMDataBufferOffset + decOutSize4 > this.mPCMDataBuffer.length) {
                    Log.e((String)"AudioPlayer", (String)"inputData: aac pcm buffer overflow");
                    return -2147483631;
                }
                byte[] byArray = this.mPCMDataBuffer;
                // MONITORENTER : this.mPCMDataBuffer
                if (this.mPCMDataBufferOffset >= 0) {
                    System.arraycopy(this.mDecOutBuffer, 0, this.mPCMDataBuffer, this.mPCMDataBufferOffset, decOutSize4);
                }
                this.mPCMDataBufferOffset += decOutSize4;
                // MONITOREXIT : byArray
                decSize += procSize;
                this.mDataBufferOffset -= procSize;
            }
            if (this.mDataBufferOffset >= 0) {
                System.arraycopy(this.mDataBuffer, decSize, this.mDataBuffer, 0, this.mDataBufferOffset);
                return 0;
            }
            this.mDataBufferOffset = 0;
            return 0;
        }
        for (int i = 0; i < iFrames && this.mPlayState == 0; this.mPCMDataBufferOffset += decOutSize, this.mDataBufferOffset -= this.mDecInBufferSize, ++i) {
            System.arraycopy(this.mDataBuffer, i * this.mDecInBufferSize, this.mDecInBuffer, 0, this.mDecInBufferSize);
            decOutSize = this.mAudioCodec.decodeAudioData(this.mDecInBuffer, this.mDecInBufferSize, this.mDecOutBuffer);
            if (decOutSize < 0) {
                this.mDataBufferOffset = 0;
                return -2147483640;
            }
            if (this.mDataCallBack != null) {
                this.mDataCallBack.onPlayDataCallBack(this.mDecOutBuffer, decOutSize);
            }
            if (this.mPCMDataBufferOffset + decOutSize > this.mPCMDataBuffer.length) {
                Log.e((String)"AudioPlayer", (String)"inputData: g711 pcm buffer overflow");
                return -2147483631;
            }
            byte[] byArray = this.mPCMDataBuffer;
            // MONITORENTER : this.mPCMDataBuffer
            if (this.mPCMDataBufferOffset >= 0) {
                System.arraycopy(this.mDecOutBuffer, 0, this.mPCMDataBuffer, this.mPCMDataBufferOffset, decOutSize);
            }
            // MONITOREXIT : byArray
        }
        int decSize = iFrames * this.mDecInBufferSize;
        if (this.mDataBufferOffset >= 0) {
            System.arraycopy(this.mDataBuffer, decSize, this.mDataBuffer, 0, this.mDataBufferOffset);
            return 0;
        }
        this.mDataBufferOffset = 0;
        return 0;
    }

    public void setAudioPlayParam(AudioCodecParam param) {
        this.mSampleRateInHz = param.nSampleRate;
    }

    public void setPlayIntercomType(boolean bFlag) {
        this.mIntercomType = bFlag;
    }

    protected boolean initAudioFormat(int audioType) {
        this.mAudioType = audioType;
        if (2 == audioType || 1 == audioType) {
            this.mDecInBufferSize = 160;
            this.mDecOutSize = 320;
        } else if (3 == audioType) {
            this.mDecInBufferSize = 80;
            this.mDecOutSize = 1280;
        } else if (7 == audioType) {
            this.mDecInBufferSize = 40;
            this.mDecOutSize = 480;
        } else if (4 == audioType) {
            this.mDecInBufferSize = 80;
            this.mDecOutSize = 640;
        } else if (8 == audioType) {
            this.mDecInBufferSize = 10;
            this.mDecOutSize = 160;
        } else if (6 == audioType) {
            this.mDecInBufferSize = 2048;
            this.mDecOutSize = 4096;
            this.mDataBufferSize = 102400;
        } else if (5 == audioType) {
            this.mDecInBufferSize = 144;
            this.mDecOutSize = 4608;
            this.mDataBufferSize = 115200;
        } else if (9 == audioType) {
            this.mDecInBufferSize = 2048;
            this.mDecOutSize = 2048;
            this.mDataBufferSize = 102400;
        } else if (10 == audioType) {
            this.mDecInBufferSize = 2048;
            this.mDecOutSize = 2048;
            this.mDataBufferSize = 102400;
        } else {
            return false;
        }
        return true;
    }

    public synchronized void setAudioDataCallBack(AudioEngineCallBack.PlayDataCallBack dataCbf) {
        this.mDataCallBack = dataCbf;
    }

    public synchronized void setErrorInfoCallBack(AudioEngineCallBack.ErrorInfoCallBack dataCbf) {
    }

    public void setWriteFile(boolean bIsWrite) {
        this.mbIsWrite = bIsWrite;
    }

    public int setPlayBuffSize(int nPlayBuffType, int nBuffSize) {
        if (nPlayBuffType != 3) {
            return -2147483645;
        }
        if (nBuffSize <= this.mPCMDataBufferSize) {
            return -2147483645;
        }
        if (this.mPlayState == 0) {
            return -2147483628;
        }
        this.mPCMDataBufferSize = nBuffSize;
        return 0;
    }

    public int setAECType(int nType) {
        if (this.mPlayState == 0) {
            return -2147483628;
        }
        this.mAECTYpe = nType;
        return 0;
    }

    public void setWriteFileEx(boolean bIsWrite, String sAddr) {
        this.mbIsWrite = bIsWrite;
        this.msAddr = sAddr;
    }
}

