/*
 * Decompiled with CFR 0.152.
 */
package com.eziot.smart;

import android.app.Application;
import com.eziot.common.http.bean.BaseRespV3;
import com.eziot.common.http.callback.IEZIoTResultCallback;
import com.eziot.common.http.callback.IResultCallback;
import com.eziot.common.http.core.RetrofitFactory;
import com.eziot.common.http.core.adapter.call.EzvizCall;
import com.eziot.common.http.core.adapter.call.EzvizCallback;
import com.eziot.common.model.BaseParams;
import com.eziot.common.utils.LocalInfo;
import com.eziot.smart.ScenePresenter;
import com.eziot.smart.http.api.SceneApi;
import com.eziot.smart.http.bean.BaseRuleInfo;
import com.eziot.smart.http.bean.GetActionDeviceDetailResp;
import com.eziot.smart.http.bean.GetEventConDeviceDetailResp;
import com.eziot.smart.http.bean.GetEventConDeviceListResp;
import com.eziot.smart.http.bean.GetSceneDetailResp;
import com.eziot.smart.http.bean.GetSimpleSceneListResp;
import com.eziot.smart.http.bean.GetStatusConDeviceDetailResp;
import com.eziot.smart.http.bean.SceneInfoReq;
import com.eziot.smart.model.ActionInfo;
import com.eziot.smart.model.CategoryInfo;
import com.eziot.smart.model.ConditionInfo;
import com.eziot.smart.model.EffectTimeInfo;
import com.eziot.smart.model.EventConditionInfo;
import com.eziot.smart.model.FeatureDeviceDetailInfo;
import com.eziot.smart.model.FeatureDeviceInfo;
import com.eziot.smart.model.SceneInfo;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class EZIoTSmartManager {
    private static volatile EZIoTSmartManager ezIoTSmartManager;
    private SceneApi mSceneApi;
    private ScenePresenter mPresenter = new ScenePresenter();

    private EZIoTSmartManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EZIoTSmartManager getInstance() {
        if (ezIoTSmartManager != null) return ezIoTSmartManager;
        Class<EZIoTSmartManager> clazz = EZIoTSmartManager.class;
        synchronized (EZIoTSmartManager.class) {
            if (ezIoTSmartManager != null) return ezIoTSmartManager;
            ezIoTSmartManager = new EZIoTSmartManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ezIoTSmartManager;
        }
    }

    public void initWithParams(Application application, BaseParams params) {
        LocalInfo.init((Application)application);
        LocalInfo.getInstance().setAppId(params.getAppId());
        LocalInfo.getInstance().setSession(params.getSessionId());
        LocalInfo.getInstance().setApiDomain(params.getApiDomain());
        this.mSceneApi = (SceneApi)RetrofitFactory.createV3().create(SceneApi.class);
    }

    public void getAutoSceneList(int page, int pageSize, int familyId, final IEZIoTResultCallback<GetSimpleSceneListResp> callback) {
        this.mSceneApi.getAutoSceneList(page, pageSize, familyId).enqueue((EzvizCallback)new EzvizCallback<GetSimpleSceneListResp>(){

            public void onPrepare(EzvizCall<GetSimpleSceneListResp> call) {
            }

            public void onResponse(EzvizCall<GetSimpleSceneListResp> call, GetSimpleSceneListResp result) {
                callback.onSuccess((Object)result);
            }

            public void onFailure(EzvizCall<GetSimpleSceneListResp> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void getManualSceneList(int page, int pageSize, int familyId, final IEZIoTResultCallback<GetSimpleSceneListResp> callback) {
        this.mSceneApi.getManualSceneList(page, pageSize, familyId).enqueue((EzvizCallback)new EzvizCallback<GetSimpleSceneListResp>(){

            public void onPrepare(EzvizCall<GetSimpleSceneListResp> call) {
            }

            public void onResponse(EzvizCall<GetSimpleSceneListResp> call, GetSimpleSceneListResp result) {
                callback.onSuccess((Object)result);
            }

            public void onFailure(EzvizCall<GetSimpleSceneListResp> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void getSceneDetail(int sceneId, final IEZIoTResultCallback<SceneInfo> callback) {
        this.mSceneApi.getSceneDetail(sceneId).enqueue((EzvizCallback)new EzvizCallback<GetSceneDetailResp>(){

            public void onPrepare(EzvizCall<GetSceneDetailResp> call) {
            }

            public void onResponse(EzvizCall<GetSceneDetailResp> call, GetSceneDetailResp result) {
                SceneInfo sceneInfo = EZIoTSmartManager.this.mPresenter.convertSceneDetail(result.sceneInfo);
                callback.onSuccess((Object)sceneInfo);
            }

            public void onFailure(EzvizCall<GetSceneDetailResp> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void executeScene(int sceneId, final IResultCallback callback) {
        this.mSceneApi.executeScene(sceneId).enqueue((EzvizCallback)new EzvizCallback<BaseRespV3>(){

            public void onPrepare(EzvizCall<BaseRespV3> call) {
            }

            public void onResponse(EzvizCall<BaseRespV3> call, BaseRespV3 result) {
                callback.onSuccess();
            }

            public void onFailure(EzvizCall<BaseRespV3> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void deleteScene(int sceneId, final IResultCallback callback) {
        this.mSceneApi.deleteScene(sceneId).enqueue((EzvizCallback)new EzvizCallback<BaseRespV3>(){

            public void onPrepare(EzvizCall<BaseRespV3> call) {
            }

            public void onResponse(EzvizCall<BaseRespV3> call, BaseRespV3 result) {
                callback.onSuccess();
            }

            public void onFailure(EzvizCall<BaseRespV3> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void operateAutoScene(int sceneId, boolean enable, final IResultCallback callback) {
        this.mSceneApi.operateAutoScene(sceneId, enable ? 1 : 0).enqueue((EzvizCallback)new EzvizCallback<BaseRespV3>(){

            public void onPrepare(EzvizCall<BaseRespV3> call) {
            }

            public void onResponse(EzvizCall<BaseRespV3> call, BaseRespV3 result) {
                callback.onSuccess();
            }

            public void onFailure(EzvizCall<BaseRespV3> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void createScene(String sceneName, boolean homePageShowSwitch, int familyId, int sceneType, EffectTimeInfo effectTimeInfo, EventConditionInfo eventConditionInfo, List<ConditionInfo> conditionInfos, List<ActionInfo> actionInfos, final IResultCallback callback) {
        SceneInfoReq req = new SceneInfoReq();
        req.onInfoQo = eventConditionInfo;
        req.thenInfoQos = actionInfos;
        req.ifInfoQos = conditionInfos;
        BaseRuleInfo baseRuleInfo = new BaseRuleInfo();
        baseRuleInfo.enableSwitch = 1;
        baseRuleInfo.homePageDisplaySwitch = homePageShowSwitch ? 1 : 0;
        baseRuleInfo.familyId = familyId;
        baseRuleInfo.ruleName = sceneName;
        baseRuleInfo.weekdays = effectTimeInfo.getWeekdays();
        baseRuleInfo.startTime = effectTimeInfo.getStartTime();
        baseRuleInfo.endTime = effectTimeInfo.getEndTime();
        baseRuleInfo.sceneType = sceneType;
        req.ruleBaseInfoQo = baseRuleInfo;
        this.mSceneApi.createScene(req).enqueue((EzvizCallback)new EzvizCallback<BaseRespV3>(){

            public void onPrepare(EzvizCall<BaseRespV3> call) {
            }

            public void onResponse(EzvizCall<BaseRespV3> call, BaseRespV3 result) {
                callback.onSuccess();
            }

            public void onFailure(EzvizCall<BaseRespV3> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void createScene(String sceneName, boolean homePageShowSwitch, int familyId, int sceneType, EventConditionInfo eventConditionInfo, List<ConditionInfo> conditionInfos, List<ActionInfo> actionInfos, IResultCallback callback) {
        EffectTimeInfo effectTimeInfo = new EffectTimeInfo();
        effectTimeInfo.setStartTime("00:00");
        effectTimeInfo.setEndTime("T00:00");
        effectTimeInfo.setWeekdays("[1,2,3,4,5,6,7]");
        this.createScene(sceneName, homePageShowSwitch, familyId, sceneType, effectTimeInfo, eventConditionInfo, conditionInfos, actionInfos, callback);
    }

    public void createScene(String sceneName, int familyId, int sceneType, EventConditionInfo eventConditionInfo, List<ConditionInfo> conditionInfos, List<ActionInfo> actionInfos, IResultCallback callback) {
        EffectTimeInfo effectTimeInfo = new EffectTimeInfo();
        effectTimeInfo.setStartTime("00:00");
        effectTimeInfo.setEndTime("T00:00");
        effectTimeInfo.setWeekdays("[1,2,3,4,5,6,7]");
        this.createScene(sceneName, true, familyId, sceneType, effectTimeInfo, eventConditionInfo, conditionInfos, actionInfos, callback);
    }

    public void modifyScene(SceneInfo sceneInfo, final IResultCallback callback) {
        SceneInfoReq sceneInfoReq = this.mPresenter.convertSceneInfoReq(sceneInfo);
        this.mSceneApi.modifyScene(sceneInfoReq).enqueue((EzvizCallback)new EzvizCallback<BaseRespV3>(){

            public void onPrepare(EzvizCall<BaseRespV3> call) {
            }

            public void onResponse(EzvizCall<BaseRespV3> call, BaseRespV3 result) {
                callback.onSuccess();
            }

            public void onFailure(EzvizCall<BaseRespV3> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void getEventConCategoryList(IEZIoTResultCallback<List<CategoryInfo>> callback) {
        CategoryInfo timeCategoryInfo = new CategoryInfo();
        timeCategoryInfo.setCategoryTag("TIMING");
        timeCategoryInfo.setCategoryTitle("\u5b9a\u65f6\u89e6\u53d1");
        timeCategoryInfo.setCategoryStatement("\u5982\uff1a\u6bcf\u5929\u65e9\u4e0a7\u70b9");
        CategoryInfo deviceCategoryInfo = new CategoryInfo();
        deviceCategoryInfo.setCategoryTag("DEVICE");
        deviceCategoryInfo.setCategoryTitle("\u8bbe\u5907\u89e6\u53d1");
        deviceCategoryInfo.setCategoryStatement("\u5982\uff1a\u5ba2\u5385\u7684\u8bbe\u5907\u6253\u5f00\u65f6");
        ArrayList<CategoryInfo> categoryInfos = new ArrayList<CategoryInfo>();
        categoryInfos.add(timeCategoryInfo);
        categoryInfos.add(deviceCategoryInfo);
        callback.onSuccess(categoryInfos);
    }

    public void getStatusConCategoryList(IEZIoTResultCallback<List<CategoryInfo>> callback) {
        CategoryInfo deviceCategoryInfo = new CategoryInfo();
        deviceCategoryInfo.setCategoryTag("DEVICE");
        deviceCategoryInfo.setCategoryTitle("\u8bbe\u5907\u89e6\u53d1");
        deviceCategoryInfo.setCategoryStatement("\u5982\uff1a\u5ba2\u5385\u7684\u8bbe\u5907\u6253\u5f00\u65f6");
        ArrayList<CategoryInfo> categoryInfos = new ArrayList<CategoryInfo>();
        categoryInfos.add(deviceCategoryInfo);
        callback.onSuccess(categoryInfos);
    }

    public void getEventConDeviceList(final IEZIoTResultCallback<List<FeatureDeviceInfo>> callback) {
        this.mSceneApi.getEventConDeviceList().enqueue((EzvizCallback)new EzvizCallback<GetEventConDeviceListResp>(){

            public void onPrepare(EzvizCall<GetEventConDeviceListResp> call) {
            }

            public void onResponse(EzvizCall<GetEventConDeviceListResp> call, GetEventConDeviceListResp result) {
                callback.onSuccess(result.featureDeviceInfos);
            }

            public void onFailure(EzvizCall<GetEventConDeviceListResp> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void getEventConDeviceRuleDetail(FeatureDeviceInfo featureDeviceInfo, final IEZIoTResultCallback<List<FeatureDeviceDetailInfo>> callback) {
        this.mSceneApi.getEventConDeviceRuleDetail(featureDeviceInfo.getDeviceSerial(), featureDeviceInfo.getLocalIndex()).enqueue((EzvizCallback)new EzvizCallback<GetEventConDeviceDetailResp>(){

            public void onPrepare(EzvizCall<GetEventConDeviceDetailResp> call) {
            }

            public void onResponse(EzvizCall<GetEventConDeviceDetailResp> call, GetEventConDeviceDetailResp result) {
                List<GetEventConDeviceDetailResp.OnFeatureDeviceInfo> onFeatureDeviceDetailInfos = result.featureDeviceDetailInfos;
                ArrayList<FeatureDeviceDetailInfo> featureDeviceDetailInfos = new ArrayList<FeatureDeviceDetailInfo>();
                for (GetEventConDeviceDetailResp.OnFeatureDeviceInfo onFeatureDeviceInfo : onFeatureDeviceDetailInfos) {
                    FeatureDeviceDetailInfo featureDeviceDetailInfo = new FeatureDeviceDetailInfo();
                    featureDeviceDetailInfo.setCategory(onFeatureDeviceInfo.onType);
                    featureDeviceDetailInfo.setType(onFeatureDeviceInfo.onSubType);
                    featureDeviceDetailInfo.setFeatureSchema(onFeatureDeviceInfo.featureSchema.toString());
                    featureDeviceDetailInfo.setDomainIdentifier(onFeatureDeviceInfo.domainIdentifier);
                    featureDeviceDetailInfo.setIdentifier(onFeatureDeviceInfo.identifier);
                    featureDeviceDetailInfo.setFeatureItems(EZIoTSmartManager.this.mPresenter.parseFeatureSchema(featureDeviceDetailInfo));
                    featureDeviceDetailInfos.add(featureDeviceDetailInfo);
                }
                callback.onSuccess(featureDeviceDetailInfos);
            }

            public void onFailure(EzvizCall<GetEventConDeviceDetailResp> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void getStatusConDeviceList(final IEZIoTResultCallback<List<FeatureDeviceInfo>> callback) {
        this.mSceneApi.getStatusConDeviceList().enqueue((EzvizCallback)new EzvizCallback<GetEventConDeviceListResp>(){

            public void onPrepare(EzvizCall<GetEventConDeviceListResp> call) {
            }

            public void onResponse(EzvizCall<GetEventConDeviceListResp> call, GetEventConDeviceListResp result) {
                callback.onSuccess(result.featureDeviceInfos);
            }

            public void onFailure(EzvizCall<GetEventConDeviceListResp> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void getStatusConDeviceRuleDetail(FeatureDeviceInfo featureDeviceInfo, final IEZIoTResultCallback<List<FeatureDeviceDetailInfo>> callback) {
        this.mSceneApi.getStatusConDeviceRuleDetail(featureDeviceInfo.getDeviceSerial(), featureDeviceInfo.getLocalIndex()).enqueue((EzvizCallback)new EzvizCallback<GetStatusConDeviceDetailResp>(){

            public void onPrepare(EzvizCall<GetStatusConDeviceDetailResp> call) {
            }

            public void onResponse(EzvizCall<GetStatusConDeviceDetailResp> call, GetStatusConDeviceDetailResp result) {
                List<GetStatusConDeviceDetailResp.IfFeatureDeviceInfo> iFeatureDeviceDetailInfos = result.featureDeviceDetailInfos;
                ArrayList<FeatureDeviceDetailInfo> featureDeviceDetailInfos = new ArrayList<FeatureDeviceDetailInfo>();
                for (GetStatusConDeviceDetailResp.IfFeatureDeviceInfo onFeatureDeviceInfo : iFeatureDeviceDetailInfos) {
                    FeatureDeviceDetailInfo featureDeviceDetailInfo = new FeatureDeviceDetailInfo();
                    featureDeviceDetailInfo.setCategory(onFeatureDeviceInfo.conditionCategory);
                    featureDeviceDetailInfo.setType(onFeatureDeviceInfo.conditionType);
                    featureDeviceDetailInfo.setFeatureSchema(onFeatureDeviceInfo.featureSchema.toString());
                    featureDeviceDetailInfo.setDomainIdentifier(onFeatureDeviceInfo.domainIdentifier);
                    featureDeviceDetailInfo.setIdentifier(onFeatureDeviceInfo.identifier);
                    featureDeviceDetailInfo.setFeatureItems(EZIoTSmartManager.this.mPresenter.parseFeatureSchema(featureDeviceDetailInfo));
                    featureDeviceDetailInfos.add(featureDeviceDetailInfo);
                }
                callback.onSuccess(featureDeviceDetailInfos);
            }

            public void onFailure(EzvizCall<GetStatusConDeviceDetailResp> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public EventConditionInfo createTimeEventCondition(String hourTime, String minTime, int[] recycleData) {
        EventConditionInfo conditionInfo = new EventConditionInfo();
        JSONObject data = new JSONObject();
        try {
            data.put("minute", (Object)minTime);
            data.put("hour", (Object)hourTime);
            data.put("weeks", (Object)recycleData);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        conditionInfo.setEventData(data);
        conditionInfo.setEventType("TIME_EVENT");
        conditionInfo.setEventSubType("TIMING");
        conditionInfo.setEventSource("0");
        return conditionInfo;
    }

    public EventConditionInfo createEventDeviceCondition(FeatureDeviceInfo featureDeviceInfo, FeatureDeviceDetailInfo featureDetailDeviceInfo, FeatureDeviceDetailInfo.FeatureItem featureItem) {
        EventConditionInfo conditionInfo = new EventConditionInfo();
        conditionInfo.setDataType(featureItem.getDataType());
        conditionInfo.setDomainIdentifier(featureDetailDeviceInfo.getDomainIdentifier());
        conditionInfo.setEventData(featureItem.getFeatureValue());
        conditionInfo.setEventDesc(featureItem.getFeatureName());
        conditionInfo.setEventSource(featureDeviceInfo.getDeviceSerial());
        conditionInfo.setEventSubType("DEVICE_EVENT_V3_EVENT");
        conditionInfo.setEventType("DEVICE_EVENT");
        conditionInfo.setIdentifier(featureDetailDeviceInfo.getIdentifier());
        conditionInfo.setJudgeMethod(featureItem.getJudgeMethod());
        conditionInfo.setLocalIndex(featureDeviceInfo.getLocalIndex());
        conditionInfo.setResourceName(featureDeviceInfo.getResourceName());
        conditionInfo.setResourceType("");
        conditionInfo.setDeviceType(featureDeviceInfo.getDeviceType());
        conditionInfo.setGroupName(featureDeviceInfo.getGroupName());
        conditionInfo.setGroupId(featureDeviceInfo.getGroupId());
        conditionInfo.setOnline(featureDeviceInfo.isOnline());
        return conditionInfo;
    }

    public ConditionInfo createStatusDeviceCondition(FeatureDeviceInfo featureDeviceInfo, FeatureDeviceDetailInfo featureDetailDeviceInfo, FeatureDeviceDetailInfo.FeatureItem featureItem) {
        ConditionInfo conditionInfo = new ConditionInfo();
        conditionInfo.setDataType(featureItem.getDataType());
        conditionInfo.setDomainIdentifier(featureDetailDeviceInfo.getDomainIdentifier());
        conditionInfo.setConditionData(featureItem.getFeatureValue());
        conditionInfo.setConditionDesc(featureItem.getFeatureName());
        conditionInfo.setConditionSource(featureDeviceInfo.getDeviceSerial());
        conditionInfo.setConditionCategory("DEVICE_STATUS");
        conditionInfo.setConditionType("V3_STATUS");
        conditionInfo.setIdentifier(featureDetailDeviceInfo.getIdentifier());
        conditionInfo.setJudgeMethod(featureItem.getJudgeMethod());
        conditionInfo.setLocalIndex(featureDeviceInfo.getLocalIndex());
        conditionInfo.setResourceName(featureDeviceInfo.getResourceName());
        conditionInfo.setResourceType("");
        conditionInfo.setDeviceType(featureDeviceInfo.getDeviceType());
        conditionInfo.setGroupName(featureDeviceInfo.getGroupName());
        conditionInfo.setGroupId(featureDeviceInfo.getGroupId());
        conditionInfo.setOnline(featureDeviceInfo.isOnline());
        return conditionInfo;
    }

    public ActionInfo createDeviceAction(FeatureDeviceInfo featureDeviceInfo, FeatureDeviceDetailInfo featureDetailDeviceInfo, FeatureDeviceDetailInfo.FeatureItem featureItem) {
        ActionInfo actionInfo = new ActionInfo();
        actionInfo.setDataType(featureItem.getDataType());
        actionInfo.setDomainIdentifier(featureDetailDeviceInfo.getDomainIdentifier());
        actionInfo.setActionParams(featureItem.getFeatureValue());
        actionInfo.setActionParamsDesc(featureItem.getFeatureName());
        actionInfo.setActionTarget(featureDeviceInfo.getDeviceSerial());
        actionInfo.setTargetCategory("DEVICE_ACTION");
        actionInfo.setActionType("V3_STATUS");
        actionInfo.setIdentifier(featureDetailDeviceInfo.getIdentifier());
        actionInfo.setLocalIndex(featureDeviceInfo.getLocalIndex());
        actionInfo.setResourceName(featureDeviceInfo.getResourceName());
        actionInfo.setResourceCategory("");
        actionInfo.setDeviceType(featureDeviceInfo.getDeviceType());
        actionInfo.setGroupName(featureDeviceInfo.getGroupName());
        actionInfo.setGroupId(featureDeviceInfo.getGroupId());
        actionInfo.setOnline(featureDeviceInfo.isOnline());
        return actionInfo;
    }

    public ActionInfo createSceneAction(int sceneId) {
        ActionInfo actionInfo = new ActionInfo();
        actionInfo.setActionParams(sceneId);
        actionInfo.setActionType("LINK_SCENE");
        actionInfo.setTargetCategory("MANUAL_ACTION");
        return actionInfo;
    }

    public ActionInfo createDelayAction(int delayTime) {
        ActionInfo actionInfo = new ActionInfo();
        actionInfo.setActionParams(delayTime);
        actionInfo.setActionType("TIME_OPERATE");
        actionInfo.setTargetCategory("MANUAL_ACTION");
        return actionInfo;
    }

    public void getActionDeviceList(final IEZIoTResultCallback<List<FeatureDeviceInfo>> callback) {
        this.mSceneApi.getActionDeviceList().enqueue((EzvizCallback)new EzvizCallback<GetEventConDeviceListResp>(){

            public void onPrepare(EzvizCall<GetEventConDeviceListResp> call) {
            }

            public void onResponse(EzvizCall<GetEventConDeviceListResp> call, GetEventConDeviceListResp result) {
                callback.onSuccess(result.featureDeviceInfos);
            }

            public void onFailure(EzvizCall<GetEventConDeviceListResp> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }

    public void getActionDeviceRuleDetail(FeatureDeviceInfo featureDeviceInfo, final IEZIoTResultCallback<List<FeatureDeviceDetailInfo>> callback) {
        this.mSceneApi.getActionDeviceRuleDetail(featureDeviceInfo.getDeviceSerial(), featureDeviceInfo.getLocalIndex()).enqueue((EzvizCallback)new EzvizCallback<GetActionDeviceDetailResp>(){

            public void onPrepare(EzvizCall<GetActionDeviceDetailResp> call) {
            }

            public void onResponse(EzvizCall<GetActionDeviceDetailResp> call, GetActionDeviceDetailResp result) {
                List<GetActionDeviceDetailResp.ThenFeatureDeviceInfo> thenFeatureDeviceDetailInfos = result.featureDeviceDetailInfos;
                ArrayList<FeatureDeviceDetailInfo> featureDeviceDetailInfos = new ArrayList<FeatureDeviceDetailInfo>();
                for (GetActionDeviceDetailResp.ThenFeatureDeviceInfo thenFeatureDeviceInfo : thenFeatureDeviceDetailInfos) {
                    FeatureDeviceDetailInfo featureDeviceDetailInfo = new FeatureDeviceDetailInfo();
                    featureDeviceDetailInfo.setCategory(thenFeatureDeviceInfo.actionCategory);
                    featureDeviceDetailInfo.setType(thenFeatureDeviceInfo.actionType);
                    featureDeviceDetailInfo.setFeatureSchema(thenFeatureDeviceInfo.featureSchema.toString());
                    featureDeviceDetailInfo.setDomainIdentifier(thenFeatureDeviceInfo.domainIdentifier);
                    featureDeviceDetailInfo.setIdentifier(thenFeatureDeviceInfo.identifier);
                    featureDeviceDetailInfo.setFeatureItems(EZIoTSmartManager.this.mPresenter.parseFeatureSchema(featureDeviceDetailInfo));
                    featureDeviceDetailInfos.add(featureDeviceDetailInfo);
                }
                callback.onSuccess(featureDeviceDetailInfos);
            }

            public void onFailure(EzvizCall<GetActionDeviceDetailResp> call, Throwable throwable, int errorCode, String errorDesc) {
                callback.onError(errorCode, errorDesc);
            }
        });
    }
}

