/*
 * Decompiled with CFR 0.152.
 */
package me.everything.android.ui.overscroll.adapters;

import android.graphics.Canvas;
import android.view.View;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import java.util.List;
import me.everything.android.ui.overscroll.adapters.IOverScrollDecoratorAdapter;

public class RecyclerViewOverScrollDecorAdapter
implements IOverScrollDecoratorAdapter {
    protected final RecyclerView mRecyclerView;
    protected final Impl mImpl;
    protected boolean mIsItemTouchInEffect = false;

    public RecyclerViewOverScrollDecorAdapter(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager || layoutManager instanceof StaggeredGridLayoutManager) {
            int orientation;
            int n = orientation = layoutManager instanceof LinearLayoutManager ? ((LinearLayoutManager)layoutManager).getOrientation() : ((StaggeredGridLayoutManager)layoutManager).getOrientation();
            this.mImpl = orientation == 0 ? new ImplHorizLayout() : new ImplVerticalLayout();
        } else {
            throw new IllegalArgumentException("Recycler views with custom layout managers are not supported by this adapter out of the box.Try implementing and providing an explicit 'impl' parameter to the other c'tors, or otherwise create a custom adapter subclass of your own.");
        }
    }

    public RecyclerViewOverScrollDecorAdapter(RecyclerView recyclerView, Impl impl) {
        this.mRecyclerView = recyclerView;
        this.mImpl = impl;
    }

    public RecyclerViewOverScrollDecorAdapter(RecyclerView recyclerView, ItemTouchHelper.Callback itemTouchHelperCallback) {
        this(recyclerView);
        this.setUpTouchHelperCallback(itemTouchHelperCallback);
    }

    public RecyclerViewOverScrollDecorAdapter(RecyclerView recyclerView, Impl impl, ItemTouchHelper.Callback itemTouchHelperCallback) {
        this(recyclerView, impl);
        this.setUpTouchHelperCallback(itemTouchHelperCallback);
    }

    protected void setUpTouchHelperCallback(ItemTouchHelper.Callback itemTouchHelperCallback) {
        new ItemTouchHelper((ItemTouchHelper.Callback)new ItemTouchHelperCallbackWrapper(itemTouchHelperCallback){

            @Override
            public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
                RecyclerViewOverScrollDecorAdapter.this.mIsItemTouchInEffect = actionState != 0;
                super.onSelectedChanged(viewHolder, actionState);
            }
        }).attachToRecyclerView(this.mRecyclerView);
    }

    @Override
    public View getView() {
        return this.mRecyclerView;
    }

    @Override
    public boolean isInAbsoluteStart() {
        return !this.mIsItemTouchInEffect && this.mImpl.isInAbsoluteStart();
    }

    @Override
    public boolean isInAbsoluteEnd() {
        return !this.mIsItemTouchInEffect && this.mImpl.isInAbsoluteEnd();
    }

    private static class ItemTouchHelperCallbackWrapper
    extends ItemTouchHelper.Callback {
        final ItemTouchHelper.Callback mCallback;

        private ItemTouchHelperCallbackWrapper(ItemTouchHelper.Callback callback) {
            this.mCallback = callback;
        }

        public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return this.mCallback.getMovementFlags(recyclerView, viewHolder);
        }

        public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
            return this.mCallback.onMove(recyclerView, viewHolder, target);
        }

        public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
            this.mCallback.onSwiped(viewHolder, direction);
        }

        public int convertToAbsoluteDirection(int flags, int layoutDirection) {
            return this.mCallback.convertToAbsoluteDirection(flags, layoutDirection);
        }

        public boolean canDropOver(RecyclerView recyclerView, RecyclerView.ViewHolder current, RecyclerView.ViewHolder target) {
            return this.mCallback.canDropOver(recyclerView, current, target);
        }

        public boolean isLongPressDragEnabled() {
            return this.mCallback.isLongPressDragEnabled();
        }

        public boolean isItemViewSwipeEnabled() {
            return this.mCallback.isItemViewSwipeEnabled();
        }

        public int getBoundingBoxMargin() {
            return this.mCallback.getBoundingBoxMargin();
        }

        public float getSwipeThreshold(RecyclerView.ViewHolder viewHolder) {
            return this.mCallback.getSwipeThreshold(viewHolder);
        }

        public float getMoveThreshold(RecyclerView.ViewHolder viewHolder) {
            return this.mCallback.getMoveThreshold(viewHolder);
        }

        public RecyclerView.ViewHolder chooseDropTarget(RecyclerView.ViewHolder selected, List<RecyclerView.ViewHolder> dropTargets, int curX, int curY) {
            return this.mCallback.chooseDropTarget(selected, dropTargets, curX, curY);
        }

        public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
            this.mCallback.onSelectedChanged(viewHolder, actionState);
        }

        public void onMoved(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, int fromPos, RecyclerView.ViewHolder target, int toPos, int x, int y) {
            this.mCallback.onMoved(recyclerView, viewHolder, fromPos, target, toPos, x, y);
        }

        public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            this.mCallback.clearView(recyclerView, viewHolder);
        }

        public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            this.mCallback.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }

        public void onChildDrawOver(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            this.mCallback.onChildDrawOver(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }

        public long getAnimationDuration(RecyclerView recyclerView, int animationType, float animateDx, float animateDy) {
            return this.mCallback.getAnimationDuration(recyclerView, animationType, animateDx, animateDy);
        }

        public int interpolateOutOfBoundsScroll(RecyclerView recyclerView, int viewSize, int viewSizeOutOfBounds, int totalSize, long msSinceStartScroll) {
            return this.mCallback.interpolateOutOfBoundsScroll(recyclerView, viewSize, viewSizeOutOfBounds, totalSize, msSinceStartScroll);
        }
    }

    protected class ImplVerticalLayout
    implements Impl {
        protected ImplVerticalLayout() {
        }

        @Override
        public boolean isInAbsoluteStart() {
            return !RecyclerViewOverScrollDecorAdapter.this.mRecyclerView.canScrollVertically(-1);
        }

        @Override
        public boolean isInAbsoluteEnd() {
            return !RecyclerViewOverScrollDecorAdapter.this.mRecyclerView.canScrollVertically(1);
        }
    }

    protected class ImplHorizLayout
    implements Impl {
        protected ImplHorizLayout() {
        }

        @Override
        public boolean isInAbsoluteStart() {
            return !RecyclerViewOverScrollDecorAdapter.this.mRecyclerView.canScrollHorizontally(-1);
        }

        @Override
        public boolean isInAbsoluteEnd() {
            return !RecyclerViewOverScrollDecorAdapter.this.mRecyclerView.canScrollHorizontally(1);
        }
    }

    protected static interface Impl {
        public boolean isInAbsoluteStart();

        public boolean isInAbsoluteEnd();
    }
}

