/*
 * Decompiled with CFR 0.152.
 */
package io.github.endreman0.javajson;

import io.github.endreman0.javajson.nodes.ArrayNode;
import io.github.endreman0.javajson.nodes.BooleanNode;
import io.github.endreman0.javajson.nodes.Node;
import io.github.endreman0.javajson.nodes.NullNode;
import io.github.endreman0.javajson.nodes.NumberNode;
import io.github.endreman0.javajson.nodes.ObjectNode;
import io.github.endreman0.javajson.nodes.StringNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;

public class JavaJson {
    public static Node parse(String json) {
        return JavaJson.parse(CharBuffer.wrap(json));
    }

    public static Node parse(File file, Charset charset) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), charset);){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            Node node = JavaJson.parse(sb.toString());
            return node;
        }
    }

    public static Node parse(InputStream in) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[4096];
        while (true) {
            if ((read = in.read(buffer, 0, buffer.length)) < buffer.length) break;
            sb.append(new String(buffer));
        }
        sb.append(new String(buffer).substring(0, read + 1));
        return JavaJson.parse(CharBuffer.wrap(sb.toString().toCharArray()));
    }

    protected static Node parse(CharBuffer json) {
        char start = json.get(json.position());
        if (start == 't' || start == 'f') {
            return JavaJson.parseBoolean(json);
        }
        if (Character.isDigit(start)) {
            return JavaJson.parseNumber(json);
        }
        if (start == '\"') {
            return JavaJson.parseString(json);
        }
        if (start == '[') {
            return JavaJson.parseArray(json);
        }
        if (start == '{') {
            return JavaJson.parseObject(json);
        }
        if (start == 'n') {
            return JavaJson.parseNull(json);
        }
        return null;
    }

    protected static BooleanNode parseBoolean(CharBuffer json) {
        char first = json.get();
        if (first == 't') {
            if (json.get() == 'r' && json.get() == 'u' && json.get() == 'e') {
                return new BooleanNode(true);
            }
            return null;
        }
        if (first == 'f') {
            if (json.get() == 'a' && json.get() == 'l' && json.get() == 's' && json.get() == 'e') {
                return new BooleanNode(false);
            }
            return null;
        }
        return null;
    }

    protected static NumberNode parseNumber(CharBuffer json) {
        char next;
        StringBuffer data = new StringBuffer();
        while (json.hasRemaining() && (Character.isDigit(next = json.get(json.position())) || next == '.')) {
            data.append(next);
            json.get();
        }
        return new NumberNode(Double.valueOf(data.toString()));
    }

    protected static StringNode parseString(CharBuffer json) {
        char next;
        if (json.get() != '\"') {
            return null;
        }
        StringBuffer data = new StringBuffer();
        while ((next = json.get()) != '\"') {
            data.append(next);
        }
        return new StringNode(data.toString());
    }

    protected static ArrayNode parseArray(CharBuffer json) {
        if (json.get() != '[') {
            return null;
        }
        ArrayNode node = new ArrayNode();
        while (json.hasRemaining()) {
            JavaJson.trim(json);
            node.add(JavaJson.parse(json));
            JavaJson.trim(json);
            if (json.get(json.position()) == ']') {
                json.get();
                break;
            }
            JavaJson.expect(json.get(), ',');
        }
        return node;
    }

    protected static ObjectNode parseObject(CharBuffer json) {
        JavaJson.expect(json.get(), '{');
        ObjectNode node = new ObjectNode();
        JavaJson.trim(json);
        while (json.hasRemaining() && json.get(json.position()) != '}') {
            JavaJson.expect(json.get(), '\"');
            String key = JavaJson.readFor(json, false, '\"');
            JavaJson.trim(json);
            JavaJson.expect(json.get(), ':');
            JavaJson.trim(json);
            Node value = JavaJson.parse(json);
            node.put(key, value);
            JavaJson.trim(json);
            if (json.get(json.position()) == '}') {
                json.get();
                break;
            }
            JavaJson.expect(json.get(), ',');
            JavaJson.trim(json);
        }
        return node;
    }

    protected static NullNode parseNull(CharBuffer json) {
        if (json.get() == 'n' && json.get() == 'u' && json.get() == 'l' && json.get() == 'l') {
            return new NullNode();
        }
        return null;
    }

    protected static String readFor(CharBuffer json, boolean trim, char ... targets) {
        StringBuilder buffer = new StringBuilder();
        block0: while (json.hasRemaining()) {
            char next = json.get();
            for (char target : targets) {
                if (next == target) break block0;
            }
            if (trim && (next == ' ' || next == '\r' || next == '\n' || next == '\t')) continue;
            buffer.append(next);
        }
        return buffer.toString();
    }

    protected static void trim(CharBuffer json) {
        char next;
        while (json.hasRemaining() && ((next = json.get(json.position())) == ' ' || next == '\r' || next == '\n' || next == '\t')) {
            json.get();
        }
    }

    protected static void expect(char actual, char ... expected) {
        boolean isExpected = false;
        for (char c : expected) {
            if (actual != c) continue;
            isExpected = true;
        }
        if (!isExpected) {
            StringBuffer message = new StringBuffer("Expected chars [");
            for (int i = 0; i < expected.length; ++i) {
                message.append('\'').append(expected[i]).append('\'');
                if (i >= expected.length - 1) continue;
                message.append(", ");
            }
            message.append("], got '").append(actual).append('\'');
            throw new IllegalArgumentException(message.toString());
        }
    }
}

